/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import net.sf.hale.Game;
import net.sf.hale.entity.Armor;
import net.sf.hale.entity.CreatedItem;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.EquippableItemTemplate;
import net.sf.hale.rules.ArmorType;
import net.sf.hale.util.SimpleJSONObject;

public class ArmorTemplate
extends EquippableItemTemplate {
    private final ArmorType armorType;
    private final int armorClass;
    private final int armorPenalty;
    private final int movementPenalty;
    private final int shieldAttackPenalty;

    public ArmorTemplate(String string, SimpleJSONObject simpleJSONObject) {
        super(string, simpleJSONObject);
        this.armorType = Game.ruleset.getArmorType(simpleJSONObject.get("armorType", null));
        this.armorClass = simpleJSONObject.get("armorClass", 0);
        this.armorPenalty = simpleJSONObject.get("armorPenalty", 0);
        this.movementPenalty = simpleJSONObject.get("movementPenalty", 0);
        this.shieldAttackPenalty = simpleJSONObject.get("shieldAttackPenalty", 0);
    }

    private ArmorTemplate(String string, ArmorTemplate armorTemplate, CreatedItem createdItem) {
        super(string, armorTemplate, createdItem);
        this.armorType = armorTemplate.armorType;
        this.armorClass = armorTemplate.armorClass;
        this.armorPenalty = armorTemplate.armorPenalty;
        this.movementPenalty = armorTemplate.movementPenalty;
        this.shieldAttackPenalty = armorTemplate.shieldAttackPenalty;
    }

    @Override
    public ArmorTemplate createModifiedCopy(String string, CreatedItem createdItem) {
        return new ArmorTemplate(string, this, createdItem);
    }

    @Override
    public Armor createInstance() {
        return new Armor(this);
    }

    public ArmorType getArmorType() {
        return this.armorType;
    }

    public int getArmorClass() {
        return this.armorClass;
    }

    public int getArmorPenalty() {
        return this.armorPenalty;
    }

    public int getMovementPenalty() {
        return this.movementPenalty;
    }

    public int getShieldAttackPenalty() {
        return this.shieldAttackPenalty;
    }

    @Override
    public boolean hasPrereqsToEquip(Creature creature) {
        return creature.stats.hasArmorProficiency(this.armorType.getName());
    }
}

