/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import net.sf.hale.area.Area;
import net.sf.hale.entity.ArmorTemplate;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.util.SimpleJSONObject;

public class Armor
extends EquippableItem {
    private final ArmorTemplate template;
    private float qualityArmorPenalty;
    private float qualityArmorClass;
    private float qualityMovementPenalty;

    @Override
    public void load(SimpleJSONObject simpleJSONObject, Area area, ReferenceHandler referenceHandler) throws LoadGameException {
        super.load(simpleJSONObject, area, referenceHandler);
    }

    @Override
    public JSONOrderedObject save() {
        return super.save();
    }

    protected Armor(ArmorTemplate armorTemplate) {
        super(armorTemplate);
        this.template = armorTemplate;
    }

    @Override
    public ArmorTemplate getTemplate() {
        return this.template;
    }

    public float getQualityModifiedArmorPenalty() {
        return this.qualityArmorPenalty;
    }

    public float getQualityModifiedArmorClass() {
        return this.qualityArmorClass;
    }

    public float getQualityModifiedMovementPenalty() {
        return this.qualityMovementPenalty;
    }

    @Override
    protected void setQuality(String string) {
        super.setQuality(string);
        if (this.template.hasQuality()) {
            this.qualityArmorPenalty = (float)this.template.getArmorPenalty() * (1.0f - (float)this.getQuality().getArmorPenaltyBonus() / 100.0f);
            this.qualityArmorClass = (float)this.template.getArmorClass() * (1.0f + (float)this.getQuality().getArmorClassBonus() / 100.0f);
            this.qualityMovementPenalty = (float)this.template.getMovementPenalty() * (1.0f - (float)this.getQuality().getMovementPenaltyBonus() / 100.0f);
        } else {
            this.qualityArmorPenalty = this.template.getArmorPenalty();
            this.qualityArmorClass = this.template.getArmorClass();
            this.qualityMovementPenalty = this.template.getMovementPenalty();
        }
    }
}

