/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.entity.Ammo;
import net.sf.hale.entity.CreatedItem;
import net.sf.hale.entity.EquippableItemTemplate;
import net.sf.hale.icon.SimpleIcon;
import net.sf.hale.rules.BaseWeapon;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class AmmoTemplate
extends EquippableItemTemplate {
    private final List<BaseWeapon> baseWeapons;
    private final SimpleIcon projectileIcon;

    public AmmoTemplate(String string, SimpleJSONObject simpleJSONObject) {
        super(string, simpleJSONObject);
        this.projectileIcon = new SimpleIcon(simpleJSONObject.getObject("projectileIcon"));
        this.baseWeapons = new ArrayList<BaseWeapon>(2);
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("weapons")) {
            String string2 = simpleJSONArrayEntry.getString();
            this.baseWeapons.add(Game.ruleset.getBaseWeapon(string2));
        }
    }

    private AmmoTemplate(String string, AmmoTemplate ammoTemplate, CreatedItem createdItem) {
        super(string, ammoTemplate, createdItem);
        this.projectileIcon = ammoTemplate.projectileIcon;
        this.baseWeapons = new ArrayList<BaseWeapon>(ammoTemplate.baseWeapons);
    }

    @Override
    public AmmoTemplate createModifiedCopy(String string, CreatedItem createdItem) {
        return new AmmoTemplate(string, this, createdItem);
    }

    @Override
    public Ammo createInstance() {
        return new Ammo(this);
    }

    public SimpleIcon getProjectileIcon() {
        return this.projectileIcon;
    }

    public boolean isUsableByBaseWeapon(BaseWeapon baseWeapon) {
        return this.baseWeapons.contains(baseWeapon);
    }

    public List<BaseWeapon> getUsableBaseWeapons() {
        return Collections.unmodifiableList(this.baseWeapons);
    }
}

