/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.defaultability;

import net.sf.hale.Game;
import net.sf.hale.area.Transition;
import net.sf.hale.defaultability.DefaultAbility;
import net.sf.hale.defaultability.Move;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.PC;
import net.sf.hale.interfacelock.InterfaceCallbackLock;

public class Travel
implements DefaultAbility {
    private Move move;
    private Transition target;

    @Override
    public String getActionName() {
        return "Travel";
    }

    @Override
    public boolean canActivate(PC pC, Location location) {
        this.target = location.getAreaTransition();
        if (this.target != null && this.target.isActivated()) {
            this.move = new Move();
            for (PC pC2 : Game.curCampaign.party) {
                if (location.getDistance(pC2) > 1) continue;
                return true;
            }
            return this.move.canMove(pC, location, 1);
        }
        return false;
    }

    @Override
    public void activate(PC pC, Location location) {
        boolean bl = true;
        for (PC pC2 : Game.curCampaign.party) {
            if (location.getDistance(pC2) > 1) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.move.addCallback(new TravelCallback(pC, location));
            this.move.moveTowards(pC, location, 1);
        } else {
            Game.curCampaign.transition(this.target, false);
        }
        Game.areaListener.computeMouseState();
    }

    @Override
    public DefaultAbility getInstance() {
        return new Travel();
    }

    private class TravelCallback
    implements Runnable {
        private Creature parent;
        private Location targetPosition;
        private boolean alreadyLocked;

        private TravelCallback(Creature creature, Location location) {
            this.parent = creature;
            this.targetPosition = location;
        }

        @Override
        public void run() {
            if (!this.alreadyLocked && Game.interfaceLocker.locked()) {
                InterfaceCallbackLock interfaceCallbackLock = new InterfaceCallbackLock(this.parent, Game.config.getCombatDelay());
                interfaceCallbackLock.addCallback(this);
                Game.interfaceLocker.add(interfaceCallbackLock);
                this.alreadyLocked = true;
                return;
            }
            if (this.targetPosition.getDistance(this.parent) <= 1) {
                Game.curCampaign.transition(Travel.this.target, false);
            }
        }
    }
}

