/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.defaultability;

import net.sf.hale.Game;
import net.sf.hale.defaultability.DefaultAbility;
import net.sf.hale.defaultability.Move;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.PC;

public class Talk
implements DefaultAbility {
    private Move move;
    private Creature target;

    @Override
    public String getActionName() {
        return "Talk";
    }

    @Override
    public boolean canActivate(PC pC, Location location) {
        if (Game.isInTurnMode()) {
            return false;
        }
        if (!pC.hasVisibility(location)) {
            return false;
        }
        this.target = location.getCreature();
        if (this.target != null && this.target.getTemplate().getConversation() != null) {
            this.move = new Move();
            if (location.getDistance(pC) > 3) {
                return this.move.canMove(pC, location, 3);
            }
            return true;
        }
        return false;
    }

    @Override
    public void activate(PC pC, Location location) {
        if (location.getDistance(pC) > 3) {
            this.move.addCallback(new TalkCallback(pC));
            this.move.moveTowards(pC, location, 3);
        } else {
            this.target.startConversation(pC);
        }
        Game.areaListener.computeMouseState();
    }

    @Override
    public DefaultAbility getInstance() {
        return new Talk();
    }

    private class TalkCallback
    implements Runnable {
        private PC parent;

        private TalkCallback(PC pC) {
            this.parent = pC;
        }

        @Override
        public void run() {
            if (this.parent.getLocation().getDistance(Talk.this.target) > 3) {
                return;
            }
            if (!this.parent.hasVisibility(Talk.this.target.getLocation())) {
                return;
            }
            Talk.this.target.startConversation(this.parent);
        }
    }
}

