/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.defaultability;

import de.matthiasmann.twl.Color;
import net.sf.hale.Game;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.defaultability.DefaultAbility;
import net.sf.hale.defaultability.Move;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.Trap;

public class RecoverTrap
implements DefaultAbility {
    private Move move;
    private Trap trap;

    @Override
    public String getActionName() {
        return "Recover Trap";
    }

    @Override
    public boolean canActivate(PC pC, Location location) {
        if (!pC.timer.canPerformAction("RecoverTrapCost")) {
            return false;
        }
        if (!pC.stats.has(Bonus.Type.TrapHandling)) {
            return false;
        }
        this.trap = location.getTrap();
        if (this.trap == null || !this.trap.isSpotted()) {
            return false;
        }
        this.move = new Move();
        this.move.setAllowPartyMove(false);
        if (location.getDistance(pC) > 1) {
            return this.move.canMove(pC, location, 1);
        }
        return true;
    }

    @Override
    public void activate(PC pC, Location location) {
        if (location.getDistance(pC) > 1) {
            this.move.addCallback(new RecoverCallback(pC));
            this.move.moveTowards(pC, location, 1);
        } else {
            this.recover(pC, this.trap);
        }
        Game.areaListener.computeMouseState();
    }

    public boolean recover(Creature creature, Trap trap) {
        if (creature.getLocation().getDistance(trap) > 1) {
            return false;
        }
        if (trap == null || !creature.timer.canPerformAction("RecoverTrapCost")) {
            return false;
        }
        if (!creature.stats.has(Bonus.Type.TrapHandling)) {
            return false;
        }
        creature.timer.performAction("RecoverTrapCost");
        boolean bl = trap.attemptRecover(creature);
        if (!bl) {
            Game.mainViewer.addFadeAway("Recover Trap Failed", trap.getLocation().getX(), trap.getLocation().getY(), new Color(-5527127));
        } else {
            Game.mainViewer.addFadeAway("Trap Recovered", trap.getLocation().getX(), trap.getLocation().getY(), new Color(-5527127));
        }
        return bl;
    }

    @Override
    public DefaultAbility getInstance() {
        return new RecoverTrap();
    }

    private class RecoverCallback
    implements Runnable {
        private Creature parent;

        private RecoverCallback(Creature creature) {
            this.parent = creature;
        }

        @Override
        public void run() {
            RecoverTrap.this.recover(this.parent, RecoverTrap.this.trap);
        }
    }
}

