/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.defaultability;

import de.matthiasmann.twl.Color;
import net.sf.hale.Game;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.defaultability.DefaultAbility;
import net.sf.hale.defaultability.Move;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.Openable;
import net.sf.hale.entity.PC;

public class PickLock
implements DefaultAbility {
    private Move move;
    private Openable openable;

    @Override
    public String getActionName() {
        return "Pick Lock";
    }

    @Override
    public boolean canActivate(PC pC, Location location) {
        if (!pC.timer.canPerformAction("OpenLockCost")) {
            return false;
        }
        if (!pC.stats.has(Bonus.Type.LockPicking)) {
            return false;
        }
        this.openable = location.getOpenable();
        if (this.openable == null) {
            return false;
        }
        if (!this.openable.isLocked()) {
            return false;
        }
        this.move = new Move();
        this.move.setAllowPartyMove(false);
        if (location.getDistance(pC) > 1) {
            return this.move.canMove(pC, location, 1);
        }
        return true;
    }

    @Override
    public void activate(PC pC, Location location) {
        if (location.getDistance(pC) > 1) {
            this.move.addCallback(new UnlockCallback(pC));
            this.move.moveTowards(pC, location, 1);
        } else {
            this.unlock(pC, this.openable);
        }
        Game.areaListener.computeMouseState();
    }

    public boolean unlock(Creature creature, Openable openable) {
        if (openable.getLocation().getDistance(creature) > 1) {
            return false;
        }
        if (openable == null || !creature.timer.canPerformAction("OpenLockCost")) {
            return false;
        }
        if (!creature.stats.has(Bonus.Type.LockPicking)) {
            return false;
        }
        creature.timer.performAction("OpenLockCost");
        if (!openable.isLocked()) {
            return false;
        }
        boolean bl = openable.getTemplate().hasKey() && creature.inventory.getTotalQuantity(openable.getTemplate().getKeyID()) > 0 ? openable.attemptOpen(creature) : openable.attemptUnlock(creature);
        if (!bl) {
            Game.mainViewer.addFadeAway("Pick Lock Failed", openable.getLocation().getX(), openable.getLocation().getY(), new Color(-5527127));
        } else {
            Game.mainViewer.addFadeAway("Unlocked", openable.getLocation().getX(), openable.getLocation().getY(), new Color(-5527127));
        }
        return bl;
    }

    @Override
    public DefaultAbility getInstance() {
        return new PickLock();
    }

    private class UnlockCallback
    implements Runnable {
        private Creature parent;

        private UnlockCallback(Creature creature) {
            this.parent = creature;
        }

        @Override
        public void run() {
            PickLock.this.unlock(this.parent, PickLock.this.openable);
        }
    }
}

