/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.defaultability;

import de.matthiasmann.twl.Color;
import net.sf.hale.Game;
import net.sf.hale.defaultability.DefaultAbility;
import net.sf.hale.defaultability.Move;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Door;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.PC;

public class OpenDoor
implements DefaultAbility {
    private static final String doorOpenAction = "Open Door";
    private static final String doorCloseAction = "Close Door";
    private Move move;
    private Door door;
    private String actionName;

    @Override
    public String getActionName() {
        return this.actionName;
    }

    @Override
    public boolean canActivate(PC pC, Location location) {
        if (!pC.timer.canPerformAction("OpenDoorCost")) {
            return false;
        }
        this.door = location.getDoor();
        if (this.door != null) {
            this.actionName = this.door.isOpen() ? doorCloseAction : doorOpenAction;
            this.move = new Move();
            if (location.getDistance(pC) > 1) {
                return this.move.canMove(pC, location, 1);
            }
            return true;
        }
        return false;
    }

    @Override
    public void activate(PC pC, Location location) {
        if (location.getDistance(pC) > 1) {
            this.move.addCallback(new OpenDoorCallback(pC));
            this.move.moveTowards(pC, location, 1);
        } else {
            this.toggleDoor(pC, location.getDoor());
        }
        Game.areaListener.computeMouseState();
    }

    public boolean toggleDoor(Creature creature, Door door) {
        if (creature.getLocation().getDistance(door) > 1) {
            return false;
        }
        if (door == null || !creature.timer.canPerformAction("OpenDoorCost")) {
            return false;
        }
        creature.timer.performAction("OpenDoorCost");
        if (door.isOpen()) {
            Creature creature2 = door.getLocation().getCreature();
            if (creature2 == null) {
                door.close(creature);
            } else {
                Game.mainViewer.addMessage("red", creature2.getTemplate().getName() + " blocks the door.");
            }
            return !door.isOpen();
        }
        door.attemptOpen(creature);
        if (!door.isOpen()) {
            Game.mainViewer.addFadeAway("Locked", door.getLocation().getX(), door.getLocation().getY(), new Color(-5527127));
        }
        return door.isOpen();
    }

    @Override
    public DefaultAbility getInstance() {
        return new OpenDoor();
    }

    private class OpenDoorCallback
    implements Runnable {
        private Creature parent;

        private OpenDoorCallback(Creature creature) {
            this.parent = creature;
        }

        @Override
        public void run() {
            OpenDoor.this.toggleDoor(this.parent, OpenDoor.this.door);
        }
    }
}

