/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.defaultability;

import de.matthiasmann.twl.Color;
import net.sf.hale.Game;
import net.sf.hale.defaultability.DefaultAbility;
import net.sf.hale.defaultability.Move;
import net.sf.hale.entity.Container;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.PC;

public class OpenContainer
implements DefaultAbility {
    private Move move;
    private Container container;

    @Override
    public String getActionName() {
        return "Open Container";
    }

    @Override
    public boolean canActivate(PC pC, Location location) {
        if (!pC.timer.canPerformAction("OpenContainerCost")) {
            return false;
        }
        this.container = location.getContainer();
        if (this.container != null) {
            this.move = new Move();
            this.move.setAllowPartyMove(false);
            if (location.getDistance(pC) > 1) {
                return this.move.canMove(pC, location, 1);
            }
            return true;
        }
        return false;
    }

    @Override
    public void activate(PC pC, Location location) {
        if (location.getDistance(pC) > 1) {
            this.move.addCallback(new OpenContainerCallback(pC));
            this.move.moveTowards(pC, location, 1);
        } else {
            this.openContainer(pC, location.getContainer());
        }
        Game.areaListener.computeMouseState();
    }

    @Override
    public DefaultAbility getInstance() {
        return new OpenContainer();
    }

    public boolean openContainer(PC pC, Container container) {
        if (pC.getLocation().getDistance(container) > 1) {
            return false;
        }
        if (container != null && pC.timer.canPerformAction("OpenContainerCost")) {
            pC.timer.performAction("OpenContainerCost");
            container.attemptOpen(pC);
            if (container.isOpen()) {
                if (container.getTemplate().isWorkbench()) {
                    Game.mainViewer.craftingWindow.setVisible(true);
                } else {
                    Game.mainViewer.containerWindow.setOpenerContainer(pC, container);
                    Game.mainViewer.containerWindow.setVisible(true);
                    Game.mainViewer.updateInterface();
                }
                return true;
            }
            Game.mainViewer.addFadeAway("Locked", container.getLocation().getX(), container.getLocation().getY(), new Color(-5527127));
        }
        return false;
    }

    private class OpenContainerCallback
    implements Runnable {
        private PC parent;

        private OpenContainerCallback(PC pC) {
            this.parent = pC;
        }

        @Override
        public void run() {
            OpenContainer.this.openContainer(this.parent, OpenContainer.this.container);
        }
    }
}

