/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.defaultability;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.hale.Game;
import net.sf.hale.defaultability.DefaultAbility;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.Path;
import net.sf.hale.interfacelock.MovementHandler;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Logger;
import net.sf.hale.util.Point;

public class Move
implements DefaultAbility {
    private Path computedPath;
    private List<Runnable> callbacks = new ArrayList<Runnable>();
    private MovementHandler.Mover mover;
    private boolean truncatePath = true;
    private boolean allowPartyMove = true;
    private static final int MaxPartySearchRadius = 4;

    public void setAllowPartyMove(boolean bl) {
        this.allowPartyMove = bl;
    }

    public void setTruncatePath(boolean bl) {
        this.truncatePath = bl;
    }

    public void addCallback(Runnable runnable) {
        this.callbacks.add(runnable);
    }

    public boolean canMove(Creature creature, Location location, int n) {
        if (!location.isInAreaBounds()) {
            return false;
        }
        if (creature.isPlayerFaction()) {
            if (!location.isExplored()) {
                return false;
            }
            if (Game.mainViewer.isMoveDisabledDueToOpenWindows()) {
                return false;
            }
        }
        if (!location.isPassable()) {
            return false;
        }
        if (creature.getLocation().getElevation() != location.getElevation()) {
            return false;
        }
        if (creature.stats.isImmobilized()) {
            return false;
        }
        if (creature.getLocation().equals(location)) {
            return false;
        }
        this.computedPath = creature.findPathTo(location, n);
        if (this.computedPath == null) {
            return false;
        }
        if (this.truncatePath) {
            int n2 = creature.timer.getLengthCurrentlyMovable(this.computedPath);
            this.computedPath = this.computedPath.truncate(n2);
        }
        return this.computedPath.length() != 0;
    }

    @Override
    public boolean canActivate(PC pC, Location location) {
        return this.canMove(pC, location, 0);
    }

    public boolean moveTowards(Creature creature, Location location, int n, boolean bl) {
        if (!this.canMove(creature, location, n)) {
            return false;
        }
        if (!this.checkOverburdened(creature)) {
            return false;
        }
        if (this.computedPath == null || this.computedPath.length() == 0) {
            return false;
        }
        if (creature.timer.getLengthCurrentlyMovable(this.computedPath) == 0) {
            return false;
        }
        this.createMover(creature, bl);
        return true;
    }

    public boolean moveTowards(Creature creature, Location location, int n) {
        return this.moveTowards(creature, location, n, true);
    }

    @Override
    public void activate(PC pC, Location location) {
        if (!this.checkOverburdened(pC)) {
            return;
        }
        this.createMover(pC, true);
        Game.areaListener.computeMouseState();
    }

    private boolean checkOverburdened(Creature creature) {
        if (creature.inventory.getTotalWeight().grams > creature.stats.getWeightLimit()) {
            Game.mainViewer.addMessage("red", creature.getTemplate().getName() + " is overburdened and cannot move.");
            return false;
        }
        return true;
    }

    private void createMover(Creature creature, boolean bl) {
        this.mover = Game.interfaceLocker.addMove(creature, this.computedPath, bl);
        this.mover.addCallbacks(this.callbacks);
        if (creature.isPlayerFaction()) {
            this.mover.setBackground(true);
            if (Game.interfaceLocker.getMovementMode() == MovementHandler.Mode.Party && this.allowPartyMove && !Game.isInTurnMode()) {
                this.movePartyInFormation(creature);
            }
        }
    }

    private void movePartyInFormation(Creature creature) {
        Object object;
        Object object2;
        boolean[][] blArray = Game.curCampaign.curArea.getCurrentPassable();
        for (Creature creature2 : Game.curCampaign.party) {
            blArray[creature2.getLocation().getX()][creature2.getLocation().getY()] = true;
        }
        Object object3 = this.computedPath.get(0).toPoint();
        blArray[((Point)object3).x][((Point)object3).y] = false;
        int n = 1;
        ListIterator<Creature> listIterator = Game.curCampaign.party.allCreaturesIterator();
        while (n < this.computedPath.length() && listIterator.hasNext()) {
            object2 = listIterator.next();
            if (object2 == creature || !this.checkOverburdened((Creature)object2)) continue;
            Path path = ((Entity)object2).getLocation().getArea().getUtil().findShortestPath((Creature)object2, this.computedPath.get(n).toPoint(), 0);
            ++n;
            if (path == null) {
                listIterator.previous();
                continue;
            }
            if (path.length() != 0) {
                object = Game.interfaceLocker.addMove((Creature)object2, path, true);
                ((MovementHandler.Mover)object).setBackground(true);
                object3 = path.get(0).toPoint();
            } else {
                object3 = ((Entity)object2).getLocation().toPoint();
            }
            blArray[((Point)object3).x][((Point)object3).y] = false;
        }
        object2 = AreaUtil.getAdjacentTiles((Point)object3);
        int n2 = this.computePathDirection((Point[])object2, creature);
        object = object3;
        while (listIterator.hasNext()) {
            Creature creature3 = listIterator.next();
            if (creature3 == creature) continue;
            object2 = AreaUtil.getAdjacentTiles((Point)object);
            Point point = this.getNearestAvailablePoint((Point)(object = object2[n2]), blArray, this.computedPath.get(0));
            if (point == null) {
                return;
            }
            Path path = null;
            try {
                path = creature.getLocation().getArea().getUtil().findShortestPathIgnoreParty(creature3, point, blArray);
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error finding path for " + creature3.getTemplate().getID(), exception);
            }
            if (path == null) {
                blArray[point.x][point.y] = false;
                listIterator.previous();
                continue;
            }
            if (path.length() == 0) {
                object3 = point;
                blArray[point.x][point.y] = false;
                continue;
            }
            if (path.get(0).getDistance(this.computedPath.get(0)) > 6) {
                return;
            }
            if (path.length() > 3 * creature3.getLocation().getDistance(this.computedPath.get(0))) {
                blArray[point.x][point.y] = false;
                continue;
            }
            MovementHandler.Mover mover = Game.interfaceLocker.addMove(creature3, path, true);
            mover.setBackground(true);
            object3 = path.get(0).toPoint();
            blArray[((Point)object3).x][((Point)object3).y] = false;
        }
    }

    private Point getNearestAvailablePoint(Point point, boolean[][] blArray, Location location) {
        if (this.checkCoordinates(point) && blArray[point.x][point.y]) {
            return point;
        }
        for (int i = 1; i <= 4; ++i) {
            int n = Integer.MAX_VALUE;
            Point point2 = null;
            for (int j = 0; j < i * 6; ++j) {
                int n2;
                Point point3 = AreaUtil.convertPolarToGrid(point, i, j);
                if (!this.checkCoordinates(point3) || !blArray[point3.x][point3.y] || (n2 = location.getDistance(point3)) >= n) continue;
                n = n2;
                point2 = point3;
            }
            if (point2 == null) continue;
            return point2;
        }
        return null;
    }

    private final boolean checkCoordinates(Point point) {
        return point.x >= 0 && point.x < Game.curCampaign.curArea.getWidth() && point.y >= 0 && point.y < Game.curCampaign.curArea.getHeight();
    }

    private int computePathDirection(Point[] pointArray, Creature creature) {
        Location location = creature.getLocation();
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        for (int i = 0; i < pointArray.length; ++i) {
            int n3 = location.getDistance(pointArray[i]);
            if (n3 >= n) continue;
            n = n3;
            n2 = i;
        }
        return n2;
    }

    @Override
    public DefaultAbility getInstance() {
        return new Move();
    }

    @Override
    public String getActionName() {
        return "Move";
    }

    public Path getComputedPath() {
        return this.computedPath;
    }

    public MovementHandler.Mover getMover() {
        return this.mover;
    }
}

