/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.defaultability;

import de.matthiasmann.twl.Button;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.defaultability.Attack;
import net.sf.hale.defaultability.DefaultAbility;
import net.sf.hale.defaultability.DefaultAbilityCallback;
import net.sf.hale.defaultability.DisarmTrap;
import net.sf.hale.defaultability.ExamineCreature;
import net.sf.hale.defaultability.ExamineItem;
import net.sf.hale.defaultability.Move;
import net.sf.hale.defaultability.OpenContainer;
import net.sf.hale.defaultability.OpenDoor;
import net.sf.hale.defaultability.PickLock;
import net.sf.hale.defaultability.RecoverTrap;
import net.sf.hale.defaultability.Select;
import net.sf.hale.defaultability.Talk;
import net.sf.hale.defaultability.Travel;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.PC;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.util.SimpleJSONParser;
import net.sf.hale.widgets.RightClickMenu;

public class MouseActionList {
    private final Map<Condition, String> mouseCursors;
    private final List<Condition> conditionsWithAbility;
    private final List<Condition> conditionsWithAbilityCombat;

    public MouseActionList() {
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser("gui/mouseActions" + ResourceType.JSON.getExtension());
        this.mouseCursors = new HashMap<Condition, String>();
        for (String string : simpleJSONParser.keySet()) {
            Condition condition = Condition.valueOf(string);
            String object = simpleJSONParser.get(string, null);
            this.mouseCursors.put(condition, object);
        }
        simpleJSONParser.warnOnUnusedKeys();
        this.conditionsWithAbility = new ArrayList<Condition>();
        for (Condition condition : Condition.values()) {
            if (condition.ability == null) continue;
            this.conditionsWithAbility.add(condition);
        }
        ((ArrayList)this.conditionsWithAbility).trimToSize();
        this.conditionsWithAbilityCombat = new ArrayList<Condition>(this.conditionsWithAbility);
        this.conditionsWithAbilityCombat.remove((Object)Condition.Container);
        this.conditionsWithAbilityCombat.add(Condition.Container);
        this.conditionsWithAbilityCombat.remove((Object)Condition.Door);
        this.conditionsWithAbilityCombat.add(Condition.Door);
        ((ArrayList)this.conditionsWithAbilityCombat).trimToSize();
    }

    public String getMouseCursor(Condition condition) {
        return this.mouseCursors.get((Object)condition);
    }

    public void showDefaultAbilitiesMenu(PC pC, Location location, int n, int n2) {
        RightClickMenu rightClickMenu = Game.mainViewer.getMenu();
        rightClickMenu.clear();
        rightClickMenu.setPosition(n, n2);
        rightClickMenu.addMenuLevel("Actions");
        int n3 = 0;
        for (Condition condition : this.conditionsWithAbility) {
            DefaultAbility defaultAbility = condition.getAbility();
            if (!defaultAbility.canActivate(pC, location)) continue;
            DefaultAbilityCallback defaultAbilityCallback = new DefaultAbilityCallback(defaultAbility);
            defaultAbilityCallback.setActivateParameters(pC, location);
            Button button = new Button(defaultAbility.getActionName());
            button.addCallback((Runnable)defaultAbilityCallback);
            rightClickMenu.addButton(button);
            ++n3;
        }
        if (n3 == 0) {
            Button button = new Button("None");
            button.setEnabled(false);
            rightClickMenu.addButton(button);
        }
        rightClickMenu.show();
    }

    public Condition getDefaultMouseCondition(PC pC, Location location) {
        List<Condition> list = Game.isInTurnMode() ? this.conditionsWithAbilityCombat : this.conditionsWithAbility;
        block3: for (Condition condition : list) {
            switch (condition) {
                case ExamineCreature: 
                case ExamineItem: {
                    continue block3;
                }
            }
            if (!condition.ability.canActivate(pC, location)) continue;
            return condition;
        }
        return Condition.Cancel;
    }

    public static enum Condition {
        Cancel(null),
        TargetSelect(null),
        TargetSelectAdd(null),
        Attack(new Attack()),
        RecoverTrap(new RecoverTrap()),
        DisarmTrap(new DisarmTrap()),
        PickLock(new PickLock()),
        Container(new OpenContainer()),
        Door(new OpenDoor()),
        Talk(new Talk()),
        Travel(new Travel()),
        Select(new Select()),
        Move(new Move()),
        ExamineCreature(new ExamineCreature()),
        ExamineItem(new ExamineItem());

        private final DefaultAbility ability;

        private Condition(DefaultAbility defaultAbility) {
            this.ability = defaultAbility;
        }

        public DefaultAbility getAbility() {
            if (this.ability == null) {
                return null;
            }
            return this.ability.getInstance();
        }
    }
}

