/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.defaultability;

import de.matthiasmann.twl.Widget;
import net.sf.hale.Game;
import net.sf.hale.defaultability.DefaultAbility;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.Trap;
import net.sf.hale.view.ItemDetailsWindow;

public class ExamineItem
implements DefaultAbility {
    private Item target;

    @Override
    public String getActionName() {
        return "Examine " + this.target.getTemplate().getName();
    }

    @Override
    public boolean canActivate(PC pC, Location location) {
        if (!pC.hasVisibility(location)) {
            return false;
        }
        Trap trap = location.getTrap();
        if (trap == null || !trap.isSpotted()) {
            return false;
        }
        this.target = trap;
        return true;
    }

    @Override
    public void activate(PC pC, Location location) {
        ItemDetailsWindow itemDetailsWindow = new ItemDetailsWindow(this.target);
        itemDetailsWindow.setPosition(Game.areaListener.getMouseGUIX() - itemDetailsWindow.getWidth() / 2, Game.areaListener.getMouseGUIY() - itemDetailsWindow.getHeight() / 2);
        Game.mainViewer.add((Widget)itemDetailsWindow);
        Game.areaListener.computeMouseState();
    }

    @Override
    public DefaultAbility getInstance() {
        return new ExamineItem();
    }
}

