/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.defaultability;

import de.matthiasmann.twl.Color;
import net.sf.hale.Game;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.defaultability.DefaultAbility;
import net.sf.hale.defaultability.Move;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.Trap;

public class DisarmTrap
implements DefaultAbility {
    private Move move;
    private Trap trap;

    @Override
    public String getActionName() {
        return "Disarm Trap";
    }

    @Override
    public boolean canActivate(PC pC, Location location) {
        if (!pC.timer.canPerformAction("DisarmTrapCost")) {
            return false;
        }
        if (!pC.stats.has(Bonus.Type.TrapHandling)) {
            return false;
        }
        this.trap = location.getTrap();
        if (this.trap == null || !this.trap.isSpotted()) {
            return false;
        }
        this.move = new Move();
        this.move.setAllowPartyMove(false);
        if (location.getDistance(pC) > 1) {
            return this.move.canMove(pC, location, 1);
        }
        return true;
    }

    @Override
    public void activate(PC pC, Location location) {
        if (location.getDistance(pC) > 1) {
            this.move.addCallback(new DisarmCallback(pC));
            this.move.moveTowards(pC, location, 1);
        } else {
            this.disarm(pC, this.trap);
        }
        Game.areaListener.computeMouseState();
    }

    public boolean disarm(Creature creature, Trap trap) {
        if (trap == null) {
            return false;
        }
        if (trap.getLocation().getDistance(creature) > 1) {
            return false;
        }
        if (!creature.timer.canPerformAction("DisarmTrapCost")) {
            return false;
        }
        if (!creature.stats.has(Bonus.Type.TrapHandling)) {
            return false;
        }
        creature.timer.performAction("DisarmTrapCost");
        boolean bl = trap.attemptDisarm(creature);
        if (!bl) {
            Game.mainViewer.addFadeAway("Disarm Trap Failed", trap.getLocation().getX(), trap.getLocation().getY(), new Color(-5527127));
        } else {
            Game.mainViewer.addFadeAway("Trap Disarmed", trap.getLocation().getX(), trap.getLocation().getY(), new Color(-5527127));
        }
        return bl;
    }

    @Override
    public DefaultAbility getInstance() {
        return new DisarmTrap();
    }

    private class DisarmCallback
    implements Runnable {
        private Creature parent;

        private DisarmCallback(Creature creature) {
            this.parent = creature;
        }

        @Override
        public void run() {
            DisarmTrap.this.disarm(this.parent, DisarmTrap.this.trap);
        }
    }
}

