/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.defaultability;

import net.sf.hale.Game;
import net.sf.hale.defaultability.DefaultAbility;
import net.sf.hale.defaultability.Move;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.Weapon;

public class Attack
implements DefaultAbility {
    private Move move;
    private Creature target;

    @Override
    public String getActionName() {
        return "Attack";
    }

    @Override
    public boolean canActivate(PC pC, Location location) {
        if (!pC.timer.canAttack()) {
            return false;
        }
        if (pC.getLocation().equals(location)) {
            return false;
        }
        this.target = location.getCreature();
        if (this.target != null && pC.getFaction().isHostile(this.target)) {
            this.move = new Move();
            if (pC.canAttack(location)) {
                return true;
            }
            Weapon weapon = pC.getMainHandWeapon();
            if (weapon.isMelee()) {
                return this.move.canMove(pC, location, weapon.getTemplate().getMaxRange());
            }
        }
        return false;
    }

    @Override
    public void activate(PC pC, Location location) {
        if (pC.canAttack(location)) {
            Game.areaListener.getCombatRunner().creatureStandardAttack(pC, this.target);
        } else {
            Weapon weapon = pC.getMainHandWeapon();
            if (weapon.isMelee()) {
                this.move.addCallback(new AttackCallback(pC));
                this.move.moveTowards(pC, location, weapon.getTemplate().getMaxRange());
            }
        }
        Game.areaListener.computeMouseState();
    }

    @Override
    public DefaultAbility getInstance() {
        return new Attack();
    }

    private class AttackCallback
    implements Runnable {
        private Creature parent;

        private AttackCallback(Creature creature) {
            this.parent = creature;
        }

        @Override
        public void run() {
            if (this.parent.canAttack(Attack.this.target.getLocation())) {
                Game.areaListener.getCombatRunner().creatureStandardAttack(this.parent, Attack.this.target);
            }
        }
    }
}

