/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.characterbuilder.Buildable;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.resource.Sprite;
import net.sf.hale.resource.SpriteManager;
import net.sf.hale.rules.Race;
import net.sf.hale.util.FileUtil;
import net.sf.hale.util.Logger;
import org.lwjgl.opengl.GL11;

public class PortraitSelector
extends PopupWindow {
    private Callback callback;
    private PortraitViewer selectedPortrait;
    private Buildable character;
    private int numColumns;
    private int buttonGap;
    private int portraitSize;
    private Label title;
    private Button accept;
    private Button cancel;
    private Content content;
    private ScrollPane portraitPane;
    private PortraitPaneContent portraitPaneContent;

    public PortraitSelector(Widget widget, Buildable buildable) {
        super(widget);
        this.character = buildable;
        this.setCloseOnClickedOutside(false);
        this.setCloseOnEscape(false);
        this.content = new Content();
        this.add(this.content);
        this.title = new Label("Select a Portrait");
        this.title.setTheme("titlelabel");
        this.content.add((Widget)this.title);
        this.accept = new Button("Accept");
        this.accept.setTheme("acceptbutton");
        this.accept.addCallback(new Runnable(){

            @Override
            public void run() {
                PortraitSelector.this.accept();
            }
        });
        this.content.add((Widget)this.accept);
        this.cancel = new Button("Cancel");
        this.cancel.setTheme("cancelbutton");
        this.cancel.addCallback(new Runnable(){

            @Override
            public void run() {
                PortraitSelector.this.closePopup();
            }
        });
        this.content.add((Widget)this.cancel);
        this.portraitPaneContent = new PortraitPaneContent();
        this.portraitPane = new ScrollPane((Widget)this.portraitPaneContent);
        this.portraitPane.setTheme("portraitpane");
        this.portraitPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.content.add((Widget)this.portraitPane);
        this.setAcceptEnabled();
    }

    protected void afterAddToGUI(GUI gUI) {
        Race race = this.character.getSelectedRace();
        this.portraitPaneContent.updatePortraits(race);
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    private void setAcceptEnabled() {
        this.accept.setEnabled(this.selectedPortrait != null);
    }

    private void accept() {
        this.closePopup();
        String string = PortraitSelector.getPortraitString(this.selectedPortrait.portrait);
        if (this.callback != null) {
            this.callback.portraitSelected(string);
        }
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.numColumns = themeInfo.getParameter("numcolumns", 0);
        this.buttonGap = themeInfo.getParameter("buttongap", 0);
        this.portraitSize = themeInfo.getParameter("portraitsize", 0);
    }

    private static String getPortraitString(String string) {
        String string2 = FileUtil.getRelativePath("portraits", string);
        string2 = string2.substring(0, string2.length() - ResourceType.PNG.getLength());
        return string2;
    }

    private class PortraitViewer
    extends ToggleButton
    implements Runnable {
        private String portrait;
        private Sprite sprite;
        private float scale;
        private float invScale;

        private PortraitViewer(String string) {
            this.portrait = string;
            this.addCallback(this);
        }

        private void loadSprite() {
            this.sprite = SpriteManager.getImage(this.portrait);
        }

        @Override
        public void run() {
            if (PortraitSelector.this.selectedPortrait != null) {
                PortraitSelector.this.selectedPortrait.setActive(false);
            }
            PortraitSelector.this.selectedPortrait = this;
            this.setActive(true);
            PortraitSelector.this.setAcceptEnabled();
        }

        private void setScale(float f) {
            this.scale = f;
            this.invScale = 1.0f / f;
        }

        public int getPreferredWidth() {
            return PortraitSelector.this.portraitSize;
        }

        public int getPreferredHeight() {
            return PortraitSelector.this.portraitSize;
        }

        protected void paintWidget(GUI gUI) {
            super.paintWidget(gUI);
            if (this.sprite != null) {
                GL11.glPushMatrix();
                GL11.glScalef((float)this.scale, (float)this.scale, (float)1.0f);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                this.sprite.draw((int)((float)this.getInnerX() * this.invScale), (int)((float)this.getInnerY() * this.invScale));
                GL11.glPopMatrix();
            }
        }
    }

    private class PortraitPaneContent
    extends Widget {
        private int numPortraits;

        private PortraitPaneContent() {
            this.setTheme("content");
        }

        private void updatePortraits(Race race) {
            this.removeAllChildren();
            String string = "portraits/" + race.getID();
            ArrayList<PortraitViewer> arrayList = new ArrayList<PortraitViewer>();
            for (String string2 : ResourceManager.getResourcesInDirectory(string)) {
                PortraitViewer portraitViewer = new PortraitViewer(string2);
                portraitViewer.setScale(0.5f);
                this.add((Widget)portraitViewer);
                String string3 = PortraitSelector.getPortraitString(string2);
                if (string3.equals(PortraitSelector.this.character.getSelectedPortrait())) {
                    portraitViewer.setActive(true);
                    PortraitSelector.this.selectedPortrait = portraitViewer;
                }
                ++this.numPortraits;
                arrayList.add(portraitViewer);
            }
            PortraitLoader portraitLoader = new PortraitLoader(arrayList);
            this.getGUI().invokeAsync((Runnable)portraitLoader, (GUI.AsyncCompletionListener)new PortraitLoaderListener());
        }

        public int getPreferredWidth() {
            return PortraitSelector.this.portraitSize * PortraitSelector.this.numColumns + this.getBorderHorizontal();
        }

        public int getPreferredHeight() {
            return PortraitSelector.this.portraitSize * (this.numPortraits / PortraitSelector.this.numColumns) + this.getBorderVertical();
        }

        protected void layout() {
            super.layout();
            int n = this.getInnerX();
            int n2 = this.getInnerY();
            int n3 = 0;
            for (int i = 0; i < this.getNumChildren(); ++i) {
                Widget widget = this.getChild(i);
                widget.setSize(widget.getPreferredWidth(), widget.getPreferredHeight());
                widget.setPosition(n, n2);
                n += widget.getWidth();
                if (++n3 < PortraitSelector.this.numColumns) continue;
                n3 = 0;
                n = this.getInnerX();
                n2 = widget.getBottom();
            }
        }
    }

    private class PortraitLoaderListener
    implements GUI.AsyncCompletionListener<PortraitLoader> {
        private PortraitLoaderListener() {
        }

        public void completed(PortraitLoader portraitLoader) {
        }

        public void failed(Exception exception) {
            Logger.appendToErrorLog("Error loading portraits", exception);
        }
    }

    private class PortraitLoader
    implements Runnable {
        private List<PortraitViewer> viewers;

        private PortraitLoader(List<PortraitViewer> list) {
            this.viewers = list;
        }

        @Override
        public void run() {
            for (PortraitViewer portraitViewer : this.viewers) {
                portraitViewer.loadSprite();
            }
        }
    }

    public static interface Callback {
        public void portraitSelected(String var1);
    }

    private class Content
    extends Widget {
        private Content() {
        }

        protected void layout() {
            PortraitSelector.this.title.setSize(PortraitSelector.this.title.getPreferredWidth(), PortraitSelector.this.title.getPreferredHeight());
            PortraitSelector.this.title.setPosition(this.getInnerX() + this.getInnerWidth() / 2 - PortraitSelector.this.title.getWidth() / 2, this.getInnerY());
            PortraitSelector.this.accept.setSize(PortraitSelector.this.accept.getPreferredWidth(), PortraitSelector.this.accept.getPreferredHeight());
            PortraitSelector.this.cancel.setSize(PortraitSelector.this.cancel.getPreferredWidth(), PortraitSelector.this.cancel.getPreferredHeight());
            int n = this.getInnerHeight() - PortraitSelector.this.title.getHeight() - PortraitSelector.this.accept.getHeight() - PortraitSelector.this.buttonGap;
            PortraitSelector.this.portraitPane.setSize(PortraitSelector.this.portraitPane.getPreferredWidth() + PortraitSelector.this.portraitPane.getVerticalScrollbar().getWidth(), n);
            PortraitSelector.this.portraitPane.setPosition(this.getInnerX(), PortraitSelector.this.title.getBottom());
            PortraitSelector.this.accept.setPosition(this.getInnerX() + this.getInnerWidth() / 2 - PortraitSelector.this.accept.getWidth() - PortraitSelector.this.buttonGap, PortraitSelector.this.portraitPane.getBottom() + PortraitSelector.this.buttonGap);
            PortraitSelector.this.cancel.setPosition(this.getInnerX() + this.getInnerWidth() / 2 + PortraitSelector.this.buttonGap, PortraitSelector.this.portraitPane.getBottom() + PortraitSelector.this.buttonGap);
        }

        public int getPreferredWidth() {
            return PortraitSelector.this.portraitPane.getPreferredWidth() + this.getBorderHorizontal() + PortraitSelector.this.portraitPane.getVerticalScrollbar().getWidth();
        }

        public int getPreferredHeight() {
            return Math.min(Game.displayMode.getHeight(), PortraitSelector.this.portraitPane.getPreferredHeight() + PortraitSelector.this.title.getPreferredHeight() + PortraitSelector.this.accept.getPreferredHeight() + PortraitSelector.this.buttonGap + this.getBorderVertical());
        }
    }
}

