/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import java.util.LinkedList;
import java.util.List;

public class PointAllocatorModel {
    private List<Listener> listeners;
    private double pointsRemaining;

    public PointAllocatorModel(int n) {
        this.pointsRemaining = n;
        this.listeners = new LinkedList<Listener>();
    }

    public void setPointsRemaining(int n) {
        this.pointsRemaining = n;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void allocatePoints(double d) {
        this.pointsRemaining -= d;
        for (Listener listener : this.listeners) {
            listener.allocatorModelUpdated();
        }
    }

    public double getRemainingPoints() {
        return this.pointsRemaining;
    }

    public static interface Listener {
        public void allocatorModelUpdated();
    }
}

