/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.icon.Icon;

public class IconButton
extends Button {
    private List<Callback> callbacks;
    private Icon icon;

    public IconButton(Icon icon) {
        if (icon != null) {
            this.icon = icon;
            this.setSize(icon.getWidth(), icon.getHeight());
        } else {
            this.setSize(45, 45);
        }
        this.callbacks = new ArrayList<Callback>(1);
        super.addCallback(new Runnable(){

            @Override
            public void run() {
                for (Callback callback : IconButton.this.callbacks) {
                    callback.leftClicked();
                }
            }
        });
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void addCallback(Runnable runnable) {
        throw new UnsupportedOperationException("Only IconButton.Callback callbacks can be used as callbacks for IconButtons.");
    }

    public void addCallback(Callback callback) {
        this.callbacks.add(callback);
    }

    public void removeCallback(Callback callback) {
        this.callbacks.remove(callback);
    }

    public int getMinWidth() {
        return this.icon != null ? this.icon.getWidth() + this.getBorderHorizontal() : 45 + this.getBorderHorizontal();
    }

    public int getMinHeight() {
        return this.icon != null ? this.icon.getHeight() + this.getBorderVertical() : 45 + this.getBorderVertical();
    }

    protected boolean handleEvent(Event event) {
        AnimationState animationState = this.getAnimationState();
        if (event.isMouseEvent()) {
            boolean bl;
            boolean bl2 = bl = event.getType() != Event.Type.MOUSE_EXITED && this.isMouseInside(event);
            if (bl && !animationState.getAnimationState(Button.STATE_HOVER)) {
                for (Callback callback : this.callbacks) {
                    callback.startHover();
                }
            } else if (!bl && animationState.getAnimationState(Button.STATE_HOVER)) {
                for (Callback callback : this.callbacks) {
                    callback.endHover();
                }
            }
        }
        switch (event.getType()) {
            case MOUSE_BTNUP: {
                if (event.getMouseButton() != 1) break;
                for (Callback callback : this.callbacks) {
                    callback.rightClicked();
                }
                break;
            }
        }
        return super.handleEvent(event);
    }

    protected void paintWidget(GUI gUI) {
        super.paintWidget(gUI);
        if (this.icon != null) {
            this.icon.draw(this.getInnerX(), this.getInnerY());
        }
    }

    public static interface Callback {
        public void leftClicked();

        public void rightClicked();

        public void startHover();

        public void endHover();
    }
}

