/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.ColorSelector;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.ColorSpace;
import de.matthiasmann.twl.model.ColorSpaceHSL;
import java.util.ArrayList;
import java.util.List;

public class ColorSelectorPopup
extends PopupWindow {
    private int buttonGap;
    private Content content;
    private List<Callback> callbacks;

    public ColorSelectorPopup(Widget widget) {
        super(widget);
        this.setCloseOnClickedOutside(false);
        this.content = new Content();
        this.add(this.content);
        this.callbacks = new ArrayList<Callback>();
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.content.colorSelector.setColor(color);
    }

    public void addCallback(Callback callback) {
        this.callbacks.add(callback);
    }

    private void accept() {
        this.closePopup();
        for (Callback callback : this.callbacks) {
            callback.colorSelected(this.content.colorSelector.getColor());
        }
    }

    private class Content
    extends Widget {
        private final ColorSelector colorSelector;
        private final Button cancel;
        private final Button accept;
        private final Label title = new Label("Choose a Color");

        private Content() {
            this.title.setTheme("titlelabel");
            this.add((Widget)this.title);
            this.colorSelector = new ColorSelector((ColorSpace)new ColorSpaceHSL());
            this.colorSelector.setTheme("colorselector");
            this.colorSelector.setUseColorArea2D(true);
            this.colorSelector.setUseLabels(false);
            this.colorSelector.setShowPreview(true);
            this.colorSelector.setShowAlphaAdjuster(false);
            this.add((Widget)this.colorSelector);
            this.cancel = new Button("Cancel");
            this.cancel.setTheme("cancelbutton");
            this.cancel.addCallback(new Runnable(){

                @Override
                public void run() {
                    ColorSelectorPopup.this.closePopup();
                }
            });
            this.add((Widget)this.cancel);
            this.accept = new Button("Accept");
            this.accept.setTheme("acceptbutton");
            this.accept.addCallback(new Runnable(){

                @Override
                public void run() {
                    ColorSelectorPopup.this.accept();
                }
            });
            this.add((Widget)this.accept);
        }

        public int getPreferredWidth() {
            return this.colorSelector.getPreferredWidth() + this.getBorderHorizontal();
        }

        public int getPreferredHeight() {
            return this.title.getPreferredHeight() + this.colorSelector.getPreferredHeight() + ColorSelectorPopup.this.buttonGap + this.accept.getPreferredHeight() + this.getBorderVertical();
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            ColorSelectorPopup.this.buttonGap = themeInfo.getParameter("buttongap", 0);
        }

        protected void layout() {
            this.title.setSize(this.title.getPreferredWidth(), this.title.getPreferredHeight());
            this.title.setPosition(this.getInnerX() + this.getInnerWidth() / 2 - this.title.getWidth() / 2, this.getInnerY());
            this.colorSelector.setSize(this.colorSelector.getPreferredWidth(), this.colorSelector.getPreferredHeight());
            this.colorSelector.setPosition(this.getInnerX(), this.title.getBottom());
            this.cancel.setSize(this.cancel.getPreferredWidth(), this.cancel.getPreferredHeight());
            this.cancel.setPosition(this.getInnerX() + this.getInnerWidth() / 2 + ColorSelectorPopup.this.buttonGap, this.colorSelector.getBottom() + ColorSelectorPopup.this.buttonGap);
            this.accept.setSize(this.accept.getPreferredWidth(), this.accept.getPreferredHeight());
            this.accept.setPosition(this.getInnerX() + this.getInnerWidth() / 2 - this.accept.getWidth() - ColorSelectorPopup.this.buttonGap, this.colorSelector.getBottom() + ColorSelectorPopup.this.buttonGap);
        }
    }

    public static interface Callback {
        public void colorSelected(Color var1);
    }
}

