/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ability.CreatureAbilitySet;
import net.sf.hale.bonus.Stat;
import net.sf.hale.characterbuilder.AbstractBuilderPane;
import net.sf.hale.characterbuilder.Buildable;
import net.sf.hale.characterbuilder.BuilderPaneAbilities;
import net.sf.hale.characterbuilder.BuilderPaneAttributes;
import net.sf.hale.characterbuilder.BuilderPaneCosmetic;
import net.sf.hale.characterbuilder.BuilderPaneRace;
import net.sf.hale.characterbuilder.BuilderPaneRole;
import net.sf.hale.characterbuilder.BuilderPaneSkills;
import net.sf.hale.entity.CreatedItem;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.ItemList;
import net.sf.hale.entity.PC;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.SaveWriter;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.util.Logger;
import net.sf.hale.view.GameSubWindow;

public class CharacterBuilder
extends GameSubWindow {
    private List<FinishCallback> finishCallbacks;
    private PaneSelectorButton[] paneButtons;
    private Buildable character;
    private AbstractBuilderPane activePane;
    private final DialogLayout content;
    private final DialogLayout.Group mainContentH;
    private final DialogLayout.Group mainContentV;

    public CharacterBuilder(Buildable buildable) {
        this.character = buildable;
        this.finishCallbacks = new ArrayList<FinishCallback>();
        this.setSize(750, 550);
        this.content = new DialogLayout();
        this.content.setTheme("content");
        this.add((Widget)this.content);
        this.paneButtons = new PaneSelectorButton[6];
        this.paneButtons[0] = new PaneSelectorButton(new BuilderPaneRace(this, buildable));
        this.paneButtons[1] = new PaneSelectorButton(new BuilderPaneRole(this, buildable));
        this.paneButtons[2] = new PaneSelectorButton(new BuilderPaneAttributes(this, buildable));
        this.paneButtons[3] = new PaneSelectorButton(new BuilderPaneSkills(this, buildable));
        this.paneButtons[4] = new PaneSelectorButton(new BuilderPaneAbilities(this, buildable));
        this.paneButtons[5] = new PaneSelectorButton(new BuilderPaneCosmetic(this, buildable));
        DialogLayout.Group group = this.content.createSequentialGroup((Widget[])this.paneButtons);
        DialogLayout.Group group2 = this.content.createParallelGroup((Widget[])this.paneButtons);
        this.mainContentH = this.content.createSequentialGroup();
        this.mainContentV = this.content.createSequentialGroup();
        DialogLayout.Group group3 = this.content.createParallelGroup(new DialogLayout.Group[]{group, this.mainContentH});
        DialogLayout.Group group4 = this.content.createSequentialGroup(new DialogLayout.Group[]{group2, this.mainContentV});
        this.content.setHorizontalGroup(group3);
        this.content.setVerticalGroup(group4);
        if (buildable.isNewCharacter()) {
            this.setTitle("Character Builder");
            this.paneButtons[0].select();
        } else {
            this.setTitle("Character Builder for " + this.getCharacter().getName());
            this.paneButtons[0].setEnabled(false);
            this.paneButtons[2].setEnabled(false);
            this.paneButtons[5].setEnabled(false);
            this.paneButtons[1].select();
        }
    }

    protected void afterAddToGUI(GUI gUI) {
        super.afterAddToGUI(gUI);
        this.setPositionCentered();
    }

    public void addFinishCallback(FinishCallback finishCallback) {
        this.finishCallbacks.add(finishCallback);
    }

    protected void finish() {
        PC pC = this.character.getWorkingCopy();
        String string = pC.getTemplate().getID();
        if (this.character.isNewCharacter()) {
            string = CharacterBuilder.savePC(pC);
        } else {
            this.character.applySelectionsToCreature();
        }
        this.getCloseCallback().run();
        for (FinishCallback finishCallback : this.finishCallbacks) {
            finishCallback.creatureModified(string);
        }
    }

    public Buildable getCharacter() {
        return this.character;
    }

    public AbstractBuilderPane getPreviousPane(AbstractBuilderPane abstractBuilderPane) {
        int n;
        for (n = 0; n < this.paneButtons.length && this.paneButtons[n].pane != abstractBuilderPane; ++n) {
        }
        if (n == 0) {
            return null;
        }
        return this.paneButtons[n - 1].pane;
    }

    public AbstractBuilderPane getNextPane(AbstractBuilderPane abstractBuilderPane) {
        int n;
        for (n = 0; n < this.paneButtons.length && this.paneButtons[n].pane != abstractBuilderPane; ++n) {
        }
        if (n >= this.paneButtons.length - 1) {
            return null;
        }
        return this.paneButtons[n + 1].pane;
    }

    public void setActivePane(AbstractBuilderPane abstractBuilderPane) {
        this.activePane = abstractBuilderPane;
        this.mainContentH.clear(true);
        this.mainContentV.clear(true);
        this.mainContentH.addWidget((Widget)this.activePane);
        this.mainContentV.addWidget((Widget)this.activePane);
        this.content.invalidateLayout();
        for (PaneSelectorButton paneSelectorButton : this.paneButtons) {
            paneSelectorButton.setActive(paneSelectorButton.pane == abstractBuilderPane);
        }
        this.activePane.updateCharacter();
    }

    @Override
    public void run() {
        this.getParent().removeChild((Widget)this);
    }

    public static String savePC(PC pC) {
        Object exception;
        File file = new File(Game.getCharactersBaseDirectory());
        if (!file.exists()) {
            file.mkdirs();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
        String string = pC.getTemplate().getName() + "-" + simpleDateFormat.format(Calendar.getInstance().getTime());
        File file2 = new File(Game.getCharactersBaseDirectory() + string + ResourceType.JSON.getExtension());
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("name", pC.getTemplate().getName());
        jSONOrderedObject.put("gender", pC.getTemplate().getGender().toString());
        jSONOrderedObject.put("race", pC.getTemplate().getRace().getName());
        jSONOrderedObject.put("portrait", pC.getTemplate().getPortrait());
        jSONOrderedObject.put("icon", pC.getTemplate().getIcon().save());
        JSONOrderedObject jSONOrderedObject2 = new JSONOrderedObject();
        jSONOrderedObject2.put("strength", pC.stats.get(Stat.BaseStr));
        jSONOrderedObject2.put("dexterity", pC.stats.get(Stat.BaseDex));
        jSONOrderedObject2.put("constitution", pC.stats.get(Stat.BaseCon));
        jSONOrderedObject2.put("intelligence", pC.stats.get(Stat.BaseInt));
        jSONOrderedObject2.put("wisdom", pC.stats.get(Stat.BaseWis));
        jSONOrderedObject2.put("charisma", pC.stats.get(Stat.BaseCha));
        jSONOrderedObject.put("attributes", jSONOrderedObject2);
        jSONOrderedObject.put("skills", pC.skills.save());
        ArrayList<JSONOrderedObject> arrayList = new ArrayList<JSONOrderedObject>();
        for (CreatureAbilitySet.AbilityInstance object22 : pC.abilities.getAllAbilityInstances()) {
            if (object22.isRoleAbility() || object22.isRacialAbility()) continue;
            exception = object22.getAbility().getID();
            int entry = object22.getLevel();
            JSONOrderedObject jSONOrderedObject3 = new JSONOrderedObject();
            jSONOrderedObject3.put("id", exception);
            jSONOrderedObject3.put("levelObtained", entry);
            arrayList.add(jSONOrderedObject3);
        }
        jSONOrderedObject.put("abilities", arrayList.toArray());
        jSONOrderedObject.put("roles", pC.roles.save());
        JSONOrderedObject jSONOrderedObject4 = pC.inventory.save();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Inventory.Slot slot : Inventory.Slot.values()) {
            EquippableItem equippableItem = pC.inventory.getEquippedItem(slot);
            if (equippableItem == null) continue;
            CharacterBuilder.checkToAddCreatedItem(equippableItem.getTemplate().getID(), arrayList2);
        }
        for (ItemList.Entry entry : pC.inventory.getUnequippedItems()) {
            CharacterBuilder.checkToAddCreatedItem(entry.getID(), arrayList2);
        }
        if (arrayList2.size() > 0) {
            jSONOrderedObject4.put("createdItems", arrayList2.toArray());
        }
        jSONOrderedObject.put("inventory", jSONOrderedObject4);
        jSONOrderedObject.put("unspentSkillPoints", pC.getUnspentSkillPoints());
        jSONOrderedObject.put("experiencePoints", pC.getExperiencePoints());
        jSONOrderedObject.put("quickbar", pC.quickbar.save());
        try {
            exception = new PrintWriter(file2);
            SaveWriter.writeJSON(jSONOrderedObject, (PrintWriter)exception);
            ((PrintWriter)exception).close();
        }
        catch (Exception exception2) {
            Logger.appendToErrorLog("Error writing player character", exception2);
        }
        return string;
    }

    private static void checkToAddCreatedItem(String string, List<Object> list) {
        CreatedItem createdItem = Game.curCampaign.getCreatedItem(string);
        if (createdItem != null) {
            list.add(createdItem.save());
        }
    }

    private class PaneSelectorButton
    extends ToggleButton {
        private AbstractBuilderPane pane;

        private PaneSelectorButton(AbstractBuilderPane abstractBuilderPane) {
            super(abstractBuilderPane.getName());
            this.pane = abstractBuilderPane;
        }

        private void select() {
            CharacterBuilder.this.setActivePane(this.pane);
        }

        protected boolean handleEvent(Event event) {
            return false;
        }
    }

    public static interface FinishCallback {
        public void creatureModified(String var1);
    }
}

