/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.characterbuilder.AbstractBuilderPane;
import net.sf.hale.characterbuilder.Buildable;
import net.sf.hale.characterbuilder.BuildablePropertySelector;
import net.sf.hale.characterbuilder.BuilderPane;
import net.sf.hale.characterbuilder.CharacterBuilder;
import net.sf.hale.characterbuilder.PointAllocatorModel;
import net.sf.hale.entity.PC;
import net.sf.hale.rules.Role;
import net.sf.hale.rules.Skill;
import net.sf.hale.rules.SkillSet;

public class BuilderPaneSkills
extends BuilderPane
implements PointAllocatorModel.Listener {
    private PointAllocatorModel points;
    private List<SkillSelector> selectors;
    private final Button resetButton;
    private final Button roleButton;

    public BuilderPaneSkills(CharacterBuilder characterBuilder, Buildable buildable) {
        super(characterBuilder, "Skills", buildable);
        this.setTitleText("Select Skills");
        this.points = new PointAllocatorModel(1);
        this.points.addListener(this);
        this.selectors = new ArrayList<SkillSelector>();
        this.resetButton = new Button("Reset Selections");
        this.resetButton.setTheme("resetbutton");
        this.resetButton.addCallback(new Runnable(){

            @Override
            public void run() {
                BuilderPaneSkills.this.resetValues();
            }
        });
        this.add((Widget)this.resetButton);
        this.roleButton = new Button("Suggested Values");
        this.roleButton.setTheme("rolebutton");
        this.roleButton.addCallback(new Runnable(){

            @Override
            public void run() {
                BuilderPaneSkills.this.setRoleValues();
            }
        });
        this.add((Widget)this.roleButton);
    }

    private void resetValues() {
        for (SkillSelector skillSelector : this.selectors) {
            int n = (skillSelector.baseValue - skillSelector.getValue()) / 5;
            skillSelector.addModelPoints(n);
            skillSelector.addValue(n);
        }
    }

    private void setRoleValues() {
        this.resetValues();
        Role role = this.getCharacter().getBaseRole();
        List<String> list = role.getDefaultPlayerSkillSelections();
        for (String string : list) {
            if (this.points.getRemainingPoints() < 5.0) break;
            SkillSelector skillSelector = this.findSelector(string);
            skillSelector.addModelPoints(1);
            skillSelector.addValue(1);
        }
    }

    private SkillSelector findSelector(String string) {
        for (SkillSelector skillSelector : this.selectors) {
            if (!skillSelector.skill.getID().equals(string)) continue;
            return skillSelector;
        }
        return null;
    }

    @Override
    protected void layout() {
        super.layout();
        ScrollPane scrollPane = this.getSelectorPane();
        this.resetButton.setSize(this.resetButton.getPreferredWidth(), this.resetButton.getPreferredHeight());
        this.roleButton.setSize(this.roleButton.getPreferredWidth(), this.roleButton.getPreferredHeight());
        this.resetButton.setPosition(this.getInnerX(), scrollPane.getBottom());
        this.roleButton.setPosition(this.resetButton.getRight(), scrollPane.getBottom());
    }

    @Override
    public void updateCharacter() {
        for (SkillSelector object2 : this.selectors) {
            this.points.removeListener(object2);
        }
        this.selectors.clear();
        this.clearSelectors();
        SkillSet skillSet = this.getCharacter().getSkillSet();
        SkillSet skillSet2 = this.getCharacter().getSelectedSkills();
        int n = Game.ruleset.getValue("SkillsMaxPerLevel") * this.getCharacter().getCreatureLevel();
        int n2 = this.getCharacter().getCurrentIntelligence();
        int n3 = this.getCharacter().getSelectedRole().getSkillPointsPerLevel();
        n3 += n2 - 10;
        this.points.setPointsRemaining(n3 += this.getCharacter().getUnspentSkillPoints());
        for (Skill skill : this.getCharacter().getSelectableSkills()) {
            SkillSelector skillSelector = new SkillSelector(skill, skillSet.getRanks(skill));
            skillSelector.setMinMaxValue(skillSelector.getValue(), n);
            skillSelector.setPointAllocatorModel(this.points);
            if (skillSet2 != null) {
                int n4 = skillSet2.getRanks(skill) / 5;
                skillSelector.addValue(n4);
                skillSelector.addModelPoints(n4);
            }
            this.selectors.add(skillSelector);
            this.addSelector((Widget)skillSelector);
        }
        this.allocatorModelUpdated();
        if (skillSet2 == null) {
            this.setRoleValues();
        }
    }

    @Override
    public void allocatorModelUpdated() {
        double d = this.points.getRemainingPoints();
        long l = Math.round(d);
        if (l == 1L) {
            this.setPointsText("1 point remaining");
        } else {
            this.setPointsText(l + " points remaining");
        }
        boolean bl = true;
        for (SkillSelector skillSelector : this.selectors) {
            if (!skillSelector.canIncrement()) continue;
            bl = false;
            break;
        }
        this.getNextButton().setEnabled(bl);
    }

    @Override
    protected void next() {
        PC pC = this.getCharacter().getWorkingCopy();
        SkillSet skillSet = this.getCharacter().getSkillSet();
        SkillSet skillSet2 = new SkillSet(pC);
        for (SkillSelector skillSelector : this.selectors) {
            int n = skillSelector.getValue() - skillSet.getRanks(skillSelector.skill);
            if (n <= 0) continue;
            skillSet2.addRanks(skillSelector.skill, n);
        }
        this.getCharacter().setSelectedSkills(skillSet2, (int)Math.round(this.points.getRemainingPoints()));
        super.next();
    }

    @Override
    protected void back() {
        if (this.getCharacter().isNewCharacter()) {
            super.back();
        } else {
            AbstractBuilderPane abstractBuilderPane = this.getCharacterBuilder().getPreviousPane(this);
            AbstractBuilderPane abstractBuilderPane2 = this.getCharacterBuilder().getPreviousPane(abstractBuilderPane);
            this.getCharacterBuilder().setActivePane(abstractBuilderPane2);
        }
    }

    private class SkillSelector
    extends BuildablePropertySelector {
        private Skill skill;
        private final int baseValue;

        private SkillSelector(Skill skill, int n) {
            super(skill.getNoun(), skill.getIcon(), true);
            this.skill = skill;
            this.baseValue = n;
            this.setValue(n);
        }

        @Override
        protected void addValue(int n) {
            this.setValue(this.getValue() + 5 * n);
        }

        @Override
        protected void addModelPoints(int n) {
            BuilderPaneSkills.this.points.allocatePoints(5.0 * (double)n);
        }

        @Override
        protected void setIncrementDecrementEnabled() {
            this.getIncrementButton().setEnabled(this.isEnabled() && this.getValue() < this.getMaxValue() && this.canIncrement());
            this.getDecrementButton().setEnabled(this.isEnabled() && this.getValue() > this.getMinValue());
        }

        private boolean canIncrement() {
            if (BuilderPaneSkills.this.points != null) {
                return BuilderPaneSkills.this.points.getRemainingPoints() >= 5.0;
            }
            return true;
        }

        @Override
        protected void onMouseHover() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<div style=\"font-family: red; margin-bottom: 1em;\">");
            stringBuilder.append(this.skill.getNoun()).append("</div>");
            if (this.skill.isRestrictedToARole()) {
                stringBuilder.append("<div style=\"margin-bottom: 1em;\">Restricted to ");
                stringBuilder.append("<span style=\"font-family: red;\">");
                stringBuilder.append(this.skill.getRestrictToRole()).append("</span></div>");
            }
            stringBuilder.append("<div style=\"margin-bottom: 1em;\">Key Attribute: <span style=\"font-family: blue;\">");
            stringBuilder.append(this.skill.getKeyAttribute().name).append("</span></div>");
            if (!this.skill.isUsableUntrained()) {
                stringBuilder.append("<div style=\"font-family: green; margin-bottom: 1em;\">Requires training</div>");
            }
            if (this.skill.suffersArmorPenalty()) {
                stringBuilder.append("<div style=\"font-family: green; margin-bottom: 1em;\">Armor Penalty applies</div>");
            }
            stringBuilder.append(this.skill.getDescription());
            BuilderPaneSkills.this.getTextModel().setHtml(stringBuilder.toString());
            BuilderPaneSkills.this.getTextPane().invalidateLayout();
        }
    }
}

