/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.characterbuilder.AbstractBuilderPane;
import net.sf.hale.characterbuilder.Buildable;
import net.sf.hale.characterbuilder.BuildablePropertySelector;
import net.sf.hale.characterbuilder.BuilderPane;
import net.sf.hale.characterbuilder.CharacterBuilder;
import net.sf.hale.characterbuilder.PointAllocatorModel;
import net.sf.hale.entity.PC;
import net.sf.hale.rules.Role;

public class BuilderPaneRole
extends BuilderPane
implements PointAllocatorModel.Listener {
    private List<RoleSelector> roleSelectors;
    private PointAllocatorModel points;
    private PC workingCopy;

    public BuilderPaneRole(CharacterBuilder characterBuilder, Buildable buildable) {
        super(characterBuilder, "Role", buildable);
        if (!buildable.isNewCharacter()) {
            this.getBackButton().setVisible(false);
        }
        this.roleSelectors = new ArrayList<RoleSelector>();
        this.points = new PointAllocatorModel(1);
        this.points.addListener(this);
        super.setTitleText("Select a Role");
        this.allocatorModelUpdated();
        this.workingCopy = this.getCharacter().getWorkingCopy();
    }

    @Override
    protected void next() {
        this.setCharacterRole();
        if (this.getCharacter().isNewCharacter()) {
            super.next();
        } else {
            AbstractBuilderPane abstractBuilderPane = this.getCharacterBuilder().getNextPane(this);
            if (abstractBuilderPane == null) {
                return;
            }
            AbstractBuilderPane abstractBuilderPane2 = this.getCharacterBuilder().getNextPane(abstractBuilderPane);
            if (abstractBuilderPane2 != null) {
                this.getCharacterBuilder().setActivePane(abstractBuilderPane2);
            }
        }
    }

    private RoleSelector addSelector(Role role) {
        RoleSelector roleSelector = new RoleSelector(role);
        int n = this.getCharacter().getLevel(role);
        roleSelector.setValue(n);
        roleSelector.setMinMaxValue(n, n + 1);
        roleSelector.setPointAllocatorModel(this.points);
        if (role == this.getCharacter().getSelectedRole()) {
            roleSelector.addModelPoints(1);
            roleSelector.addValue(1);
        }
        this.roleSelectors.add(roleSelector);
        super.addSelector((Widget)roleSelector);
        return roleSelector;
    }

    @Override
    protected void updateCharacter() {
        for (RoleSelector object : this.roleSelectors) {
            this.points.removeListener(object);
        }
        this.roleSelectors.clear();
        this.clearSelectors();
        this.points.setPointsRemaining(1);
        for (Role role : this.getCharacter().getSelectableRoles()) {
            this.addSelector(role);
        }
        for (Role role : this.getCharacter().getFutureOrPastSelectableRoles()) {
            RoleSelector roleSelector = this.addSelector(role);
            roleSelector.setEnabled(false);
        }
        for (RoleSelector roleSelector : this.roleSelectors) {
            roleSelector.allocatorModelUpdated();
        }
        this.allocatorModelUpdated();
    }

    private void setCharacterRole() {
        for (RoleSelector roleSelector : this.roleSelectors) {
            if (roleSelector.getValue() <= roleSelector.getMinValue()) continue;
            this.getCharacter().setSelectedRole(roleSelector.role);
        }
    }

    @Override
    public void allocatorModelUpdated() {
        this.getNextButton().setEnabled(this.points.getRemainingPoints() < 1.0);
    }

    private void setTextAreaContent(Role role) {
        StringBuilder stringBuilder = new StringBuilder();
        role.appendDescription(stringBuilder, this.workingCopy);
        this.getTextModel().setHtml(stringBuilder.toString());
        this.getTextPane().invalidateLayout();
    }

    private class RoleSelector
    extends BuildablePropertySelector {
        private Role role;

        public RoleSelector(Role role) {
            super(role.getName(), role.getIcon(), true);
            this.role = role;
        }

        @Override
        protected void onMouseHover() {
            BuilderPaneRole.this.setTextAreaContent(this.role);
        }
    }
}

