/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.characterbuilder.Buildable;
import net.sf.hale.characterbuilder.BuildablePropertySelector;
import net.sf.hale.characterbuilder.BuilderPane;
import net.sf.hale.characterbuilder.CharacterBuilder;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.rules.Race;
import net.sf.hale.rules.RacialType;

public class BuilderPaneRace
extends BuilderPane {
    private List<RaceSelector> raceSelectors = new ArrayList<RaceSelector>();

    public BuilderPaneRace(CharacterBuilder characterBuilder, Buildable buildable) {
        super(characterBuilder, "Race", buildable);
        this.setTitleText("Select Race");
        for (Race race : this.getCharacter().getSelectableRaces()) {
            RaceSelector raceSelector = new RaceSelector(race);
            if (race == this.getCharacter().getSelectedRace()) {
                raceSelector.setSelected(true);
            }
            this.raceSelectors.add(raceSelector);
            this.addSelector((Widget)raceSelector);
        }
        this.getBackButton().setVisible(false);
    }

    @Override
    public void updateCharacter() {
        Race race = this.getCharacter().getSelectedRace();
        for (RaceSelector raceSelector : this.raceSelectors) {
            raceSelector.setSelected(raceSelector.race == race);
        }
        this.getNextButton().setEnabled(race != null);
    }

    @Override
    public void next() {
        for (RaceSelector raceSelector : this.raceSelectors) {
            if (!raceSelector.isSelected()) continue;
            this.getCharacter().setSelectedRace(raceSelector.race);
            break;
        }
        super.next();
    }

    private class RaceSelector
    extends BuildablePropertySelector {
        private Race race;

        private RaceSelector(Race race) {
            super(race.getName(), IconFactory.createIcon(race.getIcon()), false);
            this.race = race;
            this.setSelectable(true);
        }

        @Override
        protected void onMouseClick() {
            for (RaceSelector raceSelector : BuilderPaneRace.this.raceSelectors) {
                raceSelector.setSelected(false);
            }
            this.setSelected(true);
            BuilderPaneRace.this.getNextButton().setEnabled(true);
        }

        @Override
        protected void onMouseHover() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<div style=\"font-family: large-red; \">");
            stringBuilder.append(this.race.getName()).append("</div>");
            stringBuilder.append("<div style=\"font-family: blue; margin-bottom: 1em;\">");
            List<RacialType> list = this.race.getRacialTypes();
            for (RacialType racialType : list) {
                stringBuilder.append(racialType.getName()).append(" ");
            }
            stringBuilder.append("</div>");
            int n = 10000 / this.race.getMovementCost();
            stringBuilder.append("<div style=\"margin-bottom: 1em;\">Base Speed: <span style=\"font-family: green;\">");
            stringBuilder.append(n).append(" hexes / turn</span></div>");
            stringBuilder.append(this.race.getDescriptionFile());
            stringBuilder.append("<div style=\"margin-top: 1em; font-family: medium\">Base Racial Attributes</div>");
            stringBuilder.append("<table style=\"width: 22ex;\">");
            stringBuilder.append("<tr><td>Strength</td><td style=\"font-family: red; text-align:right;\">");
            stringBuilder.append(this.race.getBaseStr());
            stringBuilder.append("</td></tr><tr><td>Dexterity</td><td style=\"font-family: red; text-align:right;\">");
            stringBuilder.append(this.race.getBaseDex());
            stringBuilder.append("</td></tr><tr><td>Constitution</td><td style=\"font-family: red; text-align:right;\">");
            stringBuilder.append(this.race.getBaseCon());
            stringBuilder.append("</td></tr><tr><td>Intelligence</td><td style=\"font-family: red; text-align:right;\">");
            stringBuilder.append(this.race.getBaseInt());
            stringBuilder.append("</td></tr><tr><td>Wisdom</td><td style=\"font-family: red; text-align:right;\">");
            stringBuilder.append(this.race.getBaseWis());
            stringBuilder.append("</td></tr><tr><td>Charisma</td><td style=\"font-family: red; text-align:right;\">");
            stringBuilder.append(this.race.getBaseCha());
            stringBuilder.append("</td></tr></table>");
            BuilderPaneRace.this.getTextModel().setHtml(stringBuilder.toString());
            BuilderPaneRace.this.getTextPane().invalidateLayout();
        }
    }
}

