/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.utils.TintAnimator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.characterbuilder.AbstractBuilderPane;
import net.sf.hale.characterbuilder.Buildable;
import net.sf.hale.characterbuilder.BuildablePropertySelector;
import net.sf.hale.characterbuilder.CharacterBuilder;
import net.sf.hale.characterbuilder.ColorSelectorPopup;
import net.sf.hale.characterbuilder.PortraitSelector;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.PC;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.resource.SpriteManager;
import net.sf.hale.rules.Ruleset;
import net.sf.hale.widgets.BasePortraitViewer;

public class BuilderPaneCosmetic
extends AbstractBuilderPane
implements PortraitSelector.Callback {
    private static final int DEFAULT_HAIR = 2;
    private static final int DEFAULT_BEARD = 1;
    private static final Color DEFAULT_BEARD_COLOR = Color.MAROON;
    private static final Color DEFAULT_HAIR_COLOR = Color.MAROON;
    private static final Color DEFAULT_SKIN_COLOR = new Color(-601189);
    private static final Color DEFAULT_CLOTHING_COLOR = Color.GREEN;
    private static final Color[] HAIR_BEARD_COLORS = new Color[]{Color.WHITE, Color.SILVER, Color.GRAY, new Color(-11250604), new Color(-11250604), Color.BLACK, new Color(-1120635), Color.YELLOW, new Color(-3368704), new Color(-2521319), Color.ORANGE, new Color(-1149440), Color.RED, new Color(-4194304), Color.MAROON, new Color(-3308225), new Color(-7644629), new Color(-7644672), new Color(-7650029), new Color(-10734825)};
    private static final Color[] SKIN_COLORS = new Color[]{new Color(-396088), new Color(-601189), new Color(-466808), new Color(-601189), new Color(-1200537), new Color(-3238830), new Color(-9221591), new Color(-12443376), new Color(-13692912), new Color(-14444), new Color(-2849183), new Color(-8371925), new Color(-11530238)};
    private static final Color[] CLOTHING_COLORS = new Color[]{Color.WHITE, Color.SILVER, Color.GRAY, new Color(-12303292), Color.MAROON, Color.RED, Color.ORANGE, Color.YELLOW, Color.LIGHTYELLOW, Color.GREEN, Color.OLIVE, Color.LIME, Color.TEAL, Color.AQUA, Color.LIGHTBLUE, Color.BLUE, Color.NAVY, Color.LIGHTPINK, Color.FUCHSIA, Color.PURPLE, new Color(-11530238)};
    private Widget appearanceHolder;
    private CharacterViewer characterViewer;
    private PortraitViewer portraitViewer;
    private int gap;
    private int smallGap;
    private String noNameMessage;
    private String noGenderMessage;
    private String noPortraitMessage;
    private PC workingCopy;
    private Label nameLabel;
    private EditField nameField;
    private Button randomName;
    private Label genderLabel;
    private List<GenderSelector> genderSelectors;
    private int hairStyleMax;
    private Color currentHairColor;
    private int currentHairStyle;
    private final NumberFormat numberFormat = NumberFormat.getInstance();
    private Label hairLabel;
    private Label hairStyleLabel;
    private Button prevHairStyle;
    private Button nextHairStyle;
    private ColorPicker hairColorPicker;
    private int beardStyleMax;
    private Color currentBeardColor;
    private int currentBeardStyle;
    private Label beardLabel;
    private Label beardStyleLabel;
    private Button prevBeardStyle;
    private Button nextBeardStyle;
    private ColorPicker beardColorPicker;
    private Label skinLabel;
    private ColorPicker skinColorPicker;
    private Color currentSkinColor;
    private Label clothingLabel;
    private ColorPicker clothingColorPicker;
    private Color currentClothingColor;
    private Label portraitLabel;
    private Button choosePortrait;

    public BuilderPaneCosmetic(CharacterBuilder characterBuilder, Buildable buildable) {
        super(characterBuilder, "Cosmetic", buildable);
        this.numberFormat.setMinimumIntegerDigits(3);
        this.numberFormat.setMaximumIntegerDigits(3);
        int n = 1;
        String string = null;
        do {
            string = "subIcons/hair" + this.numberFormat.format(n);
            ++n;
        } while (SpriteManager.hasSprite(string));
        this.hairStyleMax = n - 2;
        this.currentHairStyle = 2;
        this.currentHairColor = DEFAULT_HAIR_COLOR;
        n = 1;
        string = null;
        do {
            string = "subIcons/beard" + this.numberFormat.format(n);
            ++n;
        } while (SpriteManager.hasSprite(string));
        this.beardStyleMax = n - 2;
        this.currentBeardStyle = 1;
        this.currentBeardColor = DEFAULT_BEARD_COLOR;
        this.appearanceHolder = new AppearanceArea();
        this.add(this.appearanceHolder);
        this.characterViewer = new CharacterViewer();
        this.characterViewer.setTheme("characterviewer");
        this.appearanceHolder.add((Widget)this.characterViewer);
        this.portraitViewer = new PortraitViewer(this.workingCopy);
        this.appearanceHolder.add((Widget)this.portraitViewer);
        this.nameLabel = new Label("Name");
        this.nameLabel.setTheme("namelabel");
        this.add((Widget)this.nameLabel);
        this.nameField = new EditField();
        this.nameField.addCallback(new EditField.Callback(){

            public void callback(int n) {
                BuilderPaneCosmetic.this.setName(BuilderPaneCosmetic.this.nameField.getText());
            }
        });
        this.nameField.setTheme("nameeditfield");
        this.add((Widget)this.nameField);
        this.randomName = new Button("Random");
        this.randomName.setTheme("randomnamebutton");
        this.randomName.addCallback(new Runnable(){

            @Override
            public void run() {
                if (BuilderPaneCosmetic.this.workingCopy.getTemplate().getGender() == Ruleset.Gender.Male) {
                    BuilderPaneCosmetic.this.nameField.setText(BuilderPaneCosmetic.this.workingCopy.getTemplate().getRace().getRandomMaleName());
                } else {
                    BuilderPaneCosmetic.this.nameField.setText(BuilderPaneCosmetic.this.workingCopy.getTemplate().getRace().getRandomFemaleName());
                }
            }
        });
        this.add((Widget)this.randomName);
        this.genderLabel = new Label("Gender");
        this.genderLabel.setTheme("genderlabel");
        this.add((Widget)this.genderLabel);
        this.genderSelectors = new ArrayList<GenderSelector>();
        for (Ruleset.Gender gender : Ruleset.Gender.values()) {
            String string2 = gender.toString() + "Icon";
            GenderSelector genderSelector = new GenderSelector(gender, Game.ruleset.getString(string2));
            genderSelector.setTheme("genderselector");
            this.add((Widget)genderSelector);
            this.genderSelectors.add(genderSelector);
        }
        this.hairLabel = new Label("Hair");
        this.hairLabel.setTheme("hairlabel");
        this.add((Widget)this.hairLabel);
        this.hairStyleLabel = new Label("Style");
        this.hairStyleLabel.setTheme("hairstylelabel");
        this.add((Widget)this.hairStyleLabel);
        this.prevHairStyle = new Button("<");
        this.prevHairStyle.addCallback(new Runnable(){

            @Override
            public void run() {
                BuilderPaneCosmetic.this.previousHairStyle();
            }
        });
        this.prevHairStyle.setTheme("prevhairstyle");
        this.add((Widget)this.prevHairStyle);
        this.nextHairStyle = new Button(">");
        this.nextHairStyle.addCallback(new Runnable(){

            @Override
            public void run() {
                BuilderPaneCosmetic.this.nextHairStyle();
            }
        });
        this.nextHairStyle.setTheme("nexthairstyle");
        this.add((Widget)this.nextHairStyle);
        this.hairColorPicker = new ColorPicker(new ColorCallback(){

            @Override
            public void colorSet(Color color) {
                BuilderPaneCosmetic.this.setHairColor(color);
            }

            @Override
            public Color getCurrentColor() {
                return BuilderPaneCosmetic.this.getCharacter().getSelectedHairColor();
            }
        }, HAIR_BEARD_COLORS);
        this.hairColorPicker.setTheme("haircolorpicker");
        this.add(this.hairColorPicker);
        this.beardLabel = new Label("Beard");
        this.beardLabel.setTheme("beardlabel");
        this.add((Widget)this.beardLabel);
        this.beardStyleLabel = new Label("Style");
        this.beardStyleLabel.setTheme("beardstylelabel");
        this.add((Widget)this.beardStyleLabel);
        this.prevBeardStyle = new Button("<");
        this.prevBeardStyle.addCallback(new Runnable(){

            @Override
            public void run() {
                BuilderPaneCosmetic.this.previousBeardStyle();
            }
        });
        this.prevBeardStyle.setTheme("prevbeardstyle");
        this.add((Widget)this.prevBeardStyle);
        this.nextBeardStyle = new Button(">");
        this.nextBeardStyle.addCallback(new Runnable(){

            @Override
            public void run() {
                BuilderPaneCosmetic.this.nextBeardStyle();
            }
        });
        this.nextBeardStyle.setTheme("nextbeardstyle");
        this.add((Widget)this.nextBeardStyle);
        this.beardColorPicker = new ColorPicker(new ColorCallback(){

            @Override
            public void colorSet(Color color) {
                BuilderPaneCosmetic.this.setBeardColor(color);
            }

            @Override
            public Color getCurrentColor() {
                return BuilderPaneCosmetic.this.getCharacter().getSelectedBeardColor();
            }
        }, HAIR_BEARD_COLORS);
        this.beardColorPicker.setTheme("beardcolorpicker");
        this.add(this.beardColorPicker);
        this.skinLabel = new Label("Skin");
        this.skinLabel.setTheme("skinlabel");
        this.add((Widget)this.skinLabel);
        this.skinColorPicker = new ColorPicker(new ColorCallback(){

            @Override
            public void colorSet(Color color) {
                BuilderPaneCosmetic.this.setSkinColor(color);
            }

            @Override
            public Color getCurrentColor() {
                return BuilderPaneCosmetic.this.getCharacter().getSelectedSkinColor();
            }
        }, SKIN_COLORS);
        this.skinColorPicker.setTheme("skincolorpicker");
        this.add(this.skinColorPicker);
        this.currentSkinColor = DEFAULT_SKIN_COLOR;
        this.clothingLabel = new Label("Clothing");
        this.clothingLabel.setTheme("clothinglabel");
        this.add((Widget)this.clothingLabel);
        this.clothingColorPicker = new ColorPicker(new ColorCallback(){

            @Override
            public void colorSet(Color color) {
                BuilderPaneCosmetic.this.setClothingColor(color);
            }

            @Override
            public Color getCurrentColor() {
                return BuilderPaneCosmetic.this.getCharacter().getSelectedClothingColor();
            }
        }, CLOTHING_COLORS);
        this.clothingColorPicker.setTheme("clothingcolorpicker");
        this.add(this.clothingColorPicker);
        this.currentClothingColor = DEFAULT_CLOTHING_COLOR;
        this.portraitLabel = new Label("Portrait");
        this.portraitLabel.setTheme("portraitlabel");
        this.add((Widget)this.portraitLabel);
        this.choosePortrait = new Button("Choose...");
        this.choosePortrait.addCallback(new Runnable(){

            @Override
            public void run() {
                PortraitSelector portraitSelector = new PortraitSelector(BuilderPaneCosmetic.this, BuilderPaneCosmetic.this.getCharacter());
                portraitSelector.setCallback(BuilderPaneCosmetic.this);
                portraitSelector.openPopupCentered();
            }
        });
        this.choosePortrait.setTheme("chooseportraitbutton");
        this.add((Widget)this.choosePortrait);
        this.getNextButton().setText("Finish & Save");
        this.updateWorkingCopy();
    }

    @Override
    public void next() {
        this.getCharacterBuilder().finish();
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.smallGap = themeInfo.getParameter("smallgap", 0);
        this.gap = themeInfo.getParameter("gap", 0);
        this.noNameMessage = themeInfo.getParameter("nonamemessage", (String)null);
        this.noGenderMessage = themeInfo.getParameter("nogendermessage", (String)null);
        this.noPortraitMessage = themeInfo.getParameter("noportraitmessage", (String)null);
    }

    @Override
    protected void layout() {
        super.layout();
        this.nameLabel.setSize(this.nameLabel.getPreferredWidth(), this.nameLabel.getPreferredHeight());
        this.genderLabel.setSize(this.genderLabel.getPreferredWidth(), this.genderLabel.getPreferredHeight());
        this.hairLabel.setSize(this.hairLabel.getPreferredWidth(), this.hairLabel.getPreferredHeight());
        this.beardLabel.setSize(this.beardLabel.getPreferredWidth(), this.beardLabel.getPreferredHeight());
        this.skinLabel.setSize(this.skinLabel.getPreferredWidth(), this.skinLabel.getPreferredHeight());
        this.clothingLabel.setSize(this.clothingLabel.getPreferredWidth(), this.clothingLabel.getPreferredHeight());
        this.portraitLabel.setSize(this.portraitLabel.getPreferredWidth(), this.portraitLabel.getPreferredHeight());
        int n = Math.max(this.nameLabel.getWidth(), this.genderLabel.getWidth());
        n = Math.max(n, this.hairLabel.getWidth());
        n = Math.max(n, this.beardLabel.getWidth());
        n = Math.max(n, this.skinLabel.getWidth());
        n = Math.max(n, this.portraitLabel.getWidth());
        n = Math.max(n, this.clothingLabel.getWidth());
        int n2 = this.getInnerX() + (n += this.gap) + this.gap;
        this.nameField.setSize(this.nameField.getPreferredWidth(), this.nameField.getPreferredHeight());
        this.nameField.setPosition(n2, this.getInnerY());
        int n3 = this.nameField.getY() + this.nameField.getHeight() / 2;
        this.randomName.setSize(this.randomName.getPreferredWidth(), this.randomName.getPreferredHeight());
        this.randomName.setPosition(this.nameField.getRight() + this.smallGap, n3 - this.randomName.getHeight() / 2);
        int n4 = this.nameField.getBottom() + this.gap;
        int n5 = n2;
        for (GenderSelector genderSelector : this.genderSelectors) {
            genderSelector.setSize(genderSelector.getPreferredWidth(), genderSelector.getPreferredHeight());
            genderSelector.setPosition(n5, n4);
            n5 = genderSelector.getRight() + this.smallGap;
        }
        int n6 = this.genderSelectors.get(0).getY() + this.genderSelectors.get(0).getHeight() / 2;
        this.hairColorPicker.setSize(this.hairColorPicker.getPreferredWidth(), this.hairColorPicker.getPreferredHeight());
        int n7 = this.genderSelectors.get(0).getBottom() + this.gap + this.hairColorPicker.getHeight() / 2;
        this.hairStyleLabel.setSize(this.hairStyleLabel.getPreferredWidth(), this.hairStyleLabel.getPreferredHeight());
        this.prevHairStyle.setSize(this.prevHairStyle.getPreferredWidth(), this.hairStyleLabel.getPreferredHeight());
        this.nextHairStyle.setSize(this.nextHairStyle.getPreferredWidth(), this.hairStyleLabel.getPreferredHeight());
        this.prevHairStyle.setPosition(n2, n7 - this.prevHairStyle.getHeight() / 2);
        this.hairStyleLabel.setPosition(this.prevHairStyle.getRight() + this.smallGap, n7 - this.hairStyleLabel.getHeight() / 2);
        this.nextHairStyle.setPosition(this.hairStyleLabel.getRight() + this.smallGap, n7 - this.nextHairStyle.getHeight() / 2);
        this.hairColorPicker.setPosition(this.nextHairStyle.getRight() + this.smallGap, n7 - this.hairColorPicker.getHeight() / 2);
        this.beardColorPicker.setSize(this.beardColorPicker.getPreferredWidth(), this.beardColorPicker.getPreferredHeight());
        int n8 = this.hairColorPicker.getBottom() + this.gap + this.beardColorPicker.getHeight() / 2;
        this.beardStyleLabel.setSize(this.beardStyleLabel.getPreferredWidth(), this.beardStyleLabel.getPreferredHeight());
        this.prevBeardStyle.setSize(this.prevBeardStyle.getPreferredWidth(), this.beardStyleLabel.getPreferredHeight());
        this.nextBeardStyle.setSize(this.nextBeardStyle.getPreferredWidth(), this.beardStyleLabel.getPreferredHeight());
        this.prevBeardStyle.setPosition(n2, n8 - this.prevBeardStyle.getHeight() / 2);
        this.beardStyleLabel.setPosition(this.prevBeardStyle.getRight() + this.smallGap, n8 - this.beardStyleLabel.getHeight() / 2);
        this.nextBeardStyle.setPosition(this.beardStyleLabel.getRight() + this.smallGap, n8 - this.nextBeardStyle.getHeight() / 2);
        this.beardColorPicker.setPosition(this.nextBeardStyle.getRight() + this.smallGap, n8 - this.beardColorPicker.getHeight() / 2);
        this.skinColorPicker.setSize(this.skinColorPicker.getPreferredWidth(), this.skinColorPicker.getPreferredHeight());
        int n9 = this.beardColorPicker.getBottom() + this.gap + this.skinColorPicker.getHeight() / 2;
        this.skinColorPicker.setPosition(n2, n9 - this.skinColorPicker.getHeight() / 2);
        this.clothingColorPicker.setSize(this.clothingColorPicker.getPreferredWidth(), this.clothingColorPicker.getPreferredHeight());
        int n10 = this.skinColorPicker.getBottom() + this.gap + this.clothingColorPicker.getHeight() / 2;
        this.clothingColorPicker.setPosition(n2, n10 - this.clothingColorPicker.getHeight() / 2);
        this.choosePortrait.setSize(this.choosePortrait.getPreferredWidth(), this.choosePortrait.getPreferredHeight());
        int n11 = this.clothingColorPicker.getBottom() + this.gap + this.choosePortrait.getHeight() / 2;
        this.choosePortrait.setPosition(n2, n11 - this.choosePortrait.getHeight() / 2);
        this.nameLabel.setPosition(n2 - this.gap - this.nameLabel.getWidth(), n3 - this.nameLabel.getHeight() / 2);
        this.genderLabel.setPosition(n2 - this.gap - this.genderLabel.getWidth(), n6 - this.genderLabel.getHeight() / 2);
        this.hairLabel.setPosition(n2 - this.gap - this.hairLabel.getWidth(), n7 - this.hairLabel.getHeight() / 2);
        this.beardLabel.setPosition(n2 - this.gap - this.beardLabel.getWidth(), n8 - this.beardLabel.getHeight() / 2);
        this.skinLabel.setPosition(n2 - this.gap - this.skinLabel.getWidth(), n9 - this.skinLabel.getHeight() / 2);
        this.clothingLabel.setPosition(n2 - this.gap - this.clothingLabel.getWidth(), n10 - this.clothingLabel.getHeight() / 2);
        this.portraitLabel.setPosition(n2 - this.gap - this.portraitLabel.getWidth(), n11 - this.portraitLabel.getHeight() / 2);
        this.appearanceHolder.setSize(this.appearanceHolder.getPreferredWidth(), this.appearanceHolder.getPreferredHeight());
        int n12 = Math.max(this.genderSelectors.get(this.genderSelectors.size() - 1).getRight(), this.nameField.getRight());
        n12 = Math.max(this.beardColorPicker.getRight(), n12);
        n12 = Math.max(this.hairColorPicker.getRight(), n12);
        n12 = Math.max(this.skinColorPicker.getRight(), n12);
        n12 = Math.max(this.clothingColorPicker.getRight(), n12);
        n12 = Math.max(this.choosePortrait.getRight(), n12);
        int n13 = (this.getInnerRight() + n12) / 2;
        this.appearanceHolder.setPosition(n13 - this.appearanceHolder.getWidth() / 2, this.getInnerY() + this.gap);
    }

    private void updateWorkingCopy() {
        this.workingCopy = this.getCharacter().getWorkingCopy();
        this.characterViewer.character = this.workingCopy;
        this.portraitViewer.setCreature(this.workingCopy);
        Button button = this.getNextButton();
        if (this.nameField.getTextLength() == 0) {
            button.setTooltipContent((Object)this.noNameMessage);
            button.setEnabled(false);
        } else if (this.getCharacter().getSelectedGender() == null) {
            button.setTooltipContent((Object)this.noGenderMessage);
            button.setEnabled(false);
        } else if (this.getCharacter().getSelectedPortrait() == null) {
            button.setTooltipContent((Object)this.noPortraitMessage);
            button.setEnabled(false);
        } else {
            button.setTooltipContent(null);
            button.setEnabled(true);
        }
        boolean bl = this.getCharacter().getSelectedGender() != null;
        boolean bl2 = this.getCharacter().getSelectedGender() != Ruleset.Gender.Female;
        this.beardColorPicker.setEnabled(bl && bl2);
        this.hairColorPicker.setEnabled(bl);
        this.nextHairStyle.setEnabled(bl);
        this.prevHairStyle.setEnabled(bl);
        this.nextBeardStyle.setEnabled(bl && bl2);
        this.prevBeardStyle.setEnabled(bl && bl2);
        this.choosePortrait.setEnabled(bl);
        this.skinColorPicker.setEnabled(bl);
        this.clothingColorPicker.setEnabled(bl);
        this.portraitViewer.setVisible(this.getCharacter().getSelectedPortrait() != null);
        this.invalidateLayout();
    }

    @Override
    protected void updateCharacter() {
        if (this.getCharacter().getSelectedName() == null) {
            this.nameField.setText("");
        }
        if (this.getCharacter().getSelectedGender() == null) {
            for (GenderSelector genderSelector : this.genderSelectors) {
                genderSelector.setSelected(false);
            }
        }
        if (this.getCharacter().getSelectedHairIcon() == null) {
            this.currentHairStyle = 2;
            this.currentHairColor = DEFAULT_HAIR_COLOR;
        }
        if (this.getCharacter().getSelectedBeardIcon() == null) {
            this.currentBeardStyle = 1;
            this.currentBeardColor = DEFAULT_BEARD_COLOR;
        }
        if (this.getCharacter().getSelectedSkinColor() == null) {
            this.currentSkinColor = DEFAULT_SKIN_COLOR;
        }
        if (this.getCharacter().getSelectedClothingColor() == null) {
            this.currentClothingColor = DEFAULT_CLOTHING_COLOR;
        }
        this.updateWorkingCopy();
    }

    @Override
    public void portraitSelected(String string) {
        this.getCharacter().setSelectedPortrait(string);
        this.updateWorkingCopy();
    }

    private void setGender(Ruleset.Gender gender) {
        this.getCharacter().setSelectedGender(gender);
        this.getCharacter().setSelectedSkinColor(this.currentSkinColor);
        this.getCharacter().setSelectedClothingColor(this.currentClothingColor);
        this.getCharacter().setSelectedHairIcon("subIcons/hair" + this.numberFormat.format(this.currentHairStyle));
        this.getCharacter().setSelectedHairColor(this.currentHairColor);
        if (gender == Ruleset.Gender.Female) {
            this.getCharacter().setSelectedBeardIcon(null);
            this.getCharacter().setSelectedBeardColor(null);
            this.currentBeardStyle = 1;
        } else {
            this.getCharacter().setSelectedBeardIcon("subIcons/beard" + this.numberFormat.format(this.currentBeardStyle));
            this.getCharacter().setSelectedBeardColor(this.currentBeardColor);
        }
        this.updateWorkingCopy();
    }

    private void setName(String string) {
        this.getCharacter().setSelectedName(string);
        this.updateWorkingCopy();
    }

    private void setClothingColor(Color color) {
        this.currentClothingColor = color;
        this.getCharacter().setSelectedClothingColor(color);
        this.updateWorkingCopy();
    }

    private void setSkinColor(Color color) {
        this.currentSkinColor = color;
        this.getCharacter().setSelectedSkinColor(color);
        this.updateWorkingCopy();
    }

    private void setHairColor(Color color) {
        this.currentHairColor = color;
        this.getCharacter().setSelectedHairColor(color);
        this.updateWorkingCopy();
    }

    private void setBeardColor(Color color) {
        this.currentBeardColor = color;
        this.getCharacter().setSelectedBeardColor(color);
        this.updateWorkingCopy();
    }

    private void previousBeardStyle() {
        --this.currentBeardStyle;
        if (this.currentBeardStyle == 0) {
            this.currentBeardStyle = this.beardStyleMax;
        }
        this.getCharacter().setSelectedBeardIcon("subIcons/beard" + this.numberFormat.format(this.currentBeardStyle));
        this.updateWorkingCopy();
    }

    private void nextBeardStyle() {
        ++this.currentBeardStyle;
        if (this.currentBeardStyle > this.beardStyleMax) {
            this.currentBeardStyle = 1;
        }
        this.getCharacter().setSelectedBeardIcon("subIcons/beard" + this.numberFormat.format(this.currentBeardStyle));
        this.updateWorkingCopy();
    }

    private void previousHairStyle() {
        --this.currentHairStyle;
        if (this.currentHairStyle == 0) {
            this.currentHairStyle = this.hairStyleMax;
        }
        this.getCharacter().setSelectedHairIcon("subIcons/hair" + this.numberFormat.format(this.currentHairStyle));
        this.updateWorkingCopy();
    }

    private void nextHairStyle() {
        ++this.currentHairStyle;
        if (this.currentHairStyle > this.hairStyleMax) {
            this.currentHairStyle = 1;
        }
        this.getCharacter().setSelectedHairIcon("subIcons/hair" + this.numberFormat.format(this.currentHairStyle));
        this.updateWorkingCopy();
    }

    private class CharacterViewer
    extends Widget {
        private PC character;

        private CharacterViewer() {
        }

        protected void paintWidget(GUI gUI) {
            if (this.character != null) {
                this.character.uiDraw(this.getInnerX(), this.getInnerY());
            }
        }

        public int getPreferredInnerWidth() {
            return 72;
        }

        public int getPreferredInnerHeight() {
            return 72;
        }
    }

    private class ColorButton
    extends Button
    implements Runnable {
        private Color color;
        private ColorCallback callback;

        private ColorButton(Color color, ColorCallback colorCallback) {
            this.setTintAnimator(new TintAnimator((TintAnimator.TimeSource)new TintAnimator.GUITimeSource((Widget)this), color));
            this.addCallback(this);
            this.color = color;
            this.callback = colorCallback;
        }

        @Override
        public void run() {
            this.callback.colorSet(this.color);
        }
    }

    private static interface ColorCallback {
        public void colorSet(Color var1);

        public Color getCurrentColor();
    }

    private class ColorPicker
    extends Widget {
        private int numColumns;
        private final ColorCallback callback;
        private List<ColorButton> colorButtons;
        private Button otherColorButton;

        private ColorPicker(ColorCallback colorCallback, Color[] colorArray) {
            this.callback = colorCallback;
            this.colorButtons = new ArrayList<ColorButton>();
            for (Color color : colorArray) {
                this.colorButtons.add(new ColorButton(color, colorCallback));
            }
            this.otherColorButton = new Button("Other...");
            this.otherColorButton.addCallback(new Runnable(){

                @Override
                public void run() {
                    ColorSelectorPopup colorSelectorPopup = new ColorSelectorPopup(BuilderPaneCosmetic.this);
                    colorSelectorPopup.addCallback(new ColorSelectorPopup.Callback(){

                        @Override
                        public void colorSelected(Color color) {
                            ColorPicker.this.callback.colorSet(color);
                        }
                    });
                    colorSelectorPopup.setColor(ColorPicker.this.callback.getCurrentColor());
                    colorSelectorPopup.openPopupCentered();
                }
            });
            this.otherColorButton.setTheme("othercolorbutton");
            this.add((Widget)this.otherColorButton);
            for (ColorButton colorButton : this.colorButtons) {
                this.add((Widget)colorButton);
            }
        }

        protected void layout() {
            int n = this.getInnerX();
            int n2 = this.getInnerY();
            int n3 = 0;
            for (ColorButton colorButton : this.colorButtons) {
                colorButton.setSize(colorButton.getPreferredWidth(), colorButton.getPreferredHeight());
                colorButton.setPosition(n, n2);
                n = colorButton.getRight();
                if (++n3 != this.numColumns) continue;
                n3 = 0;
                n = this.getInnerX();
                n2 = colorButton.getBottom();
            }
            this.otherColorButton.setSize(this.getInnerRight() - n, this.colorButtons.get(0).getPreferredHeight());
            this.otherColorButton.setPosition(n, n2);
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.numColumns = themeInfo.getParameter("numcolumns", 0);
        }

        public int getPreferredWidth() {
            return this.colorButtons.get(0).getPreferredWidth() * this.numColumns + this.getBorderHorizontal();
        }

        public int getPreferredHeight() {
            return this.colorButtons.get(0).getPreferredHeight() * (this.colorButtons.size() / this.numColumns + 1);
        }
    }

    private class GenderSelector
    extends BuildablePropertySelector {
        private Ruleset.Gender gender;

        private GenderSelector(Ruleset.Gender gender, String string) {
            super(gender.toString(), IconFactory.createIcon(string), false);
            this.gender = gender;
            this.setSelectable(true);
        }

        @Override
        protected void onMouseClick() {
            BuilderPaneCosmetic.this.setGender(this.gender);
            for (GenderSelector genderSelector : BuilderPaneCosmetic.this.genderSelectors) {
                genderSelector.setSelected(false);
            }
            this.setSelected(true);
        }
    }

    private class PortraitViewer
    extends BasePortraitViewer {
        private PortraitViewer(Creature creature) {
            super(creature);
        }

        @Override
        public int getPreferredWidth() {
            return 100 + this.getBorderHorizontal();
        }

        @Override
        public int getPreferredHeight() {
            return 100 + this.getBorderVertical();
        }
    }

    private class AppearanceArea
    extends Widget {
        private AppearanceArea() {
        }

        public int getPreferredWidth() {
            return this.getBorderHorizontal() + BuilderPaneCosmetic.this.portraitViewer.getPreferredWidth() + BuilderPaneCosmetic.this.characterViewer.getPreferredWidth();
        }

        public int getPreferredHeight() {
            return Math.max(BuilderPaneCosmetic.this.portraitViewer.getPreferredHeight(), BuilderPaneCosmetic.this.characterViewer.getPreferredHeight()) + this.getBorderVertical();
        }

        protected void layout() {
            BuilderPaneCosmetic.this.portraitViewer.setSize(BuilderPaneCosmetic.this.portraitViewer.getPreferredWidth(), BuilderPaneCosmetic.this.portraitViewer.getPreferredHeight());
            BuilderPaneCosmetic.this.portraitViewer.setPosition(this.getInnerX(), this.getInnerY());
            BuilderPaneCosmetic.this.characterViewer.setSize(BuilderPaneCosmetic.this.characterViewer.getPreferredWidth(), BuilderPaneCosmetic.this.characterViewer.getPreferredHeight());
            BuilderPaneCosmetic.this.characterViewer.setPosition(BuilderPaneCosmetic.this.portraitViewer.getRight(), this.getInnerY() + this.getInnerHeight() / 2 - BuilderPaneCosmetic.this.characterViewer.getHeight() / 2);
        }
    }
}

