/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.Widget;
import net.sf.hale.Game;
import net.sf.hale.bonus.Stat;
import net.sf.hale.characterbuilder.Buildable;
import net.sf.hale.characterbuilder.BuildablePropertySelector;
import net.sf.hale.characterbuilder.BuilderPane;
import net.sf.hale.characterbuilder.CharacterBuilder;
import net.sf.hale.characterbuilder.PointAllocatorModel;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.rules.Race;

public class BuilderPaneAttributes
extends BuilderPane
implements PointAllocatorModel.Listener {
    private PointAllocatorModel points = new PointAllocatorModel(Game.ruleset.getValue("StartingAttributePoints"));
    private AttributeSelector[] selectors;
    private final double expBase;
    private final Button defaultButton;
    private final Button raceRoleButton;

    public BuilderPaneAttributes(CharacterBuilder characterBuilder, Buildable buildable) {
        super(characterBuilder, "Attributes", buildable);
        this.points.addListener(this);
        this.expBase = (double)Game.ruleset.getValue("AttributePointCostExpBaseNumerator") / (double)Game.ruleset.getValue("AttributePointCostExpBaseDenominator");
        this.setTitleText("Select Attributes");
        this.selectors = new AttributeSelector[6];
        this.selectors[0] = new AttributeSelector(Stat.Str, Game.ruleset.getString("StrengthIcon"));
        this.selectors[1] = new AttributeSelector(Stat.Dex, Game.ruleset.getString("DexterityIcon"));
        this.selectors[2] = new AttributeSelector(Stat.Con, Game.ruleset.getString("ConstitutionIcon"));
        this.selectors[3] = new AttributeSelector(Stat.Int, Game.ruleset.getString("IntelligenceIcon"));
        this.selectors[4] = new AttributeSelector(Stat.Wis, Game.ruleset.getString("WisdomIcon"));
        this.selectors[5] = new AttributeSelector(Stat.Cha, Game.ruleset.getString("CharismaIcon"));
        for (AttributeSelector attributeSelector : this.selectors) {
            this.addSelector((Widget)attributeSelector);
            attributeSelector.setPointAllocatorModel(this.points);
        }
        this.allocatorModelUpdated();
        this.defaultButton = new Button("Racial Defaults");
        this.defaultButton.setTheme("defaultbutton");
        this.defaultButton.addCallback(new Runnable(){

            @Override
            public void run() {
                BuilderPaneAttributes.this.setDefaultValues();
            }
        });
        this.add((Widget)this.defaultButton);
        this.raceRoleButton = new Button("Suggested Values");
        this.raceRoleButton.setTheme("racerolebutton");
        this.raceRoleButton.addCallback(new Runnable(){

            @Override
            public void run() {
                BuilderPaneAttributes.this.setRoleValues();
            }
        });
        this.add((Widget)this.raceRoleButton);
    }

    private void setDefaultValues() {
        for (AttributeSelector attributeSelector : this.selectors) {
            int n = attributeSelector.baseValue - attributeSelector.getValue();
            attributeSelector.addModelPoints(n);
            attributeSelector.addValue(n);
        }
    }

    private void setRoleValues() {
        for (AttributeSelector attributeSelector : this.selectors) {
            int n = this.getCharacter().getSelectedRole().getDefaultPlayerAttributeSelection(attributeSelector.stat);
            int n2 = attributeSelector.baseValue + n - attributeSelector.getValue();
            attributeSelector.addModelPoints(n2);
            attributeSelector.addValue(n2);
        }
    }

    @Override
    protected void layout() {
        super.layout();
        ScrollPane scrollPane = this.getSelectorPane();
        this.defaultButton.setSize(this.defaultButton.getPreferredWidth(), this.defaultButton.getPreferredHeight());
        this.raceRoleButton.setSize(this.raceRoleButton.getPreferredWidth(), this.raceRoleButton.getPreferredHeight());
        this.defaultButton.setPosition(this.getInnerX(), scrollPane.getBottom());
        this.raceRoleButton.setPosition(this.defaultButton.getRight(), scrollPane.getBottom());
    }

    @Override
    protected void next() {
        this.setCharacterAttributes();
        super.next();
    }

    private void setCharacterAttributes() {
        int[] nArray = new int[6];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.selectors[i].getValue();
        }
        this.getCharacter().setSelectedAttributes(nArray);
    }

    @Override
    public void updateCharacter() {
        this.points.setPointsRemaining(Game.ruleset.getValue("StartingAttributePoints"));
        Race race = this.getCharacter().getSelectedRace();
        this.selectors[0].baseValue = race.getBaseStr();
        this.selectors[1].baseValue = race.getBaseDex();
        this.selectors[2].baseValue = race.getBaseCon();
        this.selectors[3].baseValue = race.getBaseInt();
        this.selectors[4].baseValue = race.getBaseWis();
        this.selectors[5].baseValue = race.getBaseCha();
        int[] nArray = this.getCharacter().getSelectedAttributes();
        int n = 0;
        for (AttributeSelector attributeSelector : this.selectors) {
            int n2 = this.getCharacter().getSelectedRole().getDefaultPlayerAttributeSelection(attributeSelector.stat);
            attributeSelector.setMinMaxValue(attributeSelector.baseValue - 3, attributeSelector.baseValue + 10);
            attributeSelector.setValue(attributeSelector.baseValue);
            int n3 = 0;
            n3 = nArray != null ? nArray[n] - attributeSelector.baseValue : n2;
            attributeSelector.addModelPoints(n3);
            attributeSelector.addValue(n3);
            ++n;
        }
        this.allocatorModelUpdated();
    }

    @Override
    public void allocatorModelUpdated() {
        double d = this.points.getRemainingPoints();
        boolean bl = true;
        for (AttributeSelector attributeSelector : this.selectors) {
            if (!attributeSelector.canIncrement()) continue;
            bl = false;
            break;
        }
        this.getNextButton().setEnabled(bl);
        this.setPointsText(Game.numberFormat(1).format(d) + " points remaining");
    }

    private class AttributeSelector
    extends BuildablePropertySelector {
        private Stat stat;
        private int baseValue;

        public AttributeSelector(Stat stat, String string) {
            super(stat.name, IconFactory.createIcon(string), true);
            this.stat = stat;
            this.baseValue = 0;
        }

        private final double getCost(int n, int n2) {
            double d = n - n2;
            return d * Math.pow(BuilderPaneAttributes.this.expBase, d);
        }

        private boolean canIncrement() {
            double d = this.getCost(this.getValue() + 1, this.baseValue) - this.getCost(this.getValue(), this.baseValue);
            return d < BuilderPaneAttributes.this.points.getRemainingPoints();
        }

        @Override
        protected void setIncrementDecrementEnabled() {
            boolean bl = BuilderPaneAttributes.this.points != null ? this.canIncrement() : true;
            this.getIncrementButton().setEnabled(this.isEnabled() && this.getValue() < this.getMaxValue() && bl);
            this.getDecrementButton().setEnabled(this.isEnabled() && this.getValue() > this.getMinValue());
        }

        @Override
        protected void addModelPoints(int n) {
            double d = this.getCost(this.getValue() + n, this.baseValue) - this.getCost(this.getValue(), this.baseValue);
            BuilderPaneAttributes.this.points.allocatePoints(d);
        }

        @Override
        protected void onMouseHover() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><body>");
            stringBuilder.append("<div style=\"font-family: red; margin-bottom: 1em;\">" + this.stat.name + "</div>");
            stringBuilder.append(ResourceManager.getResourceAsString("descriptions/stats/" + this.stat.name, ResourceType.HTML));
            stringBuilder.append("</body></html>");
            BuilderPaneAttributes.this.getTextModel().setHtml(stringBuilder.toString());
            BuilderPaneAttributes.this.getTextPane().invalidateLayout();
        }

        @Override
        protected void addValue(int n) {
            super.addValue(n);
            BuilderPaneAttributes.this.points.allocatePoints(0.0);
        }
    }
}

