/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.ability.Ability;
import net.sf.hale.ability.AbilitySelectionList;
import net.sf.hale.characterbuilder.AbilitySelectionListPane;
import net.sf.hale.characterbuilder.AbilitySelectorButton;
import net.sf.hale.characterbuilder.AbstractBuilderPane;
import net.sf.hale.characterbuilder.Buildable;
import net.sf.hale.characterbuilder.CharacterBuilder;
import net.sf.hale.characterbuilder.IconButton;
import net.sf.hale.entity.PC;
import net.sf.hale.rules.Role;

public class BuilderPaneAbilities
extends AbstractBuilderPane
implements AbilitySelectorButton.Callback,
AbilitySelectorButton.HoverHolder {
    private Selection currentSelection;
    private List<Selection> selections;
    private ScrollPane abilitiesPane;
    private Label titleLabel;
    private Button resetButton;
    private int resetGap;
    private ScrollPane selectedAbilitiesPane;
    private Widget hoverTop;
    private Widget hoverBottom;

    public BuilderPaneAbilities(CharacterBuilder characterBuilder, Buildable buildable) {
        super(characterBuilder, "Abilities", buildable);
        if (!buildable.isNewCharacter()) {
            this.getNextButton().setText("Finish");
        }
        this.titleLabel = new Label("Selections");
        this.titleLabel.setTheme("titlelabel");
        this.add((Widget)this.titleLabel);
        this.abilitiesPane = new ScrollPane();
        this.abilitiesPane.setTheme("abilitiespane");
        this.add((Widget)this.abilitiesPane);
        this.selections = new ArrayList<Selection>();
        this.selectedAbilitiesPane = new ScrollPane();
        this.selectedAbilitiesPane.setFixed(ScrollPane.Fixed.VERTICAL);
        this.selectedAbilitiesPane.setTheme("selectedabilitiespane");
        this.add((Widget)this.selectedAbilitiesPane);
        this.resetButton = new Button("Reset Selections");
        this.resetButton.setTheme("resetbutton");
        this.resetButton.addCallback(new Runnable(){

            @Override
            public void run() {
                BuilderPaneAbilities.this.resetSelections();
            }
        });
        this.add((Widget)this.resetButton);
    }

    @Override
    protected void next() {
        if (this.getCharacter().isNewCharacter()) {
            super.next();
        } else {
            this.getCharacterBuilder().finish();
        }
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        this.resetGap = themeInfo.getParameter("resetGap", 0);
    }

    @Override
    protected void layout() {
        super.layout();
        this.titleLabel.setSize(this.titleLabel.getPreferredWidth(), this.titleLabel.getPreferredHeight());
        this.resetButton.setSize(this.resetButton.getPreferredWidth(), this.resetButton.getPreferredHeight());
        this.resetButton.setPosition(this.getInnerX(), this.getNextButton().getY() - this.resetGap - this.resetButton.getHeight());
        this.selectedAbilitiesPane.setPosition(this.getInnerX(), this.getInnerY() + this.titleLabel.getHeight());
        this.selectedAbilitiesPane.setSize(this.selectedAbilitiesPane.getPreferredWidth(), Math.max(this.selectedAbilitiesPane.getMinWidth(), this.resetButton.getY() - this.titleLabel.getBottom()));
        this.titleLabel.setPosition(this.getInnerX(), this.getInnerY());
        int n = Math.max(this.getNextButton().getRight(), this.selectedAbilitiesPane.getRight());
        n = Math.max(n, this.resetButton.getRight());
        this.abilitiesPane.setPosition(n, this.getInnerY());
        this.abilitiesPane.setSize(this.getInnerRight() - this.abilitiesPane.getX(), this.getInnerBottom() - this.abilitiesPane.getY());
    }

    @Override
    protected void updateCharacter() {
        int n = this.getCharacter().getCreatureLevel();
        Role role = this.getCharacter().getSelectedRole();
        int n2 = this.getCharacter().getLevel(role) + 1;
        List<AbilitySelectionList> list = this.getCharacter().getWorkingCopy().getTemplate().getRace().getAbilitySelectionsAddedAtLevel(n);
        List<AbilitySelectionList> list2 = this.getCharacter().getSelectedRole().getAbilitySelectionsAddedAtLevel(n2);
        ArrayList<AbilitySelectionList> arrayList = new ArrayList<AbilitySelectionList>();
        arrayList.addAll(list);
        arrayList.addAll(list2);
        Iterator<Ability> iterator = this.getCharacter().getSelectedAbilities().iterator();
        this.selections.clear();
        for (AbilitySelectionList abilitySelectionList : arrayList) {
            Selection selection = new Selection(abilitySelectionList);
            if (iterator.hasNext()) {
                selection.selectedAbility = iterator.next();
            }
            this.selections.add(selection);
        }
        this.selectedAbilitiesPane.setContent((Widget)new SelectedAbilitiesContent());
        this.chooseCurrentSelection();
    }

    private void chooseCurrentSelection() {
        int n = 0;
        this.currentSelection = null;
        PC pC = this.getCharacter().getWorkingCopy();
        for (Selection selection : this.selections) {
            if (selection.isMade()) continue;
            if (this.currentSelection == null) {
                this.currentSelection = selection;
                AbilitySelectionListPane abilitySelectionListPane = new AbilitySelectionListPane(selection.list, pC, this, true);
                abilitySelectionListPane.addAbilitySelectorCallback(this);
                this.abilitiesPane.setContent((Widget)abilitySelectionListPane);
            }
            ++n;
        }
        this.resetButton.setEnabled(n != this.selections.size());
        if (this.currentSelection != null) {
            this.getNextButton().setEnabled(false);
        } else {
            Widget widget = new Widget();
            widget.setTheme("");
            this.abilitiesPane.setContent(widget);
            this.getNextButton().setEnabled(true);
        }
        this.invalidateLayout();
    }

    private void resetSelections() {
        for (Selection selection : this.selections) {
            selection.clearAbility();
        }
        this.getCharacter().clearSelectedAbilities();
        this.chooseCurrentSelection();
    }

    @Override
    public void selectionMade(Ability ability) {
        this.currentSelection.setAbility(ability);
        this.getCharacter().addSelectedAbility(ability);
        this.chooseCurrentSelection();
    }

    @Override
    public void setHoverWidgets(Widget widget, Widget widget2) {
        if (this.hoverTop != null) {
            this.removeChild(this.hoverTop);
        }
        if (this.hoverBottom != null) {
            this.removeChild(this.hoverBottom);
        }
        this.hoverTop = widget;
        this.hoverBottom = widget2;
        if (widget != null) {
            this.add(widget);
        }
        if (widget2 != null) {
            this.add(widget2);
        }
    }

    @Override
    public void removeHoverWidgets(Widget widget, Widget widget2) {
        if (this.hoverTop != null && this.hoverTop == widget) {
            this.removeChild(this.hoverTop);
            this.hoverTop = null;
        }
        if (this.hoverBottom != null && this.hoverBottom == widget2) {
            this.removeChild(this.hoverBottom);
            this.hoverBottom = null;
        }
    }

    private class Selection {
        private Ability selectedAbility;
        private AbilitySelectionList list;
        private AbilitySelectionViewer selector;

        private Selection(AbilitySelectionList abilitySelectionList) {
            this.list = abilitySelectionList;
            this.selector = new AbilitySelectionViewer(abilitySelectionList.getName() + " Ability");
        }

        private void setAbility(Ability ability) {
            this.selectedAbility = ability;
            this.selector.setAbility(ability);
        }

        private void clearAbility() {
            this.selectedAbility = null;
            this.selector.clearAbility();
        }

        private boolean isMade() {
            return this.selectedAbility != null;
        }
    }

    private class SelectedAbilityHover
    extends Widget {
        private Label abilityNameLabel;
        private Widget parent;

        private SelectedAbilityHover(String string, Widget widget) {
            this.parent = widget;
            this.abilityNameLabel = new Label(string);
            this.abilityNameLabel.setTheme("abilitynamelabel");
            this.add((Widget)this.abilityNameLabel);
        }

        protected void layout() {
            super.layout();
            this.abilityNameLabel.setSize(this.abilityNameLabel.getPreferredWidth(), this.abilityNameLabel.getPreferredHeight());
            int n = Math.max(this.abilityNameLabel.getHeight(), this.parent.getHeight());
            this.setSize(this.abilityNameLabel.getWidth() + this.getBorderHorizontal(), n);
            this.abilityNameLabel.setPosition(this.getInnerX(), this.getY() + (n - this.abilityNameLabel.getHeight()) / 2);
            this.setPosition(this.parent.getRight(), this.parent.getY());
        }
    }

    private class AbilitySelectionViewer
    extends IconButton
    implements IconButton.Callback {
        private SelectedAbilityHover hoverLabel;
        private Ability ability;
        private String emptyLabelText;

        private AbilitySelectionViewer(String string) {
            super(null);
            super.addCallback(this);
            this.emptyLabelText = string;
        }

        private void setAbility(Ability ability) {
            this.ability = ability;
            this.setIcon(ability.getIcon());
        }

        private void clearAbility() {
            this.ability = null;
            this.setIcon(null);
        }

        @Override
        protected boolean handleEvent(Event event) {
            switch (event.getType()) {
                case MOUSE_BTNDOWN: 
                case MOUSE_BTNUP: {
                    return false;
                }
            }
            return super.handleEvent(event);
        }

        @Override
        public void leftClicked() {
        }

        @Override
        public void rightClicked() {
        }

        @Override
        public void startHover() {
            this.hoverLabel = this.ability == null ? new SelectedAbilityHover(this.emptyLabelText, (Widget)this) : new SelectedAbilityHover(this.ability.getName(), (Widget)this);
            this.hoverLabel.setTheme("selectedabilityhover");
            BuilderPaneAbilities.this.add(this.hoverLabel);
        }

        @Override
        public void endHover() {
            BuilderPaneAbilities.this.removeChild(this.hoverLabel);
        }
    }

    private class SelectedAbilitiesContent
    extends DialogLayout {
        private SelectedAbilitiesContent() {
            this.setTheme("content");
            DialogLayout.Group group = this.createParallelGroup();
            DialogLayout.Group group2 = this.createSequentialGroup();
            for (Selection selection : BuilderPaneAbilities.this.selections) {
                AbilitySelectionViewer abilitySelectionViewer = selection.selector;
                if (selection.isMade()) {
                    abilitySelectionViewer.setAbility(selection.selectedAbility);
                }
                group.addWidget((Widget)abilitySelectionViewer);
                group2.addWidget((Widget)abilitySelectionViewer);
            }
            Label label = new Label();
            group.addWidget((Widget)label);
            group2.addWidget((Widget)label);
            this.setHorizontalGroup(group);
            this.setVerticalGroup(group2);
        }
    }
}

