/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import net.sf.hale.characterbuilder.AbstractBuilderPane;
import net.sf.hale.characterbuilder.Buildable;
import net.sf.hale.characterbuilder.CharacterBuilder;

public abstract class BuilderPane
extends AbstractBuilderPane {
    private HTMLTextAreaModel textAreaModel = new HTMLTextAreaModel();
    private ScrollPane textPane;
    private Label titleLabel;
    private ScrollPane selectorPane;
    private DialogLayout selectorPaneContent;
    private DialogLayout.Group selectorPaneContentH;
    private DialogLayout.Group selectorPaneContentV;
    private Label pointsLabel;
    private int titleGap;

    public BuilderPane(CharacterBuilder characterBuilder, String string, Buildable buildable) {
        super(characterBuilder, string, buildable);
        TextArea textArea = new TextArea((TextAreaModel)this.textAreaModel);
        this.textPane = new ScrollPane((Widget)textArea);
        this.textPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.textPane.setCanAcceptKeyboardFocus(false);
        this.textPane.setTheme("descriptionpane");
        this.titleLabel = new Label();
        this.titleLabel.setTheme("titlelabel");
        this.selectorPaneContent = new DialogLayout();
        this.selectorPaneContent.setTheme("content");
        this.selectorPane = new ScrollPane((Widget)this.selectorPaneContent);
        this.selectorPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.selectorPane.setTheme("selectorpane");
        this.selectorPaneContentH = this.selectorPaneContent.createParallelGroup();
        this.selectorPaneContentV = this.selectorPaneContent.createSequentialGroup();
        this.selectorPaneContent.setHorizontalGroup(this.selectorPaneContentH);
        this.selectorPaneContent.setVerticalGroup(this.selectorPaneContentV);
        this.pointsLabel = new Label();
        this.pointsLabel.setTheme("pointslabel");
        this.add((Widget)this.pointsLabel);
        this.add((Widget)this.titleLabel);
        this.add((Widget)this.selectorPane);
        this.add((Widget)this.textPane);
    }

    protected ScrollPane getSelectorPane() {
        return this.selectorPane;
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.titleGap = themeInfo.getParameter("titlegap", 0);
    }

    @Override
    protected void layout() {
        super.layout();
        this.titleLabel.setSize(this.titleLabel.getPreferredWidth(), this.titleLabel.getPreferredHeight());
        this.titleLabel.setPosition(this.getInnerX(), this.getInnerY());
        this.pointsLabel.setSize(this.pointsLabel.getPreferredWidth(), this.pointsLabel.getPreferredHeight());
        this.pointsLabel.setPosition(this.getInnerX(), this.titleLabel.getBottom());
        int n = this.getBackButton().getWidth() + this.getNextButton().getWidth();
        int n2 = this.selectorPane.getPreferredWidth();
        int n3 = Math.min(this.selectorPane.getPreferredHeight(), this.getNextButton().getY() - this.pointsLabel.getBottom() - this.titleGap);
        int n4 = this.getInnerX() + Math.max(n, n2);
        this.selectorPane.setPosition(this.getInnerX(), this.pointsLabel.getBottom() + this.titleGap);
        this.selectorPane.setSize(n4 - this.getInnerX(), n3);
        this.selectorPane.updateScrollbarSizes();
        if (this.selectorPane.getHorizontalScrollbar().isVisible()) {
            this.selectorPane.setSize(this.selectorPane.getPreferredWidth(), n3);
            n4 = this.selectorPane.getRight();
            this.selectorPane.getHorizontalScrollbar().setVisible(false);
        }
        this.textPane.setPosition(n4, this.getInnerY());
        this.textPane.setSize(this.getInnerRight() - n4, this.getInnerHeight());
    }

    public void setPointsText(String string) {
        this.pointsLabel.setText(string);
    }

    public void setTitleText(String string) {
        this.titleLabel.setText(string);
    }

    public void addSelector(Widget widget) {
        this.selectorPaneContentH.addWidget(widget);
        this.selectorPaneContentV.addWidget(widget);
    }

    public void clearSelectors() {
        this.selectorPaneContentH.clear(true);
        this.selectorPaneContentV.clear(true);
    }

    public ScrollPane getTextPane() {
        return this.textPane;
    }

    public HTMLTextAreaModel getTextModel() {
        return this.textAreaModel;
    }
}

