/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.Widget;
import net.sf.hale.characterbuilder.PointAllocatorModel;
import net.sf.hale.icon.Icon;
import net.sf.hale.widgets.IconViewer;

public class BuildablePropertySelector
extends DialogLayout
implements PointAllocatorModel.Listener {
    private PointAllocatorModel pointsModel;
    private int minValue;
    private int maxValue;
    private int value;
    private boolean hasValue;
    private boolean selected;
    private boolean selectable;
    private IconViewer iconViewer;
    private Label valueLabel;
    private Label nameLabel;
    private Button decrement;
    private Button increment;

    public BuildablePropertySelector(String string, Icon icon, boolean bl) {
        this.hasValue = bl;
        this.selected = false;
        this.selectable = false;
        this.iconViewer = new IconViewer();
        if (icon != null) {
            this.iconViewer.setIcon(icon);
        }
        this.nameLabel = new Label(string);
        this.nameLabel.setTheme("namelabel");
        DialogLayout.Group group = this.createSequentialGroup(new Widget[]{this.iconViewer, this.nameLabel});
        DialogLayout.Group group2 = this.createParallelGroup(new Widget[]{this.iconViewer, this.nameLabel});
        group.addGap("namevalue");
        if (bl) {
            this.decrement = new Button();
            this.decrement.addCallback(new Runnable(){

                @Override
                public void run() {
                    BuildablePropertySelector.this.addModelPoints(-1);
                    BuildablePropertySelector.this.addValue(-1);
                }
            });
            this.decrement.setTheme("decrementbutton");
            this.increment = new Button();
            this.increment.addCallback(new Runnable(){

                @Override
                public void run() {
                    BuildablePropertySelector.this.addModelPoints(1);
                    BuildablePropertySelector.this.addValue(1);
                }
            });
            this.increment.setTheme("incrementbutton");
            this.valueLabel = new Label();
            this.valueLabel.setTheme("valuelabel");
            group.addWidget((Widget)this.valueLabel);
            group2.addWidget((Widget)this.valueLabel);
            DialogLayout.Group group3 = this.createParallelGroup(new Widget[]{this.increment, this.decrement});
            DialogLayout.Group group4 = this.createSequentialGroup(new Widget[]{this.increment});
            group4.addGap("decrementincrement");
            group4.addWidget((Widget)this.decrement);
            group.addGroup(group3);
            group2.addGroup(group4);
            this.setIncrementDecrementEnabled();
        }
        this.setHorizontalGroup(group);
        this.setVerticalGroup(group2);
    }

    public void setName(String string) {
        this.nameLabel.setText(string);
    }

    public void setIcon(Icon icon) {
        this.iconViewer.setIcon(icon);
    }

    protected void addModelPoints(int n) {
        if (this.pointsModel != null) {
            this.pointsModel.allocatePoints(n);
        }
    }

    @Override
    public void allocatorModelUpdated() {
        this.setIncrementDecrementEnabled();
    }

    public void setPointAllocatorModel(PointAllocatorModel pointAllocatorModel) {
        this.pointsModel = pointAllocatorModel;
        pointAllocatorModel.addListener(this);
    }

    public int getValue() {
        return this.value;
    }

    protected void addValue(int n) {
        this.setValue(this.value + n);
    }

    protected void setValue(int n) {
        if (!this.hasValue) {
            throw new UnsupportedOperationException("This selector does not have value.");
        }
        this.value = n;
        this.valueLabel.setText(Integer.toString(n));
        this.setIncrementDecrementEnabled();
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    protected void setMinMaxValue(int n, int n2) {
        if (!this.hasValue) {
            throw new UnsupportedOperationException("This selector does not have value.");
        }
        this.minValue = n;
        this.maxValue = n2;
        this.setIncrementDecrementEnabled();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.nameLabel.setEnabled(bl);
        if (this.hasValue) {
            this.valueLabel.setEnabled(bl);
            this.setIncrementDecrementEnabled();
        }
    }

    protected de.matthiasmann.twl.Button getIncrementButton() {
        return this.increment;
    }

    protected de.matthiasmann.twl.Button getDecrementButton() {
        return this.decrement;
    }

    protected void setIncrementDecrementEnabled() {
        boolean bl = this.pointsModel != null ? this.pointsModel.getRemainingPoints() > 0.0 : true;
        this.increment.setEnabled(this.isEnabled() && this.value < this.maxValue && bl);
        this.decrement.setEnabled(this.isEnabled() && this.value > this.minValue);
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean bl) {
        this.selectable = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.getAnimationState().setAnimationState(Button.STATE_SELECTED, bl);
    }

    protected boolean handleEvent(Event event) {
        AnimationState animationState = this.getAnimationState();
        if (event.isMouseEvent()) {
            boolean bl;
            boolean bl2 = bl = event.getType() != Event.Type.MOUSE_EXITED && this.isMouseInside(event);
            if (animationState.getAnimationState(Button.STATE_HOVER) != bl) {
                if (bl) {
                    this.onMouseHover();
                }
                animationState.setAnimationState(Button.STATE_HOVER, bl);
            }
        }
        switch (event.getType()) {
            case MOUSE_BTNDOWN: {
                if (!this.isEnabled() || !this.isSelectable()) break;
                animationState.setAnimationState(Button.STATE_PRESSED, true);
                break;
            }
            case MOUSE_BTNUP: {
                animationState.setAnimationState(Button.STATE_PRESSED, false);
                if (!this.isEnabled() || !this.isSelectable() || !this.isMouseInside(event)) break;
                this.setSelected(!this.selected);
                this.onMouseClick();
                break;
            }
            case MOUSE_WHEEL: {
                return false;
            }
        }
        return event.isMouseEvent();
    }

    protected void onMouseHover() {
    }

    protected void onMouseClick() {
    }

    private class Label
    extends de.matthiasmann.twl.Label {
        private Label() {
        }

        private Label(String string) {
            super(string);
        }

        protected boolean handleEvent(Event event) {
            BuildablePropertySelector.this.handleEvent(event);
            return super.handleEvent(event);
        }
    }

    private class Button
    extends de.matthiasmann.twl.Button {
        private Button() {
        }

        protected boolean handleEvent(Event event) {
            BuildablePropertySelector.this.handleEvent(event);
            return super.handleEvent(event);
        }
    }
}

