/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import de.matthiasmann.twl.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ability.Ability;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.PCTemplate;
import net.sf.hale.icon.ComposedCreatureIcon;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.SubIcon;
import net.sf.hale.rules.Race;
import net.sf.hale.rules.Role;
import net.sf.hale.rules.Ruleset;
import net.sf.hale.rules.Skill;
import net.sf.hale.rules.SkillSet;

public class Buildable {
    private PC creature;
    private Race selectedRace;
    private Role selectedRole;
    private int[] selectedAttributes;
    private SkillSet selectedSkills;
    private int selectedUnspentSkillPoints;
    private List<Ability> selectedAbilities;
    private String selectedName;
    private Ruleset.Gender selectedGender;
    private String selectedHairIcon;
    private Color selectedHairColor;
    private String selectedPortrait;
    private String selectedBeardIcon;
    private Color selectedBeardColor;
    private Color selectedSkinColor;
    private Color selectedClothingColor;
    private List<Race> selectableRaces;
    private final boolean newCharacter;

    public Buildable() {
        PCTemplate pCTemplate = new PCTemplate("temp", "temp", null, Ruleset.Gender.Male, null, null);
        this.creature = new PC(pCTemplate);
        this.selectableRaces = new ArrayList<Race>();
        for (Race race : Game.ruleset.getAllRaces()) {
            if (!race.isPlayerSelectable()) continue;
            this.selectableRaces.add(race);
        }
        this.selectedAbilities = new ArrayList<Ability>();
        this.newCharacter = true;
    }

    public Buildable(PC pC) {
        this.creature = pC;
        this.newCharacter = false;
        this.selectableRaces = new ArrayList<Race>();
        this.selectableRaces.add(pC.getTemplate().getRace());
        this.selectedAbilities = new ArrayList<Ability>();
    }

    public boolean isNewCharacter() {
        return this.newCharacter;
    }

    public Race getSelectedRace() {
        return this.selectedRace;
    }

    public void setSelectedRace(Race race) {
        if (race != this.selectedRace) {
            this.selectedRole = null;
            this.selectedAttributes = null;
            this.selectedSkills = null;
            this.selectedUnspentSkillPoints = 0;
            this.selectedAbilities.clear();
            this.selectedName = null;
            this.selectedGender = null;
            this.selectedHairIcon = null;
            this.selectedHairColor = null;
            this.selectedPortrait = null;
            this.selectedBeardIcon = null;
            this.selectedBeardColor = null;
            this.selectedSkinColor = null;
            this.selectedClothingColor = null;
        }
        this.selectedRace = race;
    }

    public void setSelectedSkills(SkillSet skillSet, int n) {
        if (this.selectedUnspentSkillPoints != n || !skillSet.equals(this.selectedSkills)) {
            this.selectedAbilities.clear();
            this.selectedName = null;
            this.selectedGender = null;
            this.selectedHairIcon = null;
            this.selectedHairColor = null;
            this.selectedPortrait = null;
            this.selectedBeardIcon = null;
            this.selectedBeardColor = null;
            this.selectedSkinColor = null;
            this.selectedClothingColor = null;
        }
        this.selectedSkills = skillSet;
        this.selectedUnspentSkillPoints = n;
    }

    public SkillSet getSelectedSkills() {
        return this.selectedSkills;
    }

    public int getSelectedUnspentSkillPoints() {
        return this.selectedUnspentSkillPoints;
    }

    public void setSelectedAttributes(int[] nArray) {
        if (nArray == null || nArray.length != 6) {
            throw new IllegalArgumentException("Attributes must be an array of length 6.");
        }
        boolean bl = false;
        if (this.selectedAttributes == null) {
            bl = true;
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == this.selectedAttributes[i]) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.selectedSkills = null;
            this.selectedUnspentSkillPoints = 0;
            this.selectedAbilities.clear();
            this.selectedName = null;
            this.selectedGender = null;
            this.selectedHairIcon = null;
            this.selectedHairColor = null;
            this.selectedPortrait = null;
            this.selectedBeardIcon = null;
            this.selectedBeardColor = null;
            this.selectedSkinColor = null;
            this.selectedClothingColor = null;
        }
        this.selectedAttributes = nArray;
    }

    public int[] getSelectedAttributes() {
        return this.selectedAttributes;
    }

    public Role getSelectedRole() {
        return this.selectedRole;
    }

    public void setSelectedRole(Role role) {
        if (role != this.selectedRole) {
            this.selectedAttributes = null;
            this.selectedSkills = null;
            this.selectedUnspentSkillPoints = 0;
            this.selectedAbilities.clear();
            this.selectedName = null;
            this.selectedGender = null;
            this.selectedHairIcon = null;
            this.selectedHairColor = null;
            this.selectedPortrait = null;
            this.selectedBeardIcon = null;
            this.selectedBeardColor = null;
            this.selectedSkinColor = null;
            this.selectedClothingColor = null;
        }
        this.selectedRole = role;
    }

    public void addSelectedAbility(Ability ability) {
        this.selectedAbilities.add(ability);
    }

    public void clearSelectedAbilities() {
        this.selectedAbilities.clear();
        this.selectedName = null;
        this.selectedGender = null;
        this.selectedHairIcon = null;
        this.selectedHairColor = null;
        this.selectedPortrait = null;
        this.selectedBeardIcon = null;
        this.selectedBeardColor = null;
        this.selectedSkinColor = null;
        this.selectedClothingColor = null;
    }

    public List<Ability> getSelectedAbilities() {
        return this.selectedAbilities;
    }

    public void setSelectedName(String string) {
        this.selectedName = string;
    }

    public String getSelectedName() {
        return this.selectedName;
    }

    public void setSelectedGender(Ruleset.Gender gender) {
        this.selectedGender = gender;
    }

    public Ruleset.Gender getSelectedGender() {
        return this.selectedGender;
    }

    public void setSelectedHairIcon(String string) {
        this.selectedHairIcon = string;
    }

    public String getSelectedHairIcon() {
        return this.selectedHairIcon;
    }

    public void setSelectedHairColor(Color color) {
        this.selectedHairColor = color;
    }

    public Color getSelectedHairColor() {
        return this.selectedHairColor;
    }

    public void setSelectedBeardIcon(String string) {
        this.selectedBeardIcon = string;
    }

    public String getSelectedBeardIcon() {
        return this.selectedBeardIcon;
    }

    public void setSelectedBeardColor(Color color) {
        this.selectedBeardColor = color;
    }

    public Color getSelectedBeardColor() {
        return this.selectedBeardColor;
    }

    public void setSelectedSkinColor(Color color) {
        this.selectedSkinColor = color;
    }

    public Color getSelectedSkinColor() {
        return this.selectedSkinColor;
    }

    public void setSelectedClothingColor(Color color) {
        this.selectedClothingColor = color;
    }

    public Color getSelectedClothingColor() {
        return this.selectedClothingColor;
    }

    public void setSelectedPortrait(String string) {
        this.selectedPortrait = string;
    }

    public String getSelectedPortrait() {
        return this.selectedPortrait;
    }

    protected void applySelectionsToCreature() {
        int n;
        if (this.selectedRole != null) {
            this.creature.roles.addLevels(this.selectedRole, 1);
            n = this.creature.roles.getLevel(this.selectedRole);
            for (Ability ability : this.selectedRole.getAbilitiesAddedAtLevel(n)) {
                if (this.creature.quickbar == null || !ability.isActivateable()) continue;
                this.creature.quickbar.addToFirstEmptySlot(ability);
            }
        }
        if (this.selectedSkills != null) {
            this.creature.skills.addRanksFromList(this.selectedSkills);
            this.creature.setUnspentSkillPoints(this.selectedUnspentSkillPoints);
        }
        n = this.getCreatureLevel();
        for (Ability ability : this.selectedAbilities) {
            this.creature.abilities.add(ability, n - 1);
            if (this.creature.quickbar == null || !ability.isActivateable()) continue;
            this.creature.quickbar.addToFirstEmptySlot(ability);
        }
    }

    public PC getWorkingCopy() {
        PCTemplate pCTemplate;
        Object object;
        Object object2;
        if (this.newCharacter) {
            object2 = new ArrayList();
            if (this.selectedHairIcon != null) {
                object = new SubIcon.Factory(SubIcon.Type.Hair, this.selectedRace, this.selectedGender);
                ((SubIcon.Factory)object).setPrimaryIcon(this.selectedHairIcon, this.selectedHairColor);
                object2.add(((SubIcon.Factory)object).createSubIcon());
            }
            if (this.selectedBeardIcon != null) {
                object = new SubIcon.Factory(SubIcon.Type.Beard, this.selectedRace, this.selectedGender);
                ((SubIcon.Factory)object).setPrimaryIcon(this.selectedBeardIcon, this.selectedBeardColor);
                object2.add(((SubIcon.Factory)object).createSubIcon());
            }
            object = new ComposedCreatureIcon(this.selectedSkinColor, this.selectedClothingColor, (List<SubIcon>)object2);
            pCTemplate = new PCTemplate(this.selectedName, this.selectedName, (Icon)object, this.selectedGender, this.selectedRace, this.selectedPortrait);
        } else {
            pCTemplate = this.creature.getTemplate();
        }
        object2 = new PC(pCTemplate);
        ((PC)object2).timer.reset();
        if (this.newCharacter) {
            if (this.selectedGender != null) {
                object = EntityManager.getItem(Game.ruleset.getString("DefaultClothes"));
                ((PC)object2).inventory.addAndEquip((EquippableItem)object);
            }
            if (this.selectedAttributes != null) {
                ((PC)object2).stats.setAttributes(this.selectedAttributes);
            }
        } else {
            ((PC)object2).roles.addLevels(this.creature.roles);
            ((PC)object2).skills.addRanksFromList(this.creature.skills);
            ((PC)object2).stats.setAttributes(this.creature.stats.getAttributes());
            ((PC)object2).abilities.addAll(this.creature.abilities);
        }
        if (this.selectedRole != null) {
            ((PC)object2).roles.addLevels(this.selectedRole, 1);
        }
        if (this.selectedSkills != null) {
            ((PC)object2).skills.addRanksFromList(this.selectedSkills);
            ((PC)object2).setUnspentSkillPoints(this.selectedUnspentSkillPoints);
        }
        int n = this.getCreatureLevel();
        for (Ability ability : this.selectedAbilities) {
            ((PC)object2).abilities.add(ability, n);
        }
        if (this.newCharacter && this.selectedRace != null) {
            ((Creature)object2).resetTime();
        }
        return object2;
    }

    public List<Skill> getSelectableSkills() {
        ArrayList<Skill> arrayList = new ArrayList<Skill>();
        for (Skill skill : Game.ruleset.getAllSkills()) {
            if (skill.canUse(this.creature)) {
                arrayList.add(skill);
                continue;
            }
            if (this.selectedRole == null || !skill.canUse(this.selectedRole)) continue;
            arrayList.add(skill);
        }
        Collections.sort(arrayList, new Comparator<Skill>(){

            @Override
            public int compare(Skill skill, Skill skill2) {
                if (skill.isRestrictedToARole() && !skill2.isRestrictedToARole()) {
                    return -1;
                }
                if (skill2.isRestrictedToARole() && !skill.isRestrictedToARole()) {
                    return 1;
                }
                return skill.getNoun().compareTo(skill2.getNoun());
            }
        });
        return arrayList;
    }

    public List<Role> getSelectableRoles() {
        ArrayList<Role> arrayList = new ArrayList<Role>();
        for (Role role : Game.ruleset.getAllRoles()) {
            if (!role.isPlayer() || !role.creatureCanSelect(this.creature)) continue;
            arrayList.add(role);
        }
        return arrayList;
    }

    public List<Role> getFutureOrPastSelectableRoles() {
        ArrayList<Role> arrayList = new ArrayList<Role>();
        for (Role role : Game.ruleset.getAllRoles()) {
            if (!role.isPlayer() || role.creatureCanSelect(this.creature) || !role.creatureHasRolePrereqs(this.creature)) continue;
            arrayList.add(role);
        }
        return arrayList;
    }

    public List<Race> getSelectableRaces() {
        return this.selectableRaces;
    }

    public int getLevel(Role role) {
        return this.creature.roles.getLevel(role);
    }

    public int getCreatureLevel() {
        return this.creature.stats.getCreatureLevel() + 1;
    }

    public int getUnspentSkillPoints() {
        return this.creature.getUnspentSkillPoints();
    }

    public SkillSet getSkillSet() {
        return this.creature.skills;
    }

    public int getCurrentIntelligence() {
        if (this.newCharacter) {
            return this.selectedAttributes[3];
        }
        return this.creature.stats.getBaseInt();
    }

    public String getName() {
        if (this.newCharacter) {
            return this.selectedName;
        }
        return this.creature.getTemplate().getName();
    }

    public Role getBaseRole() {
        if (this.newCharacter) {
            return this.selectedRole;
        }
        return this.creature.roles.getBaseRole();
    }
}

