/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Widget;
import net.sf.hale.characterbuilder.Buildable;
import net.sf.hale.characterbuilder.CharacterBuilder;

public abstract class AbstractBuilderPane
extends Widget {
    private CharacterBuilder builder;
    private String name;
    private Buildable character;
    private Button next;
    private Button back;

    public AbstractBuilderPane(CharacterBuilder characterBuilder, String string, Buildable buildable) {
        this.builder = characterBuilder;
        this.name = string;
        this.character = buildable;
        this.next = new Button("Next >>");
        this.next.addCallback(new Runnable(){

            @Override
            public void run() {
                AbstractBuilderPane.this.next();
            }
        });
        this.next.setTheme("nextbutton");
        this.back = new Button("<< Back");
        this.back.addCallback(new Runnable(){

            @Override
            public void run() {
                AbstractBuilderPane.this.back();
            }
        });
        this.back.setTheme("backbutton");
        this.add((Widget)this.back);
        this.add((Widget)this.next);
    }

    protected void layout() {
        this.back.setSize(this.back.getPreferredWidth(), this.back.getPreferredHeight());
        this.next.setSize(this.next.getPreferredWidth(), this.next.getPreferredHeight());
        this.back.setPosition(this.getInnerX(), this.getInnerBottom() - this.back.getHeight());
        this.next.setPosition(this.back.getRight(), this.getInnerBottom() - this.next.getHeight());
    }

    protected Button getBackButton() {
        return this.back;
    }

    protected Button getNextButton() {
        return this.next;
    }

    protected CharacterBuilder getCharacterBuilder() {
        return this.builder;
    }

    public Buildable getCharacter() {
        return this.character;
    }

    public String getName() {
        return this.name;
    }

    protected abstract void updateCharacter();

    protected void next() {
        AbstractBuilderPane abstractBuilderPane = this.getCharacterBuilder().getNextPane(this);
        if (abstractBuilderPane != null) {
            this.getCharacterBuilder().setActivePane(abstractBuilderPane);
        }
    }

    protected void back() {
        AbstractBuilderPane abstractBuilderPane = this.getCharacterBuilder().getPreviousPane(this);
        if (abstractBuilderPane != null) {
            this.getCharacterBuilder().setActivePane(abstractBuilderPane);
        }
    }

    public int getPreferredInnerWidth() {
        return Short.MAX_VALUE;
    }

    public int getPreferredInnerHeight() {
        return Short.MAX_VALUE;
    }

    public int getMinHeight() {
        return 300;
    }
}

