/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.utils.TintAnimator;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.ability.Ability;
import net.sf.hale.entity.Container;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.PC;
import net.sf.hale.icon.Icon;
import net.sf.hale.rules.Merchant;
import net.sf.hale.view.AbilityDetailsWindow;
import net.sf.hale.view.DragAndDropHandler;
import net.sf.hale.view.DragTarget;

public class AbilitySelectorButton
extends Button
implements Runnable,
DragTarget {
    private static AnimationState.StateKey STATE_ALREADY_OWNED = AnimationState.StateKey.get((String)"alreadyOwned");
    private static AnimationState.StateKey STATE_PREREQS_NOT_MET = AnimationState.StateKey.get((String)"prereqsNotMet");
    private List<Callback> callbacks;
    private Widget widgetToAddWindowsTo;
    private HoverHolder widgetToAddHoverTo;
    private final boolean showSelectable;
    private Ability ability;
    private DragAndDropHandler dragAndDropHandler;
    private PC parent;
    private AbilityHover abilityHover;
    private AbilityHoverDetails abilityHoverDetails;
    private boolean isHovering;
    private String hoverText;
    private Color hoverTextColor;
    private Icon icon;

    public AbilitySelectorButton(Ability ability, PC pC, HoverHolder hoverHolder, boolean bl) {
        this.ability = ability;
        this.parent = pC;
        this.icon = ability.getIcon();
        this.showSelectable = bl;
        this.widgetToAddHoverTo = hoverHolder;
        this.addCallback(this);
        this.setSize(ability.getIcon().getWidth(), ability.getIcon().getHeight());
        this.callbacks = new ArrayList<Callback>();
    }

    public void setState(PC pC) {
        this.parent = pC;
        if (pC.abilities.has(this.ability)) {
            this.getAnimationState().setAnimationState(STATE_ALREADY_OWNED, true);
            this.icon = this.ability.getIcon();
        } else if (this.ability.meetsPrereqs(pC) && this.showSelectable) {
            this.icon = this.ability.getIcon();
        } else {
            this.getAnimationState().setAnimationState(STATE_PREREQS_NOT_MET, true);
            this.icon = this.ability.getIcon().multiplyByColor(new Color(-12303292));
        }
    }

    protected void setHoverText(String string, Color color) {
        this.hoverText = string;
        this.hoverTextColor = color;
    }

    protected void setWidgetToAddWindowsTo(Widget widget) {
        this.widgetToAddWindowsTo = widget;
    }

    public void addCallback(Callback callback) {
        this.callbacks.add(callback);
    }

    protected void paintWidget(GUI gUI) {
        this.icon.draw(this.getInnerX(), this.getInnerY());
    }

    @Override
    public void run() {
        if (this.ability.meetsPrereqs(this.parent) && this.showSelectable) {
            for (Callback callback : this.callbacks) {
                callback.selectionMade(this.ability);
            }
        }
    }

    private void handleHover(Event event) {
        if (event.isMouseEvent()) {
            boolean bl;
            boolean bl2 = bl = event.getType() != Event.Type.MOUSE_EXITED && (this.isMouseInside(event) || this.abilityHoverDetails.isInside(event.getMouseX(), event.getMouseY()));
            if (bl && !this.isHovering) {
                this.startHover();
            } else if (!bl && this.isHovering) {
                this.endHover();
            }
        }
    }

    protected boolean handleEvent(Event event) {
        this.handleHover(event);
        switch (event.getType()) {
            case MOUSE_ENTERED: 
            case MOUSE_MOVED: {
                return true;
            }
            case MOUSE_DRAGGED: {
                if (this.showSelectable || this.dragAndDropHandler != null || !this.ability.isActivateable() || !this.parent.abilities.has(this.ability)) break;
                this.dragAndDropHandler = new DragAndDropHandler(this);
                break;
            }
        }
        if (this.dragAndDropHandler != null && !this.dragAndDropHandler.handleEvent(event)) {
            this.dragAndDropHandler = null;
        }
        return super.handleEvent(event);
    }

    private void startHover() {
        this.abilityHover = new AbilityHover();
        this.abilityHoverDetails = new AbilityHoverDetails();
        this.widgetToAddHoverTo.setHoverWidgets(this.abilityHover, (Widget)this.abilityHoverDetails);
        this.isHovering = true;
    }

    private void endHover() {
        if (this.abilityHover != null) {
            this.widgetToAddHoverTo.removeHoverWidgets(this.abilityHover, (Widget)this.abilityHoverDetails);
        }
        this.isHovering = false;
    }

    @Override
    public Icon getDragIcon() {
        return this.ability.getIcon();
    }

    @Override
    public PC getParentPC() {
        return this.parent;
    }

    @Override
    public Ability getAbility() {
        return this.ability;
    }

    @Override
    public Item getItem() {
        return null;
    }

    @Override
    public Container getItemContainer() {
        return null;
    }

    @Override
    public Merchant getItemMerchant() {
        return null;
    }

    @Override
    public Inventory.Slot getItemEquipSlot() {
        return null;
    }

    private class AbilityHoverDetails
    extends Button
    implements Runnable {
        private AbilityHoverDetails() {
            super("View Details");
            this.addCallback(this);
        }

        protected boolean handleEvent(Event event) {
            AbilitySelectorButton.this.handleHover(event);
            return super.handleEvent(event);
        }

        protected void layout() {
            super.layout();
            this.setSize(this.getPreferredWidth(), this.getPreferredHeight());
            AbilitySelectorButton abilitySelectorButton = AbilitySelectorButton.this;
            int n = abilitySelectorButton.getX() + abilitySelectorButton.getWidth() / 2 - this.getWidth() / 2;
            this.setPosition(n, abilitySelectorButton.getInnerBottom());
        }

        @Override
        public void run() {
            AbilityDetailsWindow abilityDetailsWindow = new AbilityDetailsWindow(AbilitySelectorButton.this.ability, AbilitySelectorButton.this.parent);
            int n = this.getX() + this.getWidth() / 2 - abilityDetailsWindow.getWidth() / 2;
            int n2 = this.getY() + this.getHeight() / 2 - abilityDetailsWindow.getHeight() / 2;
            abilityDetailsWindow.setPosition(n, n2);
            AbilitySelectorButton.this.widgetToAddWindowsTo.add((Widget)abilityDetailsWindow);
            AbilitySelectorButton.this.endHover();
        }
    }

    private class HoverLabel
    extends Label {
        private HoverLabel(String string) {
            super(string);
        }

        protected boolean handleEvent(Event event) {
            AbilitySelectorButton.this.handleHover(event);
            return false;
        }
    }

    public static interface HoverHolder {
        public void setHoverWidgets(Widget var1, Widget var2);

        public void removeHoverWidgets(Widget var1, Widget var2);

        public GUI getGUI();
    }

    private class AbilityHover
    extends Widget {
        private Label abilityNameLabel;
        private Label hoverMessageLabel;

        private AbilityHover() {
            this.abilityNameLabel = new HoverLabel(AbilitySelectorButton.this.ability.getName());
            this.abilityNameLabel.setTheme("abilitynamelabel");
            this.add((Widget)this.abilityNameLabel);
            this.hoverMessageLabel = new HoverLabel(AbilitySelectorButton.this.hoverText);
            this.hoverMessageLabel.setTheme("hovermessagelabel");
            this.add((Widget)this.hoverMessageLabel);
            this.hoverMessageLabel.setTintAnimator(new TintAnimator((TintAnimator.TimeSource)new TintAnimator.GUITimeSource((Widget)this), AbilitySelectorButton.this.hoverTextColor));
        }

        protected boolean handleEvent(Event event) {
            AbilitySelectorButton.this.handleHover(event);
            return false;
        }

        protected void layout() {
            super.layout();
            this.abilityNameLabel.setSize(this.abilityNameLabel.getPreferredWidth(), this.abilityNameLabel.getPreferredHeight());
            this.hoverMessageLabel.setSize(this.hoverMessageLabel.getPreferredWidth(), this.hoverMessageLabel.getPreferredHeight());
            int n = Math.max(this.abilityNameLabel.getWidth(), this.hoverMessageLabel.getWidth());
            int n2 = this.abilityNameLabel.getHeight() + this.hoverMessageLabel.getHeight();
            this.setSize(n + this.getBorderHorizontal(), n2 + this.getBorderVertical());
            this.abilityNameLabel.setPosition(this.getInnerX() + (this.getInnerWidth() - this.abilityNameLabel.getWidth()) / 2, this.getInnerY());
            this.hoverMessageLabel.setPosition(this.getInnerX() + (this.getInnerWidth() - this.hoverMessageLabel.getWidth()) / 2, this.getInnerY() + this.abilityNameLabel.getHeight());
            AbilitySelectorButton abilitySelectorButton = AbilitySelectorButton.this;
            int n3 = abilitySelectorButton.getX() + abilitySelectorButton.getWidth() / 2 - this.getWidth() / 2;
            this.setPosition(n3, abilitySelectorButton.getInnerY() - this.getHeight());
        }
    }

    public static interface Callback {
        public void selectionMade(Ability var1);
    }
}

