/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.characterbuilder;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.hale.Game;
import net.sf.hale.ability.Ability;
import net.sf.hale.ability.AbilitySelectionList;
import net.sf.hale.characterbuilder.AbilitySelectorButton;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.PC;
import net.sf.hale.util.Pointf;

public class AbilitySelectionListPane
extends Widget {
    private final boolean showSelectable;
    private AbilitySelectionList list;
    private int gridSize;
    private List<AbilitySelectorButton> buttons;
    private List<AbilitySelectionListPane> subListPanes;
    private List<Label> subListLabels;
    private List<ConnectorViewer> connectorViewers;
    private Creature parentPC;

    public AbilitySelectionListPane(AbilitySelectionList abilitySelectionList, PC pC, AbilitySelectorButton.HoverHolder hoverHolder, boolean bl) {
        Object object;
        this.parentPC = pC;
        this.list = abilitySelectionList;
        this.showSelectable = bl;
        Set<Ability> set = abilitySelectionList.getAbilities();
        Set<String> set2 = abilitySelectionList.getSubListIDs();
        List<AbilitySelectionList.Connector> list = abilitySelectionList.getConnectors();
        this.buttons = new ArrayList<AbilitySelectorButton>(set.size());
        this.subListPanes = new ArrayList<AbilitySelectionListPane>(set2.size());
        this.subListLabels = new ArrayList<Label>(set2.size());
        this.connectorViewers = new ArrayList<ConnectorViewer>(list.size());
        for (AbilitySelectionList.Connector object2 : abilitySelectionList.getConnectors()) {
            object = new ConnectorViewer(object2);
            this.connectorViewers.add((ConnectorViewer)((Object)object));
            this.add((Widget)object);
        }
        for (Ability ability : abilitySelectionList.getAbilities()) {
            object = new AbilitySelectorButton(ability, pC, hoverHolder, bl);
            ((AbilitySelectorButton)object).setWidgetToAddWindowsTo(hoverHolder.getGUI().getRootPane());
            ((AbilitySelectorButton)object).setState(pC);
            this.add((Widget)object);
            this.buttons.add((AbilitySelectorButton)object);
        }
        for (String string : set2) {
            object = Game.ruleset.getAbilitySelectionList(string);
            AbilitySelectionListPane abilitySelectionListPane = new AbilitySelectionListPane((AbilitySelectionList)object, pC, hoverHolder, bl);
            this.add(abilitySelectionListPane);
            this.subListPanes.add(abilitySelectionListPane);
            Label label = new Label(((AbilitySelectionList)object).getName());
            label.setTheme("title");
            this.add((Widget)label);
            this.subListLabels.add(label);
        }
    }

    public void addAbilitySelectorCallback(AbilitySelectorButton.Callback callback) {
        for (AbilitySelectorButton object : this.buttons) {
            object.addCallback(callback);
        }
        for (AbilitySelectionListPane abilitySelectionListPane : this.subListPanes) {
            abilitySelectionListPane.addAbilitySelectorCallback(callback);
        }
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.gridSize = themeInfo.getParameter("gridSize", 0);
        String string = themeInfo.getParameter("alreadyOwnedText", "");
        String string2 = themeInfo.getParameter("prereqsNotMetText", "");
        String string3 = themeInfo.getParameter("selectableText", "");
        String string4 = themeInfo.getParameter("notOwnedText", "");
        for (AbilitySelectorButton abilitySelectorButton : this.buttons) {
            if (this.parentPC.abilities.has(abilitySelectorButton.getAbility())) {
                abilitySelectorButton.setHoverText(string, Color.PURPLE);
                continue;
            }
            if (this.showSelectable) {
                if (!abilitySelectorButton.getAbility().meetsPrereqs(this.parentPC)) {
                    abilitySelectorButton.setHoverText(string2, Color.RED);
                    continue;
                }
                abilitySelectorButton.setHoverText(string3, Color.GREEN);
                continue;
            }
            abilitySelectorButton.setHoverText(string4, Color.RED);
        }
    }

    protected void layout() {
        int n;
        int n2;
        Object object;
        super.layout();
        int n3 = this.getX();
        int n4 = this.getY();
        for (Object object2 : this.buttons) {
            object = this.list.getGridPosition(object2.getAbility());
            object2.setPosition(this.getInnerX() + (int)((float)this.gridSize * ((Pointf)object).x), this.getInnerY() + (int)((float)this.gridSize * ((Pointf)object).y));
            if (object2.getRight() > n3) {
                n3 = object2.getRight();
            }
            if (object2.getBottom() <= n4) continue;
            n4 = object2.getBottom();
        }
        for (n2 = 0; n2 < this.subListPanes.size(); ++n2) {
            Object object2;
            object2 = this.subListPanes.get(n2);
            object = this.subListLabels.get(n2);
            Pointf object3 = this.list.getGridPosition(((AbilitySelectionListPane)((Object)object2)).list);
            object2.setPosition(this.getInnerX() + (int)((float)this.gridSize * object3.x), this.getInnerY() + (int)((float)this.gridSize * object3.y));
            object.setSize(object.getPreferredWidth(), object.getPreferredHeight());
            object.setPosition(object2.getX(), object2.getY() - object.getHeight());
            int n5 = Math.max(object.getRight(), object2.getRight());
            if (n5 > n3) {
                n3 = n5;
            }
            if (object2.getBottom() <= n4) continue;
            n4 = object2.getBottom();
        }
        this.setSize(n3 + this.getBorderRight() - this.getX(), n4 + this.getBorderBottom() - this.getY());
        if (this.buttons.size() > 0) {
            n2 = this.buttons.get(0).getWidth();
            n = this.buttons.get(0).getHeight();
        } else {
            n2 = 0;
            n = 0;
        }
        for (ConnectorViewer connectorViewer : this.connectorViewers) {
            connectorViewer.setSize(connectorViewer.getBackground().getWidth(), connectorViewer.getBackground().getHeight());
            Pointf pointf = connectorViewer.connector.getPoint();
            float f = (float)this.gridSize * pointf.x + (float)(n2 - connectorViewer.getWidth()) / 2.0f;
            float f2 = (float)this.gridSize * pointf.y;
            switch (connectorViewer.connector.getType()) {
                case OneUp: 
                case TwoUp: 
                case ThreeUp: 
                case FourUp: {
                    f2 -= (float)connectorViewer.getHeight();
                    break;
                }
                case OneDown: 
                case TwoDown: 
                case ThreeDown: 
                case FourDown: {
                    f2 += (float)n;
                    break;
                }
            }
            connectorViewer.setPosition(this.getInnerX() + (int)f, this.getInnerY() + (int)f2);
        }
    }

    private class ConnectorViewer
    extends Widget {
        private AbilitySelectionList.Connector connector;

        private ConnectorViewer(AbilitySelectionList.Connector connector) {
            this.connector = connector;
            this.setTheme("connector");
        }

        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            switch (this.connector.getType()) {
                case OneUp: {
                    this.setBackground(themeInfo.getImage("one-up"));
                    break;
                }
                case OneDown: {
                    this.setBackground(themeInfo.getImage("one-down"));
                    break;
                }
                case TwoUp: {
                    this.setBackground(themeInfo.getImage("two-up"));
                    break;
                }
                case TwoDown: {
                    this.setBackground(themeInfo.getImage("two-down"));
                    break;
                }
                case ThreeUp: {
                    this.setBackground(themeInfo.getImage("three-up"));
                    break;
                }
                case ThreeDown: {
                    this.setBackground(themeInfo.getImage("three-down"));
                    break;
                }
                case FourUp: {
                    this.setBackground(themeInfo.getImage("four-up"));
                    break;
                }
                case FourDown: {
                    this.setBackground(themeInfo.getImage("four-down"));
                    break;
                }
                case Through: {
                    this.setBackground(themeInfo.getImage("through"));
                }
            }
        }
    }
}

