/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.bonus;

import net.sf.hale.Game;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.rules.BaseWeapon;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONObject;

public class WeaponProficiency
extends Bonus {
    private final String baseWeapon;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("weaponProficiency", this.baseWeapon);
        return jSONOrderedObject;
    }

    public static WeaponProficiency load(SimpleJSONObject simpleJSONObject) {
        return new WeaponProficiency(simpleJSONObject.get("weaponProficiency", null));
    }

    public WeaponProficiency(String string) {
        super(Bonus.Type.WeaponProficiency, Bonus.StackType.GenericBonus);
        this.baseWeapon = string;
    }

    public String getBaseWeapon() {
        return this.baseWeapon;
    }

    public static BaseWeapon parseBaseWeapon(String string) {
        BaseWeapon baseWeapon = Game.ruleset.getBaseWeapon(string);
        if (baseWeapon == null) {
            Logger.appendToErrorLog("Base Weapon type " + string + " not found.");
        }
        return baseWeapon;
    }

    @Override
    public WeaponProficiency cloneWithReduction(int n) {
        return new WeaponProficiency(this.baseWeapon);
    }

    @Override
    public void appendDescription(StringBuilder stringBuilder) {
        stringBuilder.append("<span style=\"font-family: blue;\">");
        stringBuilder.append(this.baseWeapon);
        stringBuilder.append("</span> ");
        super.appendDescription(stringBuilder);
    }
}

