/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.bonus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.ability.Effect;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.BonusList;
import net.sf.hale.bonus.BonusManager;
import net.sf.hale.bonus.Stat;
import net.sf.hale.entity.Armor;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.EquippableItemTemplate;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.Weapon;
import net.sf.hale.rules.Damage;
import net.sf.hale.rules.DamageType;
import net.sf.hale.rules.Role;

public class StatManager {
    private final Creature parent;
    private final Map<Stat, Integer> stats;
    private final BonusManager bonuses;

    public StatManager(Creature creature) {
        this.parent = creature;
        this.bonuses = new BonusManager();
        this.stats = new HashMap<Stat, Integer>();
    }

    public StatManager(StatManager statManager, Creature creature) {
        this.parent = creature;
        this.bonuses = new BonusManager(statManager.bonuses);
        this.stats = new HashMap<Stat, Integer>(statManager.stats);
    }

    public void removeEffectPenaltiesOfType(String string) {
        Bonus.Type type = Bonus.parseType(string);
        this.removeAll(this.parent.getEffects().getPenaltiesOfType(type));
    }

    public void removeEffectBonusesOfType(String string) {
        Bonus.Type type = Bonus.parseType(string);
        this.removeAll(this.parent.getEffects().getBonusesOfType(type));
    }

    public int reducePenaltiesOfTypeByAmount(String string, int n) {
        if (n == 0) {
            return 0;
        }
        BonusList bonusList = new BonusList();
        BonusList bonusList2 = new BonusList();
        Bonus.Type type = Bonus.parseType(string);
        int n2 = n;
        ArrayList<Bonus> arrayList = new ArrayList<Bonus>();
        for (Effect effect : this.parent.getEffects().getEffectsWithBonusesOfType(type)) {
            arrayList.clear();
            for (Bonus bonus : effect.getBonuses()) {
                if (bonus.getType() == type) {
                    int n3 = -bonus.getValue();
                    if (n3 >= n2) {
                        Bonus bonus2 = bonus.cloneWithReduction(-n2);
                        n2 = 0;
                        effect.getBonuses().add(bonus2);
                        arrayList.add(bonus);
                        bonusList.add(bonus);
                        bonusList2.add(bonus2);
                    } else {
                        bonusList.add(bonus);
                        arrayList.add(bonus);
                        n2 -= n3;
                    }
                }
                if (n2 != 0) continue;
                break;
            }
            for (Bonus bonus : arrayList) {
                effect.getBonuses().remove(bonus);
            }
            if (n2 != 0) continue;
            break;
        }
        this.removeAll(bonusList);
        this.addAll(bonusList2);
        return n2;
    }

    public void changeEquipment(EquippableItemTemplate.Type type) {
        switch (type) {
            case Weapon: 
            case Shield: {
                this.recomputeAttackBonus();
            }
            case Armor: 
            case Gloves: 
            case Helmet: 
            case Boots: {
                this.recomputeArmorClass();
            }
        }
    }

    private void checkRecompute(BonusList bonusList, RecomputeMode recomputeMode, int n) {
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        for (Bonus bonus : bonusList) {
            block0 : switch (bonus.getType()) {
                case Immobilized: 
                case Initiative: 
                case ArmorClass: 
                case ArmorPenalty: 
                case ArmorTypeArmorPenalty: 
                case ArmorTypeMovementPenalty: 
                case ArmorTypeArmorClass: 
                case DualWieldArmorClass: 
                case Movement: 
                case ImmobilizationImmunity: 
                case UndispellableImmobilized: {
                    bl = true;
                    break;
                }
                case Attack: 
                case Damage: 
                case AttackCost: 
                case ShieldAttack: 
                case MainHandAttack: 
                case OffHandAttack: 
                case MainHandDamage: 
                case OffHandDamage: 
                case BaseWeaponAttack: 
                case BaseWeaponDamage: 
                case BaseWeaponSpeed: 
                case BaseWeaponCriticalChance: 
                case BaseWeaponCriticalMultiplier: 
                case LightMeleeWeaponDamage: 
                case OneHandedMeleeWeaponDamage: 
                case TwoHandedMeleeWeaponDamage: 
                case RangedDamage: 
                case RangedAttack: 
                case DualWieldAttack: 
                case DualWieldStrDamage: 
                case LightMeleeWeaponAttack: 
                case OneHandedMeleeWeaponAttack: 
                case TwoHandedMeleeWeaponAttack: {
                    bl2 = true;
                    break;
                }
                case BaseStr: 
                case Str: {
                    bl3 = true;
                    break;
                }
                case BaseDex: 
                case Dex: {
                    bl4 = true;
                    break;
                }
                case BaseCon: 
                case Con: {
                    bl5 = true;
                    break;
                }
                case BaseInt: 
                case Int: {
                    bl6 = true;
                    break;
                }
                case BaseWis: 
                case Wis: {
                    bl7 = true;
                    break;
                }
                case BaseCha: 
                case Cha: {
                    bl8 = true;
                    break;
                }
                case TemporaryHP: {
                    switch (recomputeMode) {
                        case Removal: {
                            this.parent.removeTemporaryHitPoints(bonus.getValue());
                            break block0;
                        }
                        case Addition: {
                            this.parent.addTemporaryHitPoints(bonus.getValue());
                        }
                    }
                }
            }
        }
        if (bl3 && bl4) {
            this.recomputeStrNoAttackBonus();
            this.recomputeDex();
            bl = false;
            bl2 = false;
        } else if (bl3) {
            this.recomputeStr();
            bl2 = false;
        } else if (bl4) {
            this.recomputeDex();
            bl = false;
            bl2 = false;
        }
        if (bl5) {
            this.recomputeCon();
        }
        if (bl6) {
            this.recomputeInt();
        }
        if (bl7) {
            this.recomputeWis();
        }
        if (bl8) {
            this.recomputeCha();
        }
        if (bl) {
            this.recomputeArmorClass();
        }
        if (bl2) {
            this.recomputeAttackBonus();
        }
        if ((n2 = this.get(Bonus.Type.Con)) != n) {
            int n3;
            int n4 = (this.getCon() - n2 + n - 10) * this.get(Stat.CreatureLevel) / 3;
            if (n4 > (n3 = (this.getCon() - 10) * this.get(Stat.CreatureLevel) / 3)) {
                this.parent.takeDamage(n4 - n3, "Effect");
            } else if (n4 < n3) {
                this.parent.healDamage(n3 - n4);
            }
        }
    }

    public void removeAll(BonusList bonusList) {
        int n = this.get(Bonus.Type.Con);
        this.bonuses.removeAll(bonusList);
        this.checkRecompute(bonusList, RecomputeMode.Removal, n);
    }

    public void addAll(BonusList bonusList) {
        int n = this.get(Bonus.Type.Con);
        this.bonuses.addAll(bonusList);
        this.checkRecompute(bonusList, RecomputeMode.Addition, n);
    }

    public void addAllNoRecompute(BonusList bonusList) {
        this.bonuses.addAll(bonusList);
    }

    public boolean has(String string) {
        return this.has(Bonus.parseType(string));
    }

    public boolean has(Bonus.Type type) {
        return this.bonuses.has(type);
    }

    public int get(String string, Bonus.Type type) {
        return this.bonuses.get(string, type);
    }

    public int getDamageReduction(String string) {
        return this.bonuses.getDamageReduction(Game.ruleset.getDamageType(string));
    }

    public int getDamageReduction(DamageType damageType) {
        return this.bonuses.getDamageReduction(damageType);
    }

    public int getDamageImmunity(String string) {
        return this.bonuses.getDamageImmunity(Game.ruleset.getDamageType(string));
    }

    public int getDamageImmunity(DamageType damageType) {
        return this.bonuses.getDamageImmunity(damageType);
    }

    public int get(Bonus.Type type, Bonus.StackType stackType) {
        return this.bonuses.get(type, stackType);
    }

    public int get(Bonus.Type type, Bonus.StackType ... stackTypeArray) {
        int n = 0;
        for (Bonus.StackType stackType : stackTypeArray) {
            n += this.bonuses.get(type, stackType);
        }
        return n;
    }

    public int get(Bonus.Type type) {
        return this.bonuses.get(type);
    }

    public int get(Stat stat) {
        if (this.stats.containsKey((Object)stat)) {
            return this.stats.get((Object)stat);
        }
        return 0;
    }

    public boolean hasWeaponProficiency(String string) {
        if (string.equals(Game.ruleset.getString("DefaultBaseWeapon"))) {
            return true;
        }
        return this.bonuses.hasWeaponProficiency(string);
    }

    public boolean hasArmorProficiency(String string) {
        if (string.equals(Game.ruleset.getString("DefaultArmorType"))) {
            return true;
        }
        return this.bonuses.hasArmorProficiency(string);
    }

    public int getSkillBonus(String string) {
        return this.bonuses.getSkillBonus(string);
    }

    public Damage rollStandaloneDamage(Creature creature) {
        return this.bonuses.rollStandaloneDamage(creature);
    }

    public int getAppliedDamage(int n, DamageType damageType) {
        return this.bonuses.getAppliedDamage(n, damageType);
    }

    private void addToStat(Stat stat, int n) {
        int n2 = this.stats.get((Object)stat);
        this.stats.put(stat, n2 + n);
    }

    private void zeroStats(Stat ... statArray) {
        for (Stat stat : statArray) {
            this.stats.put(stat, 0);
        }
    }

    public void recomputeStr() {
        this.stats.put(Stat.Str, this.getBaseStr() + this.get(Bonus.Type.Str));
        this.recomputeWeightLimit();
        this.recomputeAttackBonus();
    }

    private void recomputeStrNoAttackBonus() {
        this.stats.put(Stat.Str, this.getBaseStr() + this.get(Bonus.Type.Str));
        this.recomputeWeightLimit();
    }

    public void recomputeDex() {
        this.stats.put(Stat.Dex, this.getBaseDex() + this.get(Bonus.Type.Dex));
        this.recomputeReflexResistance();
        this.recomputeArmorClass();
        this.recomputeAttackBonus();
    }

    public void recomputeCon() {
        this.stats.put(Stat.Con, this.getBaseCon() + this.get(Bonus.Type.Con));
        this.recomputeLevelAndMaxHP();
        this.recomputePhysicalResistance();
    }

    public void recomputeInt() {
        this.stats.put(Stat.Int, this.getBaseInt() + this.get(Bonus.Type.Int));
    }

    public void recomputeWis() {
        this.stats.put(Stat.Wis, this.getBaseWis() + this.get(Bonus.Type.Wis));
        this.recomputeMentalResistance();
    }

    public void recomputeCha() {
        this.stats.put(Stat.Cha, this.getBaseCha() + this.get(Bonus.Type.Cha));
    }

    public void recomputeLevelAndMaxHP() {
        this.zeroStats(Stat.LevelAttackBonus, Stat.LevelDamageBonus, Stat.MaxHP);
        this.stats.put(Stat.CasterLevel, this.parent.roles.getCasterLevel());
        this.stats.put(Stat.CreatureLevel, this.parent.roles.getTotalLevel());
        for (String string : this.parent.roles.getRoleIDs()) {
            Role role = Game.ruleset.getRole(string);
            int n = this.parent.roles.getLevel(string);
            this.addToStat(Stat.LevelAttackBonus, n * role.getAttackBonusPerLevel());
            this.addToStat(Stat.LevelDamageBonus, n * role.getDamageBonusPerLevel());
            if (role == this.parent.roles.getBaseRole()) {
                this.addToStat(Stat.MaxHP, role.getHPAtLevelOne() + (n - 1) * role.getHPPerLevel());
                continue;
            }
            this.addToStat(Stat.MaxHP, n * role.getHPPerLevel());
        }
        this.addToStat(Stat.MaxHP, (this.getCon() - 10) * this.get(Stat.CreatureLevel) / 3);
        this.recomputeMentalResistance();
        this.recomputePhysicalResistance();
        this.recomputeReflexResistance();
    }

    public void recomputeMentalResistance() {
        this.stats.put(Stat.MentalResistance, (this.getWis() - 10) * 2 + this.getCreatureLevel() * 3);
    }

    public void recomputePhysicalResistance() {
        this.stats.put(Stat.PhysicalResistance, (this.getCon() - 10) * 2 + this.getCreatureLevel() * 3);
    }

    public void recomputeReflexResistance() {
        this.stats.put(Stat.ReflexResistance, (this.getDex() - 10) * 2 + this.getCreatureLevel() * 3);
    }

    public void recomputeWeightLimit() {
        this.stats.put(Stat.WeightLimit, Game.ruleset.getValue("WeightLimitBase") + (this.getStr() - 10) * Game.ruleset.getValue("WeightLimitStrengthFactor"));
    }

    public void recomputeArmorClass() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        EquippableItem equippableItem = this.parent.inventory.getEquippedItem(Inventory.Slot.OffHand);
        Weapon weapon = equippableItem != null && equippableItem.getTemplate().getType() == EquippableItemTemplate.Type.Weapon ? (Weapon)equippableItem : null;
        ArrayList<Armor> arrayList = new ArrayList<Armor>(5);
        arrayList.add((Armor)this.parent.inventory.getEquippedItem(Inventory.Slot.Armor));
        arrayList.add((Armor)this.parent.inventory.getEquippedItem(Inventory.Slot.Helmet));
        arrayList.add((Armor)this.parent.inventory.getEquippedItem(Inventory.Slot.Gloves));
        arrayList.add((Armor)this.parent.inventory.getEquippedItem(Inventory.Slot.Boots));
        if (equippableItem != null && equippableItem.getTemplate().getType() == EquippableItemTemplate.Type.Shield) {
            arrayList.add((Armor)this.parent.inventory.getEquippedItem(Inventory.Slot.OffHand));
        }
        for (Armor armor : arrayList) {
            if (armor == null) continue;
            switch (armor.getTemplate().getType()) {
                case Shield: {
                    f4 += armor.getQualityModifiedArmorClass() * (100.0f + (float)this.get(armor.getTemplate().getArmorType().getName(), Bonus.Type.ArmorTypeArmorClass)) / 100.0f;
                }
            }
            f += armor.getQualityModifiedArmorClass() * (100.0f + (float)this.get(armor.getTemplate().getArmorType().getName(), Bonus.Type.ArmorTypeArmorClass)) / 100.0f;
            f2 += armor.getQualityModifiedArmorPenalty() * (100.0f - (float)this.get(armor.getTemplate().getArmorType().getName(), Bonus.Type.ArmorTypeArmorPenalty)) / 100.0f;
            f3 += armor.getQualityModifiedMovementPenalty() * (100.0f - (float)this.get(armor.getTemplate().getArmorType().getName(), Bonus.Type.ArmorTypeMovementPenalty)) / 100.0f;
        }
        f -= f4;
        if (weapon != null) {
            f4 = this.get(Bonus.Type.DualWieldArmorClass);
        }
        this.zeroStats(Stat.ArmorClass, Stat.TouchArmorClass, Stat.ArmorPenalty, Stat.MovementBonus);
        this.zeroStats(Stat.MovementCost, Stat.InitiativeBonus);
        this.addToStat(Stat.InitiativeBonus, this.get(Bonus.Type.Initiative));
        this.addToStat(Stat.ArmorPenalty, this.get(Bonus.Type.ArmorPenalty) + (int)f2);
        int n = this.get(Bonus.Type.Movement);
        if (this.has(Bonus.Type.ImmobilizationImmunity) && n < 0) {
            n = 0;
        }
        this.addToStat(Stat.MovementBonus, Math.min(100, n - (int)f3));
        this.addToStat(Stat.MovementCost, this.parent.getTemplate().getRace().getMovementCost() * (100 - this.get(Stat.MovementBonus)) / 100);
        int n2 = this.get(Bonus.Type.ArmorClass, Bonus.StackType.DeflectionBonus, Bonus.StackType.DeflectionPenalty);
        int n3 = this.get(Bonus.Type.ArmorClass, Bonus.StackType.NaturalArmorBonus, Bonus.StackType.NaturalArmorPenalty);
        int n4 = this.get(Bonus.Type.ArmorClass, Bonus.StackType.ArmorBonus, Bonus.StackType.ArmorPenalty);
        int n5 = this.get(Bonus.Type.ArmorClass, Bonus.StackType.ShieldBonus, Bonus.StackType.ShieldPenalty);
        int n6 = this.get(Bonus.Type.ArmorClass, Bonus.StackType.StackableBonus, Bonus.StackType.StackablePenalty);
        float f5 = (100.0f - (float)this.get(Stat.ArmorPenalty)) / 100.0f;
        float f6 = 3.0f * ((float)this.getDex() - 10.0f);
        int n7 = 0;
        n7 = (double)f6 > 0.0 ? (int)(f6 * f5) : (int)f6;
        n4 = Math.max(n4, (int)f);
        n5 = Math.max(n5, (int)f4);
        this.addToStat(Stat.ArmorClass, 50 + n2 + n3 + n4 + n5);
        this.addToStat(Stat.TouchArmorClass, 50 + n2 + n5);
        if (this.parent.stats.isImmobilized()) {
            this.addToStat(Stat.ArmorClass, -20);
            this.addToStat(Stat.TouchArmorClass, -20);
        } else {
            this.addToStat(Stat.ArmorClass, n6 + n7);
            this.addToStat(Stat.TouchArmorClass, n6 + n7);
            this.addToStat(Stat.InitiativeBonus, (this.getDex() - 10) * 2);
        }
    }

    public void recomputeAttackBonus() {
        Weapon weapon = this.parent.getMainHandWeapon();
        EquippableItem equippableItem = this.parent.inventory.getEquippedItem(Inventory.Slot.OffHand);
        Weapon weapon2 = equippableItem != null && equippableItem.getTemplate().getType() == EquippableItemTemplate.Type.Weapon ? (Weapon)equippableItem : null;
        this.zeroStats(Stat.MainHandAttackBonus, Stat.MainHandDamageBonus, Stat.OffHandAttackBonus, Stat.OffHandDamageBonus);
        this.zeroStats(Stat.AttackCost, Stat.TouchAttackBonus, Stat.ShieldAttackPenalty);
        if (equippableItem != null && equippableItem.getTemplate().getType() == EquippableItemTemplate.Type.Shield) {
            this.addToStat(Stat.ShieldAttackPenalty, Math.min(0, this.get(Bonus.Type.ShieldAttack) - ((Armor)equippableItem).getTemplate().getShieldAttackPenalty()));
        }
        String string = weapon.getTemplate().getBaseWeapon().getName();
        this.addToStat(Stat.MainHandAttackBonus, this.get(Bonus.Type.MainHandAttack) + this.get(Bonus.Type.Attack));
        this.addToStat(Stat.MainHandDamageBonus, this.get(Bonus.Type.MainHandDamage) + this.get(Bonus.Type.Damage));
        this.addToStat(Stat.MainHandAttackBonus, this.get(string, Bonus.Type.BaseWeaponAttack));
        this.addToStat(Stat.MainHandDamageBonus, this.get(string, Bonus.Type.BaseWeaponDamage));
        this.addToStat(Stat.MainHandAttackBonus, this.get(Stat.ShieldAttackPenalty));
        switch (weapon.getTemplate().getWeaponType()) {
            case Melee: {
                switch (weapon.getTemplate().getHanded()) {
                    case Light: {
                        this.addToStat(Stat.MainHandAttackBonus, (Math.max(this.getDex(), this.getStr()) - 10) * 2);
                        this.addToStat(Stat.MainHandDamageBonus, this.get(Bonus.Type.LightMeleeWeaponDamage));
                        this.addToStat(Stat.MainHandAttackBonus, this.get(Bonus.Type.LightMeleeWeaponAttack));
                        break;
                    }
                    case OneHanded: {
                        this.addToStat(Stat.MainHandAttackBonus, this.get(Bonus.Type.OneHandedMeleeWeaponAttack) + (this.getStr() - 10) * 2);
                        this.addToStat(Stat.MainHandDamageBonus, this.get(Bonus.Type.OneHandedMeleeWeaponDamage));
                        break;
                    }
                    case TwoHanded: {
                        this.addToStat(Stat.MainHandAttackBonus, this.get(Bonus.Type.TwoHandedMeleeWeaponAttack) + (this.getStr() - 10) * 2);
                        this.addToStat(Stat.MainHandDamageBonus, this.get(Bonus.Type.TwoHandedMeleeWeaponDamage));
                    }
                }
                if (weapon2 != null) break;
                this.addToStat(Stat.MainHandDamageBonus, 8 * (this.getStr() - 10));
                break;
            }
            default: {
                this.addToStat(Stat.MainHandAttackBonus, (this.getDex() - 10) * 2 + this.get(Bonus.Type.RangedAttack));
                this.addToStat(Stat.MainHandDamageBonus, Math.max(weapon.getTemplate().getMinStrengthBonus(), Math.min((this.getStr() - 10) * 8, weapon.getTemplate().getMaxStrengthBonus())));
                this.addToStat(Stat.MainHandDamageBonus, this.get(Bonus.Type.RangedDamage));
            }
        }
        int n = this.get(string, Bonus.Type.BaseWeaponSpeed) + this.get(Bonus.Type.AttackCost);
        int n2 = weapon.getTemplate().getAttackCost() * (100 - n) / 100;
        int n3 = 0;
        if (weapon2 != null) {
            String string2 = weapon2.getTemplate().getBaseWeapon().getName();
            this.addToStat(Stat.OffHandAttackBonus, this.get(Bonus.Type.OffHandAttack) + this.get(Bonus.Type.Attack));
            this.addToStat(Stat.OffHandDamageBonus, this.get(Bonus.Type.OffHandDamage) + this.get(Bonus.Type.Damage));
            this.addToStat(Stat.OffHandAttackBonus, this.get(string2, Bonus.Type.BaseWeaponAttack));
            this.addToStat(Stat.OffHandDamageBonus, this.get(string2, Bonus.Type.BaseWeaponDamage));
            int n4 = this.get(string2, Bonus.Type.BaseWeaponSpeed) + this.get(Bonus.Type.AttackCost);
            n3 = weapon2.getTemplate().getAttackCost() * (100 - n4) / 100;
            int n5 = 0;
            switch (weapon2.getTemplate().getHanded()) {
                case Light: {
                    this.addToStat(Stat.OffHandAttackBonus, (this.getDex() - 10) * 2 + this.get(Bonus.Type.LightMeleeWeaponAttack));
                    this.addToStat(Stat.OffHandDamageBonus, this.get(Bonus.Type.LightMeleeWeaponDamage));
                    break;
                }
                case OneHanded: {
                    this.addToStat(Stat.OffHandAttackBonus, (this.getStr() - 10) * 2 + this.get(Bonus.Type.OneHandedMeleeWeaponAttack));
                    this.addToStat(Stat.OffHandDamageBonus, this.get(Bonus.Type.OneHandedMeleeWeaponDamage));
                    n5 = -10;
                }
            }
            this.addToStat(Stat.OffHandDamageBonus, (3 + this.get(Bonus.Type.DualWieldStrDamage)) * (this.getStr() - 10));
            this.addToStat(Stat.MainHandDamageBonus, (5 + this.get(Bonus.Type.DualWieldStrDamage)) * (this.getStr() - 10));
            this.addToStat(Stat.MainHandAttackBonus, this.get(Bonus.Type.DualWieldAttack) - 15 + n5);
            this.addToStat(Stat.OffHandAttackBonus, this.get(Bonus.Type.DualWieldAttack) - 25 + n5);
        }
        this.addToStat(Stat.AttackCost, Math.max(n2, n3));
        this.addToStat(Stat.TouchAttackBonus, (this.getDex() - 10) * 2 + this.get(Bonus.Type.Attack));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recomputeAllStats() {
        this.bonuses.clear();
        Inventory.Slot[] slotArray = this.parent.getEffects();
        synchronized (slotArray) {
            for (Effect effect : this.parent.getEffects()) {
                this.addAllNoRecompute(effect.getBonuses());
            }
        }
        for (Inventory.Slot slot : Inventory.Slot.values()) {
            EquippableItem equippableItem = this.parent.inventory.getEquippedItem(slot);
            if (equippableItem == null) continue;
            this.addAllNoRecompute(equippableItem.getBonusList());
        }
        this.recomputeStrNoAttackBonus();
        this.recomputeDex();
        this.recomputeCon();
        this.recomputeInt();
        this.recomputeWis();
        this.recomputeCha();
    }

    public void setStat(String string, int n) {
        this.setStat(Stat.valueOf(string), n);
    }

    public void setStat(Stat stat, int n) {
        this.stats.put(stat, n);
        this.recomputeAllStats();
    }

    public void setAttributes(int[] nArray) {
        if (nArray == null) {
            return;
        }
        if (nArray.length == 6) {
            this.stats.put(Stat.BaseStr, nArray[0]);
            this.stats.put(Stat.BaseDex, nArray[1]);
            this.stats.put(Stat.BaseCon, nArray[2]);
            this.stats.put(Stat.BaseInt, nArray[3]);
            this.stats.put(Stat.BaseWis, nArray[4]);
            this.stats.put(Stat.BaseCha, nArray[5]);
        }
    }

    public int[] getAttributes() {
        int[] nArray = new int[]{this.stats.get((Object)Stat.BaseStr), this.stats.get((Object)Stat.BaseDex), this.stats.get((Object)Stat.BaseCon), this.stats.get((Object)Stat.BaseInt), this.stats.get((Object)Stat.BaseWis), this.stats.get((Object)Stat.BaseCha)};
        return nArray;
    }

    public int getBaseSpellFailure(int n) {
        Role role = this.parent.roles.getBaseRole();
        int n2 = this.get(role.getSpellCastingAttribute());
        int n3 = this.getCasterLevel();
        int n4 = role.getSpellFailureBase() + role.getSpellFailureSpellLevelFactor() * n;
        n4 -= (n2 - 10) * role.getSpellFailureAbilityScoreFactor();
        n4 -= n3 * role.getSpellFailureCasterLevelFactor();
        return n4 -= this.get(Bonus.Type.SpellFailure);
    }

    public int getCasterLevel() {
        return this.get(Stat.CasterLevel);
    }

    public int getCreatureLevel() {
        return this.get(Stat.CreatureLevel);
    }

    public int getLevelDamageBonus() {
        return this.get(Stat.LevelDamageBonus);
    }

    public int getLevelAttackBonus() {
        return this.get(Stat.LevelAttackBonus);
    }

    public int getMaxHP() {
        return this.get(Stat.MaxHP);
    }

    public int getSpellCastingAttribute() {
        return this.get(this.parent.roles.getBaseRole().getSpellCastingAttribute());
    }

    public int getBaseStr() {
        return this.get(Stat.BaseStr) + this.get(Bonus.Type.BaseStr);
    }

    public int getBaseDex() {
        return this.get(Stat.BaseDex) + this.get(Bonus.Type.BaseDex);
    }

    public int getBaseCon() {
        return this.get(Stat.BaseCon) + this.get(Bonus.Type.BaseCon);
    }

    public int getBaseInt() {
        return this.get(Stat.BaseInt) + this.get(Bonus.Type.BaseInt);
    }

    public int getBaseWis() {
        return this.get(Stat.BaseWis) + this.get(Bonus.Type.BaseWis);
    }

    public int getBaseCha() {
        return this.get(Stat.BaseCha) + this.get(Bonus.Type.BaseCha);
    }

    public int getStr() {
        return this.get(Stat.Str);
    }

    public int getDex() {
        return this.get(Stat.Dex);
    }

    public int getCon() {
        return this.get(Stat.Con);
    }

    public int getInt() {
        return this.get(Stat.Int);
    }

    public int getWis() {
        return this.get(Stat.Wis);
    }

    public int getCha() {
        return this.get(Stat.Cha);
    }

    public int getMentalResistance() {
        return this.get(Stat.MentalResistance) + this.get(Bonus.Type.MentalResistance);
    }

    public int getPhysicalResistance() {
        return this.get(Stat.PhysicalResistance) + this.get(Bonus.Type.PhysicalResistance);
    }

    public int getReflexResistance() {
        return this.get(Stat.ReflexResistance) + this.get(Bonus.Type.ReflexResistance);
    }

    public int getWeightLimit() {
        return this.get(Stat.WeightLimit) + this.get(Bonus.Type.WeightLimit) * 1000;
    }

    public boolean isHidden() {
        return this.bonuses.has(Bonus.Type.Hidden);
    }

    public boolean isImmobilized() {
        return (this.bonuses.has(Bonus.Type.Immobilized) || this.bonuses.has(Bonus.Type.UndispellableImmobilized)) && !this.bonuses.has(Bonus.Type.ImmobilizationImmunity);
    }

    public boolean isHelpless() {
        return (this.bonuses.has(Bonus.Type.Helpless) || this.bonuses.has(Bonus.Type.UndispellableHelpless)) && !this.bonuses.has(Bonus.Type.ImmobilizationImmunity);
    }

    public int getAttacksOfOpportunity() {
        return 1 + this.get(Bonus.Type.AttacksOfOpportunity);
    }

    public int getAttackCost() {
        return this.stats.get((Object)Stat.AttackCost);
    }

    public int getMovementCost() {
        return this.stats.get((Object)Stat.MovementCost);
    }

    public boolean getMentalResistanceCheck(int n) {
        return this.getCheck(n, this.getMentalResistance(), new StringBuilder("Mental Resistance Check: "));
    }

    public boolean getPhysicalResistanceCheck(int n) {
        return this.getCheck(n, this.getPhysicalResistance(), new StringBuilder("Physical Resistance Check: "));
    }

    public boolean getReflexResistanceCheck(int n) {
        return this.getCheck(n, this.getReflexResistance(), new StringBuilder("Reflex Resistance Check: "));
    }

    private boolean getCheck(int n, int n2, StringBuilder stringBuilder) {
        int n3 = Game.dice.d100();
        int n4 = n2 + n3;
        stringBuilder.insert(0, this.parent.getTemplate().getName() + " attempts ");
        stringBuilder.append(n2);
        stringBuilder.append(" + ");
        stringBuilder.append(n3);
        stringBuilder.append(" = ");
        stringBuilder.append(n4);
        stringBuilder.append(" vs ");
        stringBuilder.append(n);
        stringBuilder.append(" : ");
        if (n4 >= n) {
            stringBuilder.append("Success.");
            Game.mainViewer.addMessage("orange", stringBuilder.toString());
            return true;
        }
        stringBuilder.append("Failure.");
        Game.mainViewer.addMessage("orange", stringBuilder.toString());
        return false;
    }

    private static enum RecomputeMode {
        Removal,
        Addition;

    }
}

