/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.bonus;

import java.util.LinkedList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.StandaloneDamageBonus;
import net.sf.hale.entity.Creature;
import net.sf.hale.rules.Damage;

public class StandaloneDamageBonusList {
    private List<StandaloneDamageBonus> bonuses;

    public StandaloneDamageBonusList() {
    }

    public StandaloneDamageBonusList(StandaloneDamageBonusList standaloneDamageBonusList) {
        if (standaloneDamageBonusList.bonuses != null) {
            this.bonuses = new LinkedList<StandaloneDamageBonus>(standaloneDamageBonusList.bonuses);
        }
    }

    public void add(Bonus bonus) {
        if (this.bonuses == null) {
            this.bonuses = new LinkedList<StandaloneDamageBonus>();
        }
        if (bonus.getType() == Bonus.Type.StandaloneDamage) {
            this.bonuses.add((StandaloneDamageBonus)bonus);
        }
    }

    public void remove(Bonus bonus) {
        this.bonuses.remove(bonus);
    }

    public boolean isEmpty() {
        return this.bonuses != null && this.bonuses.size() > 0;
    }

    public void clear() {
        if (this.bonuses != null) {
            this.bonuses.clear();
        }
    }

    public Damage roll(Creature creature) {
        Damage damage = new Damage(creature);
        if (this.bonuses == null) {
            return damage;
        }
        for (StandaloneDamageBonus standaloneDamageBonus : this.bonuses) {
            int n = standaloneDamageBonus.getMinDamage() == standaloneDamageBonus.getMaxDamage() ? standaloneDamageBonus.getMinDamage() : Game.dice.rand(standaloneDamageBonus.getMinDamage(), standaloneDamageBonus.getMaxDamage());
            damage.add(Game.ruleset.getDamageType(standaloneDamageBonus.getDamageType()), n);
        }
        return damage;
    }
}

