/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.bonus;

import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.IntBonus;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.util.SimpleJSONObject;

public class StandaloneDamageBonus
extends IntBonus {
    private final String damageType;
    private final int minDamage;
    private final int maxDamage;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("standaloneDamageType", this.damageType);
        jSONOrderedObject.put("minDamage", this.minDamage);
        jSONOrderedObject.put("maxDamage", this.maxDamage);
        return jSONOrderedObject;
    }

    public static StandaloneDamageBonus load(SimpleJSONObject simpleJSONObject) {
        String string = simpleJSONObject.get("standaloneDamageType", null);
        int n = simpleJSONObject.get("minDamage", 0);
        int n2 = simpleJSONObject.get("maxDamage", 0);
        return new StandaloneDamageBonus(string, n, n2);
    }

    public StandaloneDamageBonus(String string, int n, int n2) {
        super(Bonus.Type.StandaloneDamage, Bonus.StackType.GenericBonus, (n + n2) / 2);
        this.damageType = string;
        this.minDamage = n;
        this.maxDamage = n2;
    }

    public int getMinDamage() {
        return this.minDamage;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    public String getDamageType() {
        return this.damageType;
    }

    @Override
    public StandaloneDamageBonus cloneWithReduction(int n) {
        return new StandaloneDamageBonus(this.damageType, this.minDamage - n, this.maxDamage - n);
    }

    @Override
    public void appendDescription(StringBuilder stringBuilder) {
        stringBuilder.append("Extra Damage: ");
        stringBuilder.append("<span style=\"font-family: red\">");
        stringBuilder.append(this.minDamage);
        if (this.minDamage != this.maxDamage) {
            stringBuilder.append("</span> to <span style=\"font-family: red\">");
            stringBuilder.append(this.maxDamage);
        }
        stringBuilder.append("</span> ");
        stringBuilder.append(this.damageType);
    }
}

