/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.bonus;

import net.sf.hale.Game;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.BonusWithSuperType;
import net.sf.hale.bonus.IntBonus;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.util.SimpleJSONObject;

public class SkillBonus
extends IntBonus
implements BonusWithSuperType {
    private final String skillID;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("stackType", this.getStackType().toString());
        jSONOrderedObject.put("value", this.getValue());
        jSONOrderedObject.put("skillID", this.skillID);
        return jSONOrderedObject;
    }

    public static SkillBonus load(SimpleJSONObject simpleJSONObject) {
        int n = simpleJSONObject.get("value", 0);
        Bonus.StackType stackType = Bonus.StackType.valueOf(simpleJSONObject.get("stackType", null));
        String string = simpleJSONObject.get("skillID", null);
        return new SkillBonus(string, stackType, n);
    }

    public SkillBonus(String string, Bonus.StackType stackType, int n) {
        super(Bonus.Type.Skill, stackType, n);
        this.skillID = string;
    }

    public String getSkillID() {
        return this.skillID;
    }

    @Override
    public String getSuperType() {
        return this.skillID;
    }

    @Override
    public SkillBonus cloneWithReduction(int n) {
        return new SkillBonus(this.skillID, this.getStackType(), this.getValue() - n);
    }

    @Override
    public void appendDescription(StringBuilder stringBuilder) {
        stringBuilder.append("<span style=\"font-family: blue;\">");
        stringBuilder.append(Game.ruleset.getSkill(this.skillID).getNoun());
        stringBuilder.append("</span> Skill ");
        super.appendDescription(stringBuilder);
    }
}

