/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.bonus;

import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.BonusWithSuperType;
import net.sf.hale.bonus.IntBonus;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.util.SimpleJSONObject;

public class RacialTypeBonus
extends IntBonus
implements BonusWithSuperType {
    private final String racialType;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        jSONOrderedObject.put("racialType", this.racialType);
        return jSONOrderedObject;
    }

    public static RacialTypeBonus load(SimpleJSONObject simpleJSONObject) {
        int n = simpleJSONObject.get("value", 0);
        Bonus.Type type = Bonus.Type.valueOf(simpleJSONObject.get("type", null));
        Bonus.StackType stackType = Bonus.StackType.valueOf(simpleJSONObject.get("stackType", null));
        String string = simpleJSONObject.get("racialType", null);
        return new RacialTypeBonus(type, stackType, string, n);
    }

    public RacialTypeBonus(Bonus.Type type, Bonus.StackType stackType, String string, int n) {
        super(type, stackType, n);
        this.racialType = string;
    }

    public String getRacialType() {
        return this.racialType;
    }

    @Override
    public String getSuperType() {
        return this.racialType;
    }

    @Override
    public RacialTypeBonus cloneWithReduction(int n) {
        return new RacialTypeBonus(this.getType(), this.getStackType(), this.racialType, this.getValue() - n);
    }

    @Override
    public void appendDescription(StringBuilder stringBuilder) {
        super.appendDescription(stringBuilder);
        stringBuilder.append(" vs Racial Type ");
        stringBuilder.append("<span style=\"font-family: blue;\">");
        stringBuilder.append(this.racialType);
        stringBuilder.append("</span>");
    }
}

