/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.bonus;

import net.sf.hale.bonus.Bonus;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.util.SimpleJSONObject;

public class IntBonus
extends Bonus {
    private final int value;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        jSONOrderedObject.put("value", this.value);
        return jSONOrderedObject;
    }

    public static IntBonus load(SimpleJSONObject simpleJSONObject) {
        int n = simpleJSONObject.get("value", 0);
        Bonus.Type type = Bonus.Type.valueOf(simpleJSONObject.get("type", null));
        Bonus.StackType stackType = Bonus.StackType.valueOf(simpleJSONObject.get("stackType", null));
        return new IntBonus(type, stackType, n);
    }

    public IntBonus(Bonus.Type type, Bonus.StackType stackType, int n) {
        super(type, stackType);
        this.value = n;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public IntBonus cloneWithReduction(int n) {
        return new IntBonus(this.getType(), this.getStackType(), this.value - n);
    }

    @Override
    public void appendDescription(StringBuilder stringBuilder) {
        super.appendDescription(stringBuilder);
        if (this.value > 0) {
            stringBuilder.append(" <span style=\"font-family: green;\">+");
        } else {
            stringBuilder.append(" <span style=\"font-family: red;\">");
        }
        stringBuilder.append(this.getValue()).append("</span>");
    }
}

