/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.bonus;

import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.BonusWithSuperType;
import net.sf.hale.bonus.IntBonus;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.util.SimpleJSONObject;

public class DamageBonus
extends IntBonus
implements BonusWithSuperType {
    private final String damageType;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        jSONOrderedObject.put("damageType", this.damageType);
        return jSONOrderedObject;
    }

    public static DamageBonus load(SimpleJSONObject simpleJSONObject) {
        int n = simpleJSONObject.get("value", 0);
        Bonus.Type type = Bonus.Type.valueOf(simpleJSONObject.get("type", null));
        Bonus.StackType stackType = Bonus.StackType.valueOf(simpleJSONObject.get("stackType", null));
        String string = simpleJSONObject.get("damageType", null);
        return new DamageBonus(type, stackType, string, n);
    }

    public DamageBonus(Bonus.Type type, Bonus.StackType stackType, String string, int n) {
        super(type, stackType, n);
        this.damageType = string;
    }

    public String getDamageType() {
        return this.damageType;
    }

    @Override
    public String getSuperType() {
        return this.damageType;
    }

    @Override
    public DamageBonus cloneWithReduction(int n) {
        return new DamageBonus(this.getType(), this.getStackType(), this.damageType, this.getValue() - n);
    }

    @Override
    public void appendDescription(StringBuilder stringBuilder) {
        super.appendDescription(stringBuilder);
        stringBuilder.append(" for ");
        stringBuilder.append(this.damageType);
    }
}

