/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.bonus;

import java.util.HashMap;
import java.util.Map;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.BonusStackTypeList;

public class BonusTypeList {
    private int currentTotal;
    private Map<Bonus.StackType, BonusStackTypeList> bonuses = new HashMap<Bonus.StackType, BonusStackTypeList>();

    public BonusTypeList() {
        this.currentTotal = 0;
    }

    public BonusTypeList(BonusTypeList bonusTypeList) {
        for (Bonus.StackType stackType : bonusTypeList.bonuses.keySet()) {
            BonusStackTypeList bonusStackTypeList = new BonusStackTypeList(bonusTypeList.bonuses.get((Object)stackType));
            this.bonuses.put(stackType, bonusStackTypeList);
        }
        this.currentTotal = bonusTypeList.currentTotal;
    }

    public void remove(Bonus bonus) {
        Bonus.StackType stackType = bonus.getStackType();
        if (this.bonuses.containsKey((Object)stackType)) {
            this.bonuses.get((Object)stackType).remove(bonus);
            if (this.bonuses.get((Object)stackType).isEmpty()) {
                this.bonuses.remove((Object)stackType);
            }
        }
        if (bonus.hasValue()) {
            this.currentTotal = 0;
            for (Bonus.StackType stackType2 : this.bonuses.keySet()) {
                this.currentTotal += this.bonuses.get((Object)stackType2).getCurrentTotal();
            }
        }
    }

    public void add(Bonus bonus) {
        Bonus.StackType stackType = bonus.getStackType();
        if (this.bonuses.containsKey((Object)stackType)) {
            this.currentTotal -= this.bonuses.get((Object)stackType).getCurrentTotal();
            this.bonuses.get((Object)stackType).add(bonus);
            if (bonus.hasValue()) {
                this.currentTotal += this.bonuses.get((Object)stackType).getCurrentTotal();
            }
        } else {
            BonusStackTypeList bonusStackTypeList = new BonusStackTypeList();
            bonusStackTypeList.add(bonus);
            this.bonuses.put(stackType, bonusStackTypeList);
            if (bonus.hasValue()) {
                this.currentTotal += this.bonuses.get((Object)stackType).getCurrentTotal();
            }
        }
    }

    public int get(Bonus.StackType stackType) {
        if (this.bonuses.containsKey((Object)stackType)) {
            return this.bonuses.get((Object)stackType).getCurrentTotal();
        }
        return 0;
    }

    public int getCurrentTotal() {
        return this.currentTotal;
    }

    public boolean isEmpty() {
        return this.bonuses.keySet().size() == 0;
    }
}

