/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.bonus;

import java.util.LinkedList;
import java.util.List;
import net.sf.hale.bonus.Bonus;

public class BonusStackTypeList {
    private int currentTotal;
    private List<Bonus> bonuses;

    public BonusStackTypeList() {
        this.bonuses = new LinkedList<Bonus>();
        this.currentTotal = 0;
    }

    public BonusStackTypeList(BonusStackTypeList bonusStackTypeList) {
        this.bonuses = new LinkedList<Bonus>(bonusStackTypeList.bonuses);
        this.currentTotal = bonusStackTypeList.currentTotal;
    }

    public void add(Bonus bonus) {
        this.bonuses.add(bonus);
        if (!bonus.hasValue()) {
            return;
        }
        switch (bonus.getStackType()) {
            case StackableBonus: 
            case StackablePenalty: {
                this.currentTotal += bonus.getValue();
                break;
            }
            default: {
                if (Math.abs(bonus.getValue()) <= Math.abs(this.currentTotal)) break;
                this.currentTotal = bonus.getValue();
            }
        }
    }

    public void remove(Bonus bonus) {
        this.bonuses.remove(bonus);
        if (!bonus.hasValue()) {
            return;
        }
        this.currentTotal = 0;
        switch (bonus.getStackType()) {
            case StackableBonus: 
            case StackablePenalty: {
                for (Bonus bonus2 : this.bonuses) {
                    this.currentTotal += bonus2.getValue();
                }
                break;
            }
            default: {
                for (Bonus bonus3 : this.bonuses) {
                    if (Math.abs(bonus3.getValue()) <= Math.abs(this.currentTotal)) continue;
                    this.currentTotal = bonus3.getValue();
                }
            }
        }
    }

    public int getCurrentTotal() {
        return this.currentTotal;
    }

    public boolean isEmpty() {
        return this.bonuses.size() == 0;
    }
}

