/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.bonus;

import java.util.HashMap;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.bonus.ArmorProficiency;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.BonusList;
import net.sf.hale.bonus.BonusSuperTypeList;
import net.sf.hale.bonus.BonusTypeList;
import net.sf.hale.bonus.BonusWithSuperType;
import net.sf.hale.bonus.ProficiencyList;
import net.sf.hale.bonus.StandaloneDamageBonusList;
import net.sf.hale.bonus.WeaponProficiency;
import net.sf.hale.entity.Creature;
import net.sf.hale.rules.Damage;
import net.sf.hale.rules.DamageType;

public class BonusManager {
    private final ProficiencyList weaponProficiencies;
    private final ProficiencyList armorProficiencies;
    private final StandaloneDamageBonusList standaloneDamageBonuses;
    private final Map<Bonus.Type, BonusTypeList> bonuses = new HashMap<Bonus.Type, BonusTypeList>();
    private final Map<String, BonusSuperTypeList> bonusesWithSuperType;

    public BonusManager() {
        this.weaponProficiencies = new ProficiencyList();
        this.armorProficiencies = new ProficiencyList();
        this.bonusesWithSuperType = new HashMap<String, BonusSuperTypeList>();
        this.standaloneDamageBonuses = new StandaloneDamageBonusList();
    }

    public BonusManager(BonusManager bonusManager) {
        Object object;
        for (Bonus.Type object2 : bonusManager.bonuses.keySet()) {
            object = new BonusTypeList(bonusManager.bonuses.get((Object)object2));
            this.bonuses.put(object2, (BonusTypeList)object);
        }
        this.weaponProficiencies = new ProficiencyList(bonusManager.weaponProficiencies);
        this.armorProficiencies = new ProficiencyList(bonusManager.armorProficiencies);
        this.bonusesWithSuperType = new HashMap<String, BonusSuperTypeList>();
        for (String string : bonusManager.bonusesWithSuperType.keySet()) {
            object = new BonusSuperTypeList(bonusManager.bonusesWithSuperType.get(string));
            this.bonusesWithSuperType.put(string, (BonusSuperTypeList)object);
        }
        this.standaloneDamageBonuses = new StandaloneDamageBonusList(bonusManager.standaloneDamageBonuses);
    }

    public void removeAll(BonusList bonusList) {
        for (Bonus bonus : bonusList) {
            this.remove(bonus);
        }
    }

    public void remove(Bonus bonus) {
        if (this.bonuses.containsKey((Object)bonus.getType())) {
            this.bonuses.get((Object)bonus.getType()).remove(bonus);
            if (this.bonuses.get((Object)bonus.getType()).isEmpty()) {
                this.bonuses.remove((Object)bonus.getType());
            }
        }
        switch (bonus.getType()) {
            case ArmorProficiency: {
                this.armorProficiencies.remove(((ArmorProficiency)bonus).getArmorType());
                break;
            }
            case WeaponProficiency: {
                this.weaponProficiencies.remove(((WeaponProficiency)bonus).getBaseWeapon());
                break;
            }
            case Skill: 
            case AttackVsRacialType: 
            case DamageVsRacialType: 
            case ArmorClassVsRacialType: 
            case ArmorTypeMovementPenalty: 
            case ArmorTypeArmorPenalty: 
            case ArmorTypeArmorClass: 
            case BaseWeaponAttack: 
            case BaseWeaponDamage: 
            case BaseWeaponSpeed: 
            case BaseWeaponCriticalChance: 
            case BaseWeaponCriticalMultiplier: 
            case DamageImmunity: 
            case DamageReduction: 
            case DamageForWeaponType: 
            case DamageForSpellType: 
            case AttackForWeaponType: {
                String string = ((BonusWithSuperType)((Object)bonus)).getSuperType();
                if (this.bonusesWithSuperType.get(string) == null) break;
                this.bonusesWithSuperType.get(string).remove(bonus);
                break;
            }
            case StandaloneDamage: {
                this.standaloneDamageBonuses.remove(bonus);
            }
        }
    }

    public void addAll(BonusList bonusList) {
        if (bonusList == null) {
            return;
        }
        for (Bonus bonus : bonusList) {
            this.add(bonus);
        }
    }

    public void add(Bonus bonus) {
        switch (bonus.getType()) {
            case ArmorProficiency: {
                String string = ((ArmorProficiency)bonus).getArmorType();
                this.armorProficiencies.add(string);
                break;
            }
            case WeaponProficiency: {
                String string = ((WeaponProficiency)bonus).getBaseWeapon();
                this.weaponProficiencies.add(string);
                break;
            }
            case Skill: 
            case AttackVsRacialType: 
            case DamageVsRacialType: 
            case ArmorClassVsRacialType: 
            case ArmorTypeMovementPenalty: 
            case ArmorTypeArmorPenalty: 
            case ArmorTypeArmorClass: 
            case BaseWeaponAttack: 
            case BaseWeaponDamage: 
            case BaseWeaponSpeed: 
            case BaseWeaponCriticalChance: 
            case BaseWeaponCriticalMultiplier: 
            case DamageImmunity: 
            case DamageReduction: 
            case DamageForWeaponType: 
            case DamageForSpellType: 
            case AttackForWeaponType: {
                String string = ((BonusWithSuperType)((Object)bonus)).getSuperType();
                if (this.bonusesWithSuperType.containsKey(string)) {
                    this.bonusesWithSuperType.get(string).add(bonus);
                    break;
                }
                BonusSuperTypeList bonusSuperTypeList = new BonusSuperTypeList();
                bonusSuperTypeList.add(bonus);
                this.bonusesWithSuperType.put(string, bonusSuperTypeList);
                break;
            }
            case StandaloneDamage: {
                this.standaloneDamageBonuses.add(bonus);
            }
            default: {
                if (this.bonuses.containsKey((Object)bonus.getType())) {
                    this.bonuses.get((Object)bonus.getType()).add(bonus);
                    break;
                }
                BonusTypeList bonusTypeList = new BonusTypeList();
                bonusTypeList.add(bonus);
                this.bonuses.put(bonus.getType(), bonusTypeList);
            }
        }
    }

    public boolean has(Bonus.Type type) {
        return this.bonuses.containsKey((Object)type);
    }

    public int get(String string, Bonus.Type type) {
        if (this.bonusesWithSuperType.containsKey(string)) {
            return this.bonusesWithSuperType.get(string).getCurrentTotal(type);
        }
        return 0;
    }

    public int get(Bonus.Type type) {
        if (this.bonuses.containsKey((Object)type)) {
            return this.bonuses.get((Object)type).getCurrentTotal();
        }
        return 0;
    }

    public int get(Bonus.Type type, Bonus.StackType stackType) {
        if (this.bonuses.containsKey((Object)type)) {
            return this.bonuses.get((Object)type).get(stackType);
        }
        return 0;
    }

    public boolean hasWeaponProficiency(String string) {
        return this.weaponProficiencies.hasProficiency(string);
    }

    public boolean hasArmorProficiency(String string) {
        return this.armorProficiencies.hasProficiency(string);
    }

    public int getSkillBonus(String string) {
        if (this.bonusesWithSuperType.containsKey(string)) {
            return this.bonusesWithSuperType.get(string).getCurrentTotal(Bonus.Type.Skill);
        }
        return 0;
    }

    public Damage rollStandaloneDamage(Creature creature) {
        return this.standaloneDamageBonuses.roll(creature);
    }

    public void clear() {
        this.weaponProficiencies.clear();
        this.armorProficiencies.clear();
        this.bonuses.clear();
        this.bonusesWithSuperType.clear();
        this.standaloneDamageBonuses.clear();
    }

    public int getDamageReduction(DamageType damageType) {
        int n = this.get(damageType.getName(), Bonus.Type.DamageReduction);
        if (damageType.isPhysical()) {
            return n + this.get(Game.ruleset.getString("PhysicalDamageType"), Bonus.Type.DamageReduction);
        }
        return n;
    }

    public int getDamageImmunity(DamageType damageType) {
        int n = this.get(damageType.getName(), Bonus.Type.DamageImmunity);
        if (damageType.isPhysical()) {
            return n + this.get(Game.ruleset.getString("PhysicalDamageType"), Bonus.Type.DamageImmunity);
        }
        return n;
    }

    public int getAppliedDamage(int n, DamageType damageType) {
        BonusSuperTypeList bonusSuperTypeList;
        if (damageType == null) {
            return n;
        }
        int n2 = 0;
        int n3 = 0;
        BonusSuperTypeList bonusSuperTypeList2 = this.bonusesWithSuperType.get(damageType.getName());
        if (bonusSuperTypeList2 != null) {
            n2 += bonusSuperTypeList2.getCurrentTotal(Bonus.Type.DamageReduction);
            n3 += bonusSuperTypeList2.getCurrentTotal(Bonus.Type.DamageImmunity);
        }
        if (damageType.isPhysical() && (bonusSuperTypeList = this.bonusesWithSuperType.get(Game.ruleset.getString("PhysicalDamageType"))) != null) {
            n2 += bonusSuperTypeList.getCurrentTotal(Bonus.Type.DamageReduction);
            n3 += bonusSuperTypeList.getCurrentTotal(Bonus.Type.DamageImmunity);
        }
        if (n3 > 100) {
            n3 = 100;
        }
        if (n2 > n) {
            n2 = n;
        }
        int n4 = (n - n2) * n3 / 100;
        return n - n2 - n4;
    }
}

