/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.bonus;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.hale.bonus.ArmorProficiency;
import net.sf.hale.bonus.ArmorTypeBonus;
import net.sf.hale.bonus.BaseWeaponBonus;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.DamageBonus;
import net.sf.hale.bonus.IntBonus;
import net.sf.hale.bonus.RacialTypeBonus;
import net.sf.hale.bonus.SkillBonus;
import net.sf.hale.bonus.StandaloneDamageBonus;
import net.sf.hale.bonus.WeaponProficiency;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;

public class BonusList
implements Iterable<Bonus>,
Saveable {
    private List<Bonus> bonuses;

    @Override
    public Object save() {
        JSONOrderedObject[] jSONOrderedObjectArray = new JSONOrderedObject[this.bonuses.size()];
        int n = 0;
        for (Bonus bonus : this.bonuses) {
            jSONOrderedObjectArray[n] = bonus.save();
            ++n;
        }
        return jSONOrderedObjectArray;
    }

    public BonusList() {
        this.bonuses = new ArrayList<Bonus>(3);
    }

    public BonusList(BonusList bonusList) {
        this.bonuses = new ArrayList<Bonus>(bonusList.bonuses);
    }

    public void remove(Bonus bonus) {
        this.bonuses.remove(bonus);
    }

    public void addAll(BonusList bonusList) {
        for (Bonus bonus : bonusList.bonuses) {
            this.bonuses.add(bonus);
        }
    }

    public void add(Bonus bonus) {
        this.bonuses.add(bonus);
    }

    public void addStandaloneDamageBonus(String string, int n, int n2) {
        this.addStandaloneDamageBonus(string, Bonus.StackType.GenericBonus, n, n2);
    }

    private void addStandaloneDamageBonus(String string, Bonus.StackType stackType, int n, int n2) {
        this.bonuses.add(new StandaloneDamageBonus(string, n, n2));
    }

    public void addSpellDamagePenalty(String string, int n) {
        this.addSpellDamageBonus(string, Bonus.StackType.GenericPenalty, n);
    }

    public void addSpellDamagePenalty(String string, String string2, int n) {
        this.addSpellDamageBonus(string, Bonus.parseStackType(string2 + "Penalty"), n);
    }

    public void addSpellDamageBonus(String string, int n) {
        this.addSpellDamageBonus(string, Bonus.StackType.GenericBonus, n);
    }

    public void addSpellDamageBonus(String string, String string2, int n) {
        this.addSpellDamageBonus(string, Bonus.parseStackType(string2 + "Bonus"), n);
    }

    private void addSpellDamageBonus(String string, Bonus.StackType stackType, int n) {
        this.bonuses.add(new DamageBonus(Bonus.Type.DamageForSpellType, stackType, string, n));
    }

    public void addAttackBonusVsRacialType(String string, int n) {
        this.addBonusVsRacialType(string, Bonus.Type.AttackVsRacialType, Bonus.StackType.GenericBonus, n);
    }

    public void addDamageBonusVsRacialType(String string, int n) {
        this.addBonusVsRacialType(string, Bonus.Type.DamageVsRacialType, Bonus.StackType.GenericBonus, n);
    }

    public void addArmorClassBonusVsRacialType(String string, int n) {
        this.addBonusVsRacialType(string, Bonus.Type.ArmorClassVsRacialType, Bonus.StackType.GenericBonus, n);
    }

    private void addBonusVsRacialType(String string, Bonus.Type type, Bonus.StackType stackType, int n) {
        this.bonuses.add(new RacialTypeBonus(type, stackType, string, n));
    }

    public void addWeaponDamageBonus(String string, String string2, int n) {
        this.addWeaponDamageBonus(string, Bonus.parseStackType(string2 + "Bonus"), n);
    }

    public void addWeaponDamageBonus(String string, int n) {
        this.addWeaponDamageBonus(string, Bonus.StackType.GenericBonus, n);
    }

    private void addWeaponDamageBonus(String string, Bonus.StackType stackType, int n) {
        this.bonuses.add(new DamageBonus(Bonus.Type.DamageForWeaponType, stackType, string, n));
    }

    public void addWeaponAttackBonus(String string, String string2, int n) {
        this.addWeaponAttackBonus(string, Bonus.parseStackType(string2 + "Bonus"), n);
    }

    public void addWeaponAttackBonus(String string, int n) {
        this.addWeaponAttackBonus(string, Bonus.StackType.GenericBonus, n);
    }

    private void addWeaponAttackBonus(String string, Bonus.StackType stackType, int n) {
        this.bonuses.add(new DamageBonus(Bonus.Type.AttackForWeaponType, stackType, string, n));
    }

    private void addDamageResistanceBonus(String string, Bonus.Type type, Bonus.StackType stackType, int n) {
        this.bonuses.add(new DamageBonus(type, stackType, string, n));
    }

    public void addDamageReduction(String string, int n) {
        this.addDamageResistanceBonus(string, Bonus.Type.DamageReduction, Bonus.StackType.GenericBonus, n);
    }

    public void addDamageReduction(String string, String string2, int n) {
        this.addDamageResistanceBonus(string, Bonus.Type.DamageReduction, Bonus.parseStackType(string2 + "Bonus"), n);
    }

    public void addDamageImmunity(String string, int n) {
        this.addDamageResistanceBonus(string, Bonus.Type.DamageImmunity, Bonus.StackType.GenericBonus, n);
    }

    public void addDamageImmunity(String string, String string2, int n) {
        this.addDamageResistanceBonus(string, Bonus.Type.DamageImmunity, Bonus.parseStackType(string2 + "Bonus"), n);
    }

    public void addDamageVulnerability(String string, int n) {
        this.addDamageResistanceBonus(string, Bonus.Type.DamageImmunity, Bonus.StackType.GenericPenalty, n);
    }

    public void addDamageVulnerability(String string, String string2, int n) {
        this.addDamageResistanceBonus(string, Bonus.Type.DamageImmunity, Bonus.parseStackType(string2 + "Bonus"), n);
    }

    public void addWeaponProficiency(String string) {
        this.bonuses.add(new WeaponProficiency(string));
    }

    public void addBaseWeaponBonus(String string, String string2, String string3, int n) {
        this.addBaseWeaponBonus(string, string2, Bonus.parseStackType(string3 + "Bonus"), n);
    }

    public void addBaseWeaponBonus(String string, String string2, int n) {
        this.addBaseWeaponBonus(string, string2, Bonus.StackType.GenericBonus, n);
    }

    public void addBaseWeaponPenalty(String string, String string2, String string3, int n) {
        this.addBaseWeaponBonus(string, string2, Bonus.parseStackType(string3 + "Penalty"), n);
    }

    public void addBaseWeaponPenalty(String string, String string2, int n) {
        this.addBaseWeaponBonus(string, string2, Bonus.StackType.GenericPenalty, n);
    }

    private void addBaseWeaponBonus(String string, String string2, Bonus.StackType stackType, int n) {
        this.bonuses.add(new BaseWeaponBonus(string, Bonus.parseType("BaseWeapon" + string2), stackType, n));
    }

    public void addArmorProficiency(String string) {
        this.bonuses.add(new ArmorProficiency(string));
    }

    public void addArmorBonus(String string, String string2, String string3, int n) {
        this.addArmorBonus(string, string2, Bonus.parseStackType(string3 + "Bonus"), n);
    }

    public void addArmorBonus(String string, String string2, int n) {
        this.addArmorBonus(string, string2, Bonus.StackType.GenericBonus, n);
    }

    private void addArmorBonus(String string, String string2, Bonus.StackType stackType, int n) {
        this.bonuses.add(new ArmorTypeBonus(string, Bonus.parseType("ArmorType" + string2), stackType, n));
    }

    private void addSkillBonus(String string, Bonus.StackType stackType, int n) {
        this.bonuses.add(new SkillBonus(string, stackType, n));
    }

    public void addSkillPenalty(String string, int n) {
        this.addSkillBonus(string, Bonus.StackType.GenericPenalty, n);
    }

    public void addSkillPenalty(String string, String string2, int n) {
        this.addSkillBonus(string, Bonus.parseStackType(string2 + "Penalty"), n);
    }

    public void addSkillBonus(String string, String string2, int n) {
        this.addSkillBonus(string, Bonus.parseStackType(string2 + "Bonus"), n);
    }

    public void addSkillBonus(String string, int n) {
        this.addSkillBonus(string, Bonus.StackType.GenericBonus, n);
    }

    public void add(String string) {
        this.bonuses.add(new Bonus(Bonus.parseType(string), Bonus.StackType.GenericBonus));
    }

    private void add(Bonus.Type type, Bonus.StackType stackType, int n) {
        this.bonuses.add(new IntBonus(type, stackType, n));
    }

    public void addBonus(String string, String string2, int n) {
        this.add(Bonus.parseType(string), Bonus.parseStackType(string2 + "Bonus"), n);
    }

    public void addBonus(String string, int n) {
        this.add(Bonus.parseType(string), Bonus.StackType.GenericBonus, n);
    }

    public void addPenalty(String string, int n) {
        this.add(Bonus.parseType(string), Bonus.StackType.GenericPenalty, n);
    }

    public void addPenalty(String string, String string2, int n) {
        this.add(Bonus.parseType(string), Bonus.parseStackType(string2 + "Penalty"), n);
    }

    public boolean hasBonus(Bonus bonus) {
        return this.bonuses.contains(bonus);
    }

    public boolean hasBonusOfType(String string) {
        return this.hasBonusOfType(Bonus.Type.valueOf(string));
    }

    public boolean hasBonusOfType(Bonus.Type type) {
        for (Bonus bonus : this.bonuses) {
            if (bonus.getType() != type) continue;
            return true;
        }
        return false;
    }

    public Bonus getBonusOfType(String string) {
        return this.getBonusOfType(Bonus.Type.valueOf(string));
    }

    public Bonus getBonusOfType(Bonus.Type type) {
        for (Bonus bonus : this.bonuses) {
            if (bonus.getType() != type) continue;
            return bonus;
        }
        return null;
    }

    public List<Bonus> getBonusesOfType(Bonus.Type ... typeArray) {
        ArrayList<Bonus> arrayList = new ArrayList<Bonus>();
        for (Bonus bonus : this.bonuses) {
            for (Bonus.Type type : typeArray) {
                if (bonus.getType() != type) continue;
                arrayList.add(bonus);
            }
        }
        return arrayList;
    }

    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Bonus bonus : this.bonuses) {
            stringBuilder.append("<p>");
            bonus.appendDescription(stringBuilder);
            stringBuilder.append("</p>");
        }
        return stringBuilder.toString();
    }

    public int size() {
        return this.bonuses.size();
    }

    @Override
    public Iterator<Bonus> iterator() {
        return new BonusIterator();
    }

    private class BonusIterator
    implements Iterator<Bonus> {
        private int numLeft;

        private BonusIterator() {
            this.numLeft = BonusList.this.bonuses.size();
        }

        @Override
        public boolean hasNext() {
            return this.numLeft > 0;
        }

        @Override
        public Bonus next() {
            try {
                int n = BonusList.this.bonuses.size() - this.numLeft;
                Bonus bonus = (Bonus)BonusList.this.bonuses.get(n);
                --this.numLeft;
                return bonus;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

