/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.bonus;

import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONObject;

public class Bonus
implements Saveable {
    private final Type type;
    private final StackType stackType;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("class", this.getClass().getName());
        jSONOrderedObject.put("type", this.type.toString());
        jSONOrderedObject.put("stackType", this.stackType.toString());
        return jSONOrderedObject;
    }

    public static Bonus load(SimpleJSONObject simpleJSONObject) {
        Type type = Type.valueOf(simpleJSONObject.get("type", null));
        StackType stackType = StackType.valueOf(simpleJSONObject.get("stackType", null));
        return new Bonus(type, stackType);
    }

    public Bonus(Type type, StackType stackType) {
        this.type = type;
        this.stackType = stackType;
    }

    public boolean hasValue() {
        return false;
    }

    public int getValue() {
        return 0;
    }

    public Type getType() {
        return this.type;
    }

    public StackType getStackType() {
        return this.stackType;
    }

    public static Type parseType(String string) {
        Type type = Type.valueOf(string);
        if (type == null) {
            Logger.appendToErrorLog("Bonus type " + string + " not found.");
        }
        return type;
    }

    public static StackType parseStackType(String string) {
        StackType stackType = StackType.valueOf(string);
        if (stackType == null) {
            Logger.appendToErrorLog("Bonus stack type " + string + " not found.");
            return StackType.GenericBonus;
        }
        return stackType;
    }

    public Bonus cloneWithReduction(int n) {
        return new Bonus(this.type, this.stackType);
    }

    public void appendDescription(StringBuilder stringBuilder) {
        stringBuilder.append(this.type.name);
    }

    public static enum StackType {
        StackableBonus,
        StackablePenalty,
        GenericBonus,
        MoraleBonus,
        DeflectionBonus,
        NaturalArmorBonus,
        ArmorBonus,
        ShieldBonus,
        GenericPenalty,
        MoralePenalty,
        DeflectionPenalty,
        NaturalArmorPenalty,
        ArmorPenalty,
        ShieldPenalty,
        EnhancementBonus,
        EnhancementPenalty,
        LuckBonus,
        LuckPenalty;

    }

    public static enum Type {
        DualWieldTraining("Dual Wield Training"),
        Immobilized,
        Helpless,
        Hidden,
        Blind,
        Deaf,
        Silence,
        CriticalHitImmunity("Critical Hit Immunity"),
        LockPicking("Lock Picking"),
        TrapHandling("Trap Handling"),
        AoOFromRangedImmunity("AoO From Ranged Immunity"),
        ImmobilizationImmunity("Immobilization Immunity"),
        UndispellableImmobilized("Immobilized"),
        UndispellableHelpless("Helpless"),
        StandaloneDamage("Standalone Damage"),
        WeaponAttack("Attack"),
        WeaponDamage("Damage"),
        WeaponCriticalChance("Critical Chance"),
        WeaponCriticalMultiplier("Critical Multiplier"),
        AttackVsRacialType("Attack"),
        DamageVsRacialType("Damage"),
        ArmorClassVsRacialType("Defense"),
        ArmorTypeMovementPenalty("Movement Penalty"),
        ArmorTypeArmorPenalty("Armor Penalty"),
        ArmorTypeArmorClass("Defense"),
        BaseWeaponAttack("Attack"),
        BaseWeaponDamage("Damage"),
        BaseWeaponSpeed("Speed"),
        BaseWeaponCriticalChance("Critical Chance"),
        BaseWeaponCriticalMultiplier("Critical Multiplier"),
        Skill(""),
        ArmorProficiency("Proficiency"),
        WeaponProficiency("Proficiency"),
        DamageImmunity("Damage Immunity"),
        DamageReduction("Damage Reduction"),
        AttackForWeaponType("Weapon Attack"),
        DamageForWeaponType("Weapon Damage"),
        DamageForSpellType("Spell Damage"),
        BaseStr("Base Strength"),
        BaseDex("Base Dexterity"),
        BaseCon("Base Constitution"),
        BaseInt("Base Intelligence"),
        BaseWis("Base Wisdom"),
        BaseCha("Base Charisma"),
        Str("Strength"),
        Dex("Dexterity"),
        Con("Constitution"),
        Int("Intelligence"),
        Wis("Wisdom"),
        Cha("Charisma"),
        Initiative,
        AttacksOfOpportunity("Attacks of Opportunity"),
        MentalResistance("Mental Resistance"),
        PhysicalResistance("Physical Resistance"),
        ReflexResistance("Reflex Resistance"),
        SpellDamage("Spell Damage"),
        SpellHealing("Spell Healing"),
        SpellDuration("Spell Duration"),
        SpellResistance("Spell Resistance"),
        ArmorSpellFailure("Spell Failure due to Armor"),
        VerbalSpellFailure("Verbal Spell Failure"),
        SpellFailure("Spell Success"),
        MeleeSpellFailure("Spell Success due to Threatening Creatures"),
        SpellCooldown("Spell Cooldown"),
        Attack,
        Damage,
        AttackCost("Attack Cost"),
        ArmorClass("Defense"),
        ArmorPenalty("Armor Penalty"),
        ShieldAttack("Attack while using a Shield"),
        LightMeleeWeaponDamage("Light Melee Weapon Damage"),
        OneHandedMeleeWeaponDamage("One Handed Melee Weapon Damage"),
        TwoHandedMeleeWeaponDamage("Two Handed Melee Weapon Damage"),
        RangedDamage("Ranged Damage"),
        LightMeleeWeaponAttack("Light Melee Weapon Attack"),
        OneHandedMeleeWeaponAttack("One Handed Melee Weapon Attack"),
        TwoHandedMeleeWeaponAttack("Two Handed Melee Weapon Attack"),
        RangedAttack("Ranged Attack"),
        MainHandAttack("Main Hand Attack"),
        OffHandAttack("Off Hand Attack"),
        MainHandDamage("Main Hand Damage"),
        OffHandDamage("Off Hand Damage"),
        DualWieldAttack("Attack while Dual Wielding"),
        DualWieldStrDamage("Damage Bonus due to Strength while Dual Wielding"),
        DualWieldArmorClass("Defense while Dual Wielding"),
        Concealment,
        ConcealmentIgnoring("Ignore Concealment on Others"),
        ConcealmentIgnoringRanged("Ignore Concealment on Others with Ranged Weapons"),
        ConcealmentNegation("Concealment Negated"),
        Movement,
        RangePenalty("Range Penalty"),
        WeightLimit("Weight Limit"),
        TemporaryHP("Temporary Hit Points"),
        ActionPoint("Action Points"),
        ActionPointEquipHands("Action Points to Wield"),
        FlankingAngle("Flanking Angle");

        public final String name;

        private Type() {
            this.name = this.toString();
        }

        private Type(String string2) {
            this.name = string2;
        }
    }
}

