/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.bonus;

import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.BonusWithSuperType;
import net.sf.hale.bonus.IntBonus;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.util.SimpleJSONObject;

public class BaseWeaponBonus
extends IntBonus
implements BonusWithSuperType {
    private final String baseWeapon;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        jSONOrderedObject.put("baseWeapon", this.baseWeapon);
        return jSONOrderedObject;
    }

    public static BaseWeaponBonus load(SimpleJSONObject simpleJSONObject) {
        int n = simpleJSONObject.get("value", 0);
        Bonus.Type type = Bonus.Type.valueOf(simpleJSONObject.get("type", null));
        Bonus.StackType stackType = Bonus.StackType.valueOf(simpleJSONObject.get("stackType", null));
        String string = simpleJSONObject.get("baseWeapon", null);
        return new BaseWeaponBonus(string, type, stackType, n);
    }

    public BaseWeaponBonus(String string, Bonus.Type type, Bonus.StackType stackType, int n) {
        super(type, stackType, n);
        this.baseWeapon = string;
    }

    public String getBaseWeapon() {
        return this.baseWeapon;
    }

    @Override
    public String getSuperType() {
        return this.baseWeapon;
    }

    @Override
    public BaseWeaponBonus cloneWithReduction(int n) {
        return new BaseWeaponBonus(this.baseWeapon, this.getType(), this.getStackType(), this.getValue() - n);
    }

    @Override
    public void appendDescription(StringBuilder stringBuilder) {
        super.appendDescription(stringBuilder);
        stringBuilder.append(" for ");
        stringBuilder.append("<span style=\"font-family: blue;\">");
        stringBuilder.append(this.baseWeapon);
        stringBuilder.append("</span>");
    }
}

