/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.bonus;

import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.BonusWithSuperType;
import net.sf.hale.bonus.IntBonus;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.util.SimpleJSONObject;

public class ArmorTypeBonus
extends IntBonus
implements BonusWithSuperType {
    private final String armorType;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        jSONOrderedObject.put("armorType", this.armorType);
        return jSONOrderedObject;
    }

    public static ArmorTypeBonus load(SimpleJSONObject simpleJSONObject) {
        int n = simpleJSONObject.get("value", 0);
        Bonus.Type type = Bonus.Type.valueOf(simpleJSONObject.get("type", null));
        Bonus.StackType stackType = Bonus.StackType.valueOf(simpleJSONObject.get("stackType", null));
        String string = simpleJSONObject.get("armorType", null);
        return new ArmorTypeBonus(string, type, stackType, n);
    }

    public ArmorTypeBonus(String string, Bonus.Type type, Bonus.StackType stackType, int n) {
        super(type, stackType, n);
        this.armorType = string;
    }

    public String getArmorType() {
        return this.armorType;
    }

    @Override
    public String getSuperType() {
        return this.armorType;
    }

    @Override
    public ArmorTypeBonus cloneWithReduction(int n) {
        return new ArmorTypeBonus(this.armorType, this.getType(), this.getStackType(), this.getValue() - n);
    }

    @Override
    public void appendDescription(StringBuilder stringBuilder) {
        super.appendDescription(stringBuilder);
        stringBuilder.append(" for ");
        stringBuilder.append("<span style=\"font-family: blue;\">");
        stringBuilder.append(this.armorType);
        stringBuilder.append("</span>");
    }
}

