/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.area;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.ability.Scriptable;
import net.sf.hale.area.Transition;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.Location;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.util.PointImmutable;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class Trigger
implements Saveable {
    private final String id;
    private final Scriptable script;
    private final List<Entity> entitiesCurrentlyInside;
    private boolean enteredByPlayer;
    private boolean areaLoaded;
    private final int pointsOffsetX;
    private final int pointsOffsetY;
    private final boolean[][] pointsArray;

    @Override
    public Object save() {
        if (!this.areaLoaded && !this.enteredByPlayer) {
            return null;
        }
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("id", this.id);
        if (this.areaLoaded) {
            jSONOrderedObject.put("areaLoaded", this.areaLoaded);
        }
        if (this.enteredByPlayer) {
            jSONOrderedObject.put("enteredByPlayer", this.enteredByPlayer);
        }
        return jSONOrderedObject;
    }

    public void load(SimpleJSONObject simpleJSONObject) {
        this.areaLoaded = simpleJSONObject.containsKey("areaLoaded") ? simpleJSONObject.get("areaLoaded", false) : false;
        this.enteredByPlayer = simpleJSONObject.containsKey("enteredByPlayer") ? simpleJSONObject.get("enteredByPlayer", false) : false;
    }

    public Trigger(String string, SimpleJSONObject simpleJSONObject) {
        this.id = string;
        String string2 = simpleJSONObject.get("script", null);
        String string3 = ResourceManager.getScriptResourceAsString(string2);
        this.script = new Scriptable(string3, string2, false);
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        ArrayList<PointImmutable> arrayList = new ArrayList<PointImmutable>();
        if (simpleJSONObject.containsKey("points")) {
            SimpleJSONArray simpleJSONArray = simpleJSONObject.getArray("points");
            for (SimpleJSONArrayEntry object : simpleJSONArray) {
                SimpleJSONArray simpleJSONArray2 = object.getArray();
                Iterator<SimpleJSONArrayEntry> iterator = simpleJSONArray2.iterator();
                int n5 = iterator.next().getInt(0);
                int n6 = iterator.next().getInt(0);
                if (n5 < n) {
                    n = n5;
                }
                if (n5 > n3) {
                    n3 = n5;
                }
                if (n6 < n2) {
                    n2 = n6;
                }
                if (n6 > n4) {
                    n4 = n6;
                }
                arrayList.add(new PointImmutable(n5, n6));
            }
            this.pointsOffsetX = n;
            this.pointsOffsetY = n2;
            this.pointsArray = new boolean[n3 - n + 1][n4 - n2 + 1];
            for (PointImmutable pointImmutable : arrayList) {
                this.pointsArray[pointImmutable.x - this.pointsOffsetX][pointImmutable.y - this.pointsOffsetY] = true;
            }
        } else {
            this.pointsOffsetX = Integer.MAX_VALUE;
            this.pointsOffsetY = Integer.MAX_VALUE;
            this.pointsArray = null;
        }
        this.entitiesCurrentlyInside = new ArrayList<Entity>();
    }

    public String getID() {
        return this.id;
    }

    public void checkOnAreaLoad(Transition transition) {
        if (!this.areaLoaded) {
            this.script.executeFunction(ScriptFunctionType.onAreaLoadFirstTime, Game.curCampaign.curArea, transition);
            this.areaLoaded = true;
        }
        this.script.executeFunction(ScriptFunctionType.onAreaLoad, Game.curCampaign.curArea, transition);
    }

    public void checkOnAreaExit(Transition transition) {
        this.script.executeFunction(ScriptFunctionType.onAreaExit, Game.curCampaign.curArea, transition);
    }

    public void checkPlayerMoved(Entity entity) {
        if (!this.enteredByPlayer) {
            this.checkPlayerEnterFirstTime(entity);
        }
        this.checkPlayerEnter(entity);
        this.checkPlayerExit(entity);
    }

    public boolean containsPoint(Location location) {
        int n = location.getX();
        int n2 = location.getY();
        if (n < this.pointsOffsetX) {
            return false;
        }
        if (n2 < this.pointsOffsetY) {
            return false;
        }
        if (n >= this.pointsOffsetX + this.pointsArray.length) {
            return false;
        }
        if (n2 >= this.pointsOffsetY + this.pointsArray[0].length) {
            return false;
        }
        return this.pointsArray[n - this.pointsOffsetX][n2 - this.pointsOffsetY];
    }

    private void checkPlayerEnterFirstTime(Entity entity) {
        if (!this.containsPoint(entity.getLocation())) {
            return;
        }
        this.script.executeFunction(ScriptFunctionType.onPlayerEnterFirstTime, entity, this);
        this.enteredByPlayer = true;
    }

    private void checkPlayerEnter(Entity entity) {
        if (this.entitiesCurrentlyInside.contains(entity)) {
            return;
        }
        if (!this.containsPoint(entity.getLocation())) {
            return;
        }
        this.entitiesCurrentlyInside.add(entity);
        this.script.executeFunction(ScriptFunctionType.onPlayerEnter, entity, this);
    }

    private void checkPlayerExit(Entity entity) {
        if (!this.entitiesCurrentlyInside.contains(entity)) {
            return;
        }
        if (this.containsPoint(entity.getLocation())) {
            return;
        }
        this.entitiesCurrentlyInside.remove(entity);
        this.script.executeFunction(ScriptFunctionType.onPlayerExit, entity, this);
    }
}

