/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.area;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.area.Area;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.util.PointImmutable;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;

public class Transition
implements Saveable {
    private final String id;
    private final Icon icon;
    private final boolean isTwoWay;
    private final boolean isInitiallyActivated;
    private final String worldMapLocation;
    private final EndPoint from;
    private final EndPoint to;
    private boolean isActivated;

    @Override
    public Object save() {
        if (this.isInitiallyActivated == this.isActivated) {
            return null;
        }
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("name", this.id);
        jSONOrderedObject.put("activated", this.isActivated);
        return jSONOrderedObject;
    }

    public void load(SimpleJSONObject simpleJSONObject) {
        this.isActivated = simpleJSONObject.get("activated", false);
    }

    public Transition(String string) {
        this.id = string;
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser("transitions/" + string + ResourceType.JSON.getExtension());
        this.isInitiallyActivated = simpleJSONParser.get("isInitiallyActivated", true);
        this.isTwoWay = simpleJSONParser.get("isTwoWay", true);
        this.worldMapLocation = simpleJSONParser.get("worldMapLocation", null);
        this.icon = simpleJSONParser.containsKey("icon") ? IconFactory.createIcon(simpleJSONParser.getObject("icon")) : IconFactory.emptyIcon;
        this.from = this.parseEndPoint(simpleJSONParser.getObject("from"));
        this.to = this.parseEndPoint(simpleJSONParser.getObject("to"));
        simpleJSONParser.warnOnUnusedKeys();
        this.isActivated = this.isInitiallyActivated;
    }

    public EndPoint getEndPointForWorldMap() {
        if (this.from.isWorldMap()) {
            return this.to;
        }
        if (this.to.isWorldMap()) {
            return this.from;
        }
        return null;
    }

    public EndPoint getEndPointForCreaturesInCurrentArea() {
        if (Game.curCampaign.curArea.getID().equals(this.to.getAreaID())) {
            return this.from;
        }
        if (Game.curCampaign.curArea.getID().equals(this.from.getAreaID())) {
            return this.to;
        }
        return null;
    }

    public EndPoint getEndPointInArea(Area area) {
        if (area.getID().equals(this.to.getAreaID())) {
            return this.to;
        }
        if (area.getID().equals(this.from.getAreaID())) {
            return this.from;
        }
        return null;
    }

    public boolean isFromArea(Area area) {
        return area.getID().equals(this.from.getAreaID());
    }

    public boolean isToArea(Area area) {
        return area.getID().equals(this.to.getAreaID());
    }

    public String getWorldMapLocation() {
        return this.worldMapLocation;
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public void activate() {
        this.isActivated = true;
    }

    public boolean isTwoWay() {
        return this.isTwoWay;
    }

    public String getID() {
        return this.id;
    }

    public Icon getIcon() {
        return this.icon;
    }

    private EndPoint parseEndPoint(SimpleJSONObject simpleJSONObject) {
        boolean bl = simpleJSONObject.containsKey("worldMap") ? simpleJSONObject.get("worldMap", false) : false;
        if (bl) {
            return new WorldMapEndPoint();
        }
        String string = simpleJSONObject.get("area", null);
        int n = simpleJSONObject.get("x", 0);
        int n2 = simpleJSONObject.get("y", 0);
        ArrayList<PointImmutable> arrayList = new ArrayList<PointImmutable>();
        SimpleJSONArray simpleJSONArray = simpleJSONObject.getArray("partyPositions");
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
            SimpleJSONArray simpleJSONArray2 = simpleJSONArrayEntry.getArray();
            Iterator<SimpleJSONArrayEntry> iterator = simpleJSONArray2.iterator();
            int n3 = iterator.next().getInt(0);
            int n4 = iterator.next().getInt(0);
            int n5 = n3 + n;
            int n6 = n4 + n2;
            if (n3 % 2 != 0 && n % 2 != 0) {
                ++n6;
            }
            PointImmutable pointImmutable = new PointImmutable(n5, n6);
            arrayList.add(pointImmutable);
        }
        arrayList.trimToSize();
        return new AreaEndPoint(string, n, n2, arrayList);
    }

    private class AreaEndPoint
    implements EndPoint {
        private final String areaID;
        private final int x;
        private final int y;
        private final List<PointImmutable> partyPositions;

        private AreaEndPoint(String string, int n, int n2, List<PointImmutable> list) {
            this.areaID = string;
            this.x = n;
            this.y = n2;
            this.partyPositions = Collections.unmodifiableList(list);
        }

        @Override
        public boolean isWorldMap() {
            return false;
        }

        @Override
        public String getAreaID() {
            return this.areaID;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public Iterator<PointImmutable> getPartyPositionsIterator() {
            return this.partyPositions.iterator();
        }
    }

    private class WorldMapEndPoint
    implements EndPoint {
        private WorldMapEndPoint() {
        }

        @Override
        public boolean isWorldMap() {
            return true;
        }

        @Override
        public String getAreaID() {
            return null;
        }

        @Override
        public int getX() {
            return -1;
        }

        @Override
        public int getY() {
            return -1;
        }

        @Override
        public Iterator<PointImmutable> getPartyPositionsIterator() {
            throw new UnsupportedOperationException("Cannot iterate over party positions in a world map end point");
        }
    }

    public static interface EndPoint {
        public boolean isWorldMap();

        public String getAreaID();

        public int getX();

        public int getY();

        public Iterator<PointImmutable> getPartyPositionsIterator();
    }
}

