/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.area;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.hale.area.Area;
import net.sf.hale.entity.Container;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Door;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.NPC;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.PCTemplate;
import net.sf.hale.entity.Trap;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.loading.Saveable;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class AreaEntityList
implements Saveable,
Iterable<Entity> {
    private EntityList[][] entities;
    private Set<Entity> entitiesSet;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        JSONOrderedObject[] jSONOrderedObjectArray = new JSONOrderedObject[this.entitiesSet.size()];
        int n = 0;
        for (Entity entity : this.entitiesSet) {
            jSONOrderedObjectArray[n] = entity.save();
            ++n;
        }
        jSONOrderedObject.put("entities", jSONOrderedObjectArray);
        return jSONOrderedObject;
    }

    private Entity createEntity(SimpleJSONObject simpleJSONObject) {
        String string = simpleJSONObject.get("id", null);
        ClassType classType = ClassType.valueOf(simpleJSONObject.get("class", null));
        switch (classType) {
            case PC: {
                PCTemplate pCTemplate = new PCTemplate(string, simpleJSONObject);
                return new PC(pCTemplate);
            }
            case NPC: {
                NPC nPC = EntityManager.getNPC(string);
                nPC.abilities.clear();
                return nPC;
            }
            case Container: {
                return EntityManager.getContainer(string);
            }
            case Door: {
                return EntityManager.getDoor(string);
            }
        }
        return EntityManager.getItem(string);
    }

    public void load(SimpleJSONObject simpleJSONObject, Area area, ReferenceHandler referenceHandler) throws LoadGameException {
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("entities")) {
            SimpleJSONObject simpleJSONObject2 = simpleJSONArrayEntry.getObject();
            Entity entity = this.createEntity(simpleJSONObject2);
            entity.load(simpleJSONObject2, area, referenceHandler);
            if (entity instanceof Container) {
                this.addContainer((Container)entity);
            } else if (entity instanceof Trap) {
                this.addTrap((Trap)entity);
            }
            this.addEntity(entity);
            if (!(entity instanceof PC)) continue;
            EntityManager.addLoadedPC(new PC((PC)entity));
        }
    }

    public AreaEntityList(int n, int n2) {
        this.entities = new EntityList[n][n2];
        this.entitiesSet = new LinkedHashSet<Entity>();
    }

    public final boolean containsEntity(Entity entity) {
        return this.entitiesSet.contains(entity);
    }

    public synchronized void addTrap(Trap trap) {
        if (this.entitiesSet.contains(trap)) {
            return;
        }
        this.addTrapAt(trap.getLocation().getX(), trap.getLocation().getY(), trap);
        this.entitiesSet.add(trap);
    }

    public synchronized void addContainer(Container container) {
        if (this.entitiesSet.contains(container)) {
            return;
        }
        this.addContainerAt(container.getLocation().getX(), container.getLocation().getY(), container);
        this.entitiesSet.add(container);
    }

    public synchronized void addEntity(Entity entity) {
        if (this.entitiesSet.contains(entity)) {
            return;
        }
        this.addAt(entity.getLocation().getX(), entity.getLocation().getY(), entity);
        this.entitiesSet.add(entity);
    }

    private void setMatrix(boolean[][] blArray, boolean bl, int n, int n2) {
        if (n >= 0 && n2 >= 0 && n < blArray.length && n2 < blArray[0].length) {
            blArray[n][n2] = bl;
        }
    }

    public synchronized boolean[][] getDoorPassabilities(Creature creature) {
        boolean[][] blArray = new boolean[this.entities.length][this.entities[0].length];
        AreaUtil.setMatrix(blArray, true);
        for (Entity entity : this.entitiesSet) {
            if (!(entity instanceof Door) || ((Door)entity).isOpen()) continue;
            this.setMatrix(blArray, false, entity.getLocation().getX(), entity.getLocation().getY());
        }
        return blArray;
    }

    public synchronized boolean[][] getEntityPassabilities(Creature creature) {
        boolean[][] blArray = new boolean[this.entities.length][this.entities[0].length];
        AreaUtil.setMatrix(blArray, true);
        for (Entity entity : this.entitiesSet) {
            if (entity instanceof Door) {
                if (((Door)entity).isOpen()) continue;
                this.setMatrix(blArray, false, entity.getLocation().getX(), entity.getLocation().getY());
                continue;
            }
            if (!(entity instanceof Creature) || entity.getFaction().isFriendly(creature) || ((Creature)entity).stats.isHelpless()) continue;
            this.setMatrix(blArray, false, entity.getLocation().getX(), entity.getLocation().getY());
        }
        return blArray;
    }

    public void startEffectAnimations() {
        for (Entity entity : this.entitiesSet) {
            entity.getEffects().startAnimations();
        }
    }

    public synchronized void removeEntity(Entity entity) {
        Creature creature;
        if (!this.entitiesSet.contains(entity)) {
            return;
        }
        this.removeAt(entity.getLocation().getX(), entity.getLocation().getY(), entity);
        this.entitiesSet.remove(entity);
        if (entity instanceof Creature && (creature = (Creature)entity).getEncounter() != null) {
            creature.getEncounter().removeCreatureFromArea(creature);
        }
    }

    private void addTrapAt(int n, int n2, Trap trap) {
        if (n < 0 || n >= this.entities.length || n2 < 0 || n2 >= this.entities[0].length) {
            return;
        }
        if (this.entities[n][n2] == null) {
            this.entities[n][n2] = new EntityList();
        }
        this.entities[n][n2].add(0, trap);
    }

    private void addContainerAt(int n, int n2, Container container) {
        int n3;
        if (n < 0 || n >= this.entities.length || n2 < 0 || n2 >= this.entities[0].length) {
            return;
        }
        if (this.entities[n][n2] == null) {
            this.entities[n][n2] = new EntityList();
        }
        for (n3 = 0; n3 < this.entities[n][n2].size() && this.entities[n][n2].get(n3) instanceof Trap; ++n3) {
        }
        this.entities[n][n2].add(n3, container);
    }

    private void addAt(int n, int n2, Entity entity) {
        if (n < 0 || n >= this.entities.length || n2 < 0 || n2 >= this.entities[0].length) {
            return;
        }
        if (this.entities[n][n2] == null) {
            this.entities[n][n2] = new EntityList();
        }
        this.entities[n][n2].add(entity);
    }

    private void removeAt(int n, int n2, Entity entity) {
        if (n < 0 || n >= this.entities.length || n2 < 0 || n2 >= this.entities[0].length) {
            return;
        }
        if (this.entities[n][n2] == null) {
            return;
        }
        this.entities[n][n2].remove(entity);
        if (this.entities[n][n2].size() == 0) {
            this.entities[n][n2] = null;
        }
    }

    public void moveEntity(Entity entity, Location location) {
        if (!this.entitiesSet.contains(entity)) {
            return;
        }
        this.removeAt(location.getX(), location.getY(), entity);
        this.addAt(entity.getLocation().getX(), entity.getLocation().getY(), entity);
    }

    public List<Entity> getEntitiesWithID(String string) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        for (Entity entity : this.entitiesSet) {
            if (!entity.getTemplate().getID().equals(string)) continue;
            arrayList.add(entity);
        }
        return arrayList;
    }

    public Entity getEntityWithID(String string) {
        for (Entity entity : this.entitiesSet) {
            if (!entity.getTemplate().getID().equals(string)) continue;
            return entity;
        }
        return null;
    }

    public final Door getDoor(int n, int n2) {
        if (this.entities[n][n2] == null) {
            return null;
        }
        for (Entity entity : this.entities[n][n2]) {
            if (!(entity instanceof Door)) continue;
            return (Door)entity;
        }
        return null;
    }

    public final Trap getTrap(int n, int n2) {
        if (this.entities[n][n2] == null) {
            return null;
        }
        for (Entity entity : this.entities[n][n2]) {
            if (!(entity instanceof Trap)) continue;
            return (Trap)entity;
        }
        return null;
    }

    public final Container getContainer(int n, int n2) {
        if (this.entities[n][n2] == null) {
            return null;
        }
        for (Entity entity : this.entities[n][n2]) {
            if (!(entity instanceof Container)) continue;
            return (Container)entity;
        }
        return null;
    }

    public final Creature getCreature(int n, int n2) {
        if (this.entities[n][n2] == null) {
            return null;
        }
        for (Entity entity : this.entities[n][n2]) {
            if (!(entity instanceof Creature)) continue;
            return (Creature)entity;
        }
        return null;
    }

    public final List<Creature> getCreatures(int n, int n2) {
        if (this.entities[n][n2] == null) {
            return new ArrayList<Creature>(0);
        }
        ArrayList<Creature> arrayList = new ArrayList<Creature>();
        for (Entity entity : this.entities[n][n2]) {
            if (!(entity instanceof Creature)) continue;
            arrayList.add((Creature)entity);
        }
        return arrayList;
    }

    public final List<Entity> getEntities(int n, int n2) {
        if (n < 0 || n >= this.entities.length || n2 < 0 || n2 >= this.entities[0].length) {
            return new ArrayList<Entity>(0);
        }
        if (this.entities[n][n2] == null) {
            return new ArrayList<Entity>(0);
        }
        ArrayList<Entity> arrayList = new ArrayList<Entity>(this.entities[n][n2].size());
        for (Entity entity : this.entities[n][n2]) {
            arrayList.add(entity);
        }
        return arrayList;
    }

    public final Collection<Entity> getEntitiesSet(int n, int n2) {
        return this.entities[n][n2];
    }

    public List<Trap> getVisibleTraps(boolean[][] blArray) {
        LinkedList<Trap> linkedList = new LinkedList<Trap>();
        for (int i = 0; i < this.entities.length; ++i) {
            for (int j = 0; j < this.entities[0].length; ++j) {
                Trap trap;
                if (!blArray[i][j] || (trap = this.getTrap(i, j)) == null) continue;
                linkedList.add(trap);
            }
        }
        return linkedList;
    }

    public List<Creature> getVisibleCreatures(boolean[][] blArray) {
        LinkedList<Creature> linkedList = new LinkedList<Creature>();
        for (int i = 0; i < this.entities.length; ++i) {
            for (int j = 0; j < this.entities[0].length; ++j) {
                Creature creature;
                if (!blArray[i][j] || (creature = this.getCreature(i, j)) == null) continue;
                linkedList.add(creature);
            }
        }
        return linkedList;
    }

    public List<Creature> getVisibleCreatures(Creature creature) {
        ArrayList<Creature> arrayList = new ArrayList<Creature>();
        for (int i = 0; i < this.entities.length; ++i) {
            for (int j = 0; j < this.entities[0].length; ++j) {
                Creature creature2;
                if (!creature.hasVisibilityInCurrentArea(i, j) || (creature2 = this.getCreature(i, j)) == null) continue;
                arrayList.add(creature2);
            }
        }
        return arrayList;
    }

    public List<Creature> getCreaturesWithinRadius(int n, int n2, int n3) {
        LinkedList<Creature> linkedList = new LinkedList<Creature>();
        Creature creature = this.getCreature(n, n2);
        if (creature != null) {
            linkedList.add(creature);
        }
        for (int i = 1; i <= n3; ++i) {
            for (int j = 0; j < 6 * i; ++j) {
                Point point = AreaUtil.convertPolarToGrid(n, n2, i, j);
                if (point.x < 0 || point.x >= this.entities.length || point.y < 0 || point.y >= this.entities[0].length || (creature = this.getCreature(point.x, point.y)) == null) continue;
                linkedList.add(creature);
            }
        }
        return linkedList;
    }

    public int getNumberOfCreatures(int n, int n2) {
        if (n < 0 || n >= this.entities.length || n2 < 0 || n2 >= this.entities[0].length) {
            return 0;
        }
        if (this.entities[n][n2] == null) {
            return 0;
        }
        int n3 = 0;
        for (Entity entity : this.entities[n][n2]) {
            if (!(entity instanceof Creature)) continue;
            ++n3;
        }
        return n3;
    }

    public void resize(int n, int n2) {
        EntityList[][] entityListArray = new EntityList[n][n2];
        HashSet<Entity> hashSet = new HashSet<Entity>();
        int n3 = Math.min(this.entities.length, n);
        int n4 = Math.min(this.entities[0].length, n2);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                entityListArray[i][j] = this.entities[i][j];
                if (this.entities[i][j] == null) continue;
                hashSet.addAll(this.entities[i][j]);
            }
        }
        this.entities = entityListArray;
        this.entitiesSet = hashSet;
    }

    @Override
    public Iterator<Entity> iterator() {
        return new EntityIterator();
    }

    private class EntityList
    extends ArrayList<Entity> {
        private static final long serialVersionUID = 7587119408526288199L;

        private EntityList() {
            super(2);
        }
    }

    private class EntityIterator
    implements Iterator<Entity> {
        private Iterator<Entity> hashSetIterator;
        private Entity last;

        private EntityIterator() {
            this.hashSetIterator = AreaEntityList.this.entitiesSet.iterator();
            this.last = null;
        }

        @Override
        public boolean hasNext() {
            return this.hashSetIterator.hasNext();
        }

        @Override
        public Entity next() {
            this.last = this.hashSetIterator.next();
            return this.last;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static enum ClassType {
        PC,
        NPC,
        Container,
        Door,
        Item,
        Trap,
        EquippableItem,
        Ammo,
        Armor,
        Weapon;

    }
}

