/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.area;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hale.AIScriptInterface;
import net.sf.hale.Game;
import net.sf.hale.ability.AreaEffectList;
import net.sf.hale.ability.Aura;
import net.sf.hale.ability.Effect;
import net.sf.hale.ability.EffectTarget;
import net.sf.hale.area.AreaEntityList;
import net.sf.hale.area.Transition;
import net.sf.hale.area.Trigger;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.entity.Container;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Door;
import net.sf.hale.entity.Encounter;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.Openable;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.Trap;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.loading.Saveable;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.tileset.AreaElevationGrid;
import net.sf.hale.tileset.AreaTileGrid;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Logger;
import net.sf.hale.util.Point;
import net.sf.hale.util.PointImmutable;
import net.sf.hale.util.SaveGameUtil;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;

public class Area
implements EffectTarget,
Saveable {
    private final List<String> transitions;
    private final int width;
    private final int height;
    private final int visibilityRadius;
    private final String tileset;
    private final boolean[][] passable;
    private final boolean[][] transparency;
    private final boolean[][] visibility;
    private final AreaElevationGrid elevation;
    private final AreaTileGrid tileGrid;
    private final List<PointImmutable> startLocations;
    private final AreaEntityList entityList;
    private final AreaEffectList effects;
    private final List<Encounter> encounters;
    private final Map<String, Trigger> triggers;
    private final String id;
    private final boolean[][] explored;
    private AreaUtil areaUtil;

    @Override
    public Object save() {
        int n;
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("ref", SaveGameUtil.getRef(this));
        jSONOrderedObject.put("name", this.id);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.explored.length; ++i) {
            for (n = 0; n < this.explored[0].length; ++n) {
                if (!this.explored[i][n]) continue;
                arrayList.add(Integer.toString(i) + ',' + Integer.toString(n));
            }
        }
        jSONOrderedObject.put("explored", arrayList.toArray());
        Object[] objectArray = new Object[this.encounters.size()];
        for (n = 0; n < objectArray.length; ++n) {
            objectArray[n] = this.encounters.get(n).save();
        }
        jSONOrderedObject.put("encounters", objectArray);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (String string : this.triggers.keySet()) {
            Object object = this.triggers.get(string).save();
            if (object == null) continue;
            arrayList2.add(object);
        }
        jSONOrderedObject.put("triggers", arrayList2.toArray());
        if (this.effects.size() > 0) {
            jSONOrderedObject.put("effects", this.effects.save());
        }
        jSONOrderedObject.put("entities", this.entityList.save());
        return jSONOrderedObject;
    }

    public static Area load(SimpleJSONObject simpleJSONObject, ReferenceHandler referenceHandler) throws LoadGameException {
        return new Area(simpleJSONObject.get("name", null), simpleJSONObject, referenceHandler);
    }

    public Area(String string) throws LoadGameException {
        this(string, null, null);
    }

    private Area(String string, SimpleJSONObject simpleJSONObject, ReferenceHandler referenceHandler) throws LoadGameException {
        Object object3;
        Object object2;
        Object object4;
        this.id = string;
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser("areas/" + string + ResourceType.JSON.getExtension());
        this.width = simpleJSONParser.get("width", 0);
        this.height = simpleJSONParser.get("height", 0);
        this.tileset = simpleJSONParser.get("tileset", null);
        this.visibilityRadius = simpleJSONParser.get("visibilityRadius", 0);
        this.explored = new boolean[this.width][this.height];
        this.transparency = new boolean[this.width][this.height];
        this.elevation = new AreaElevationGrid(this.width, this.height);
        this.entityList = new AreaEntityList(this.width, this.height);
        this.effects = new AreaEffectList(this);
        this.tileGrid = new AreaTileGrid(Game.curCampaign.getTileset(this.tileset), this.width, this.height);
        this.passable = new boolean[this.width][this.height];
        this.visibility = new boolean[this.width][this.height];
        if (simpleJSONParser.get("explored", false)) {
            AreaUtil.setMatrix(this.explored, true);
        }
        if (simpleJSONParser.containsKey("startLocations")) {
            this.startLocations = new ArrayList<PointImmutable>();
            object4 = simpleJSONParser.getArray("startLocations");
            Iterator<Object> iterator = ((SimpleJSONArray)object4).iterator();
            while (iterator.hasNext()) {
                SimpleJSONArrayEntry object32 = iterator.next();
                object2 = object32.getArray();
                object3 = ((SimpleJSONArray)object2).iterator();
                int object6 = object3.next().getInt(0);
                int simpleJSONArrayEntry = object3.next().getInt(0);
                this.startLocations.add(new PointImmutable(object6, simpleJSONArrayEntry));
            }
        } else {
            this.startLocations = Collections.emptyList();
        }
        if (simpleJSONParser.containsKey("triggers")) {
            this.triggers = new HashMap<String, Trigger>();
            object4 = simpleJSONParser.getObject("triggers");
            for (String string2 : ((SimpleJSONObject)object4).keySet()) {
                this.triggers.put(string2, new Trigger(string2, ((SimpleJSONObject)object4).getObject(string2)));
            }
        } else {
            this.triggers = Collections.emptyMap();
        }
        SimpleJSONArray simpleJSONArray = simpleJSONParser.getArray("transparencyGrid");
        int n = 0;
        for (Object object3 : simpleJSONArray) {
            SimpleJSONArray simpleJSONArray2 = ((SimpleJSONArrayEntry)object3).getArray();
            int n3 = 0;
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray2) {
                int n2 = simpleJSONArrayEntry.getInt(0);
                this.transparency[n3][n] = n2 == 0;
                ++n3;
            }
            ++n;
        }
        object2 = simpleJSONParser.getArray("passabilityGrid");
        n = 0;
        object3 = ((SimpleJSONArray)object2).iterator();
        while (object3.hasNext()) {
            SimpleJSONArrayEntry simpleJSONArrayEntry = object3.next();
            SimpleJSONArray simpleJSONArray3 = simpleJSONArrayEntry.getArray();
            int n5 = 0;
            for (SimpleJSONArrayEntry simpleJSONArrayEntry2 : simpleJSONArray3) {
                int n3 = simpleJSONArrayEntry2.getInt(0);
                this.passable[n5][n] = n3 == 1;
                ++n5;
            }
            ++n;
        }
        object3 = simpleJSONParser.getArray("elevationGrid");
        n = 0;
        Object object5 = ((SimpleJSONArray)object3).iterator();
        while (object5.hasNext()) {
            SimpleJSONArrayEntry simpleJSONArrayEntry = object5.next();
            SimpleJSONArray simpleJSONArray4 = simpleJSONArrayEntry.getArray();
            int n7 = 0;
            for (SimpleJSONArrayEntry simpleJSONArrayEntry3 : simpleJSONArray4) {
                int n4 = simpleJSONArrayEntry3.getInt(0);
                this.elevation.setElevation(n7, n, (byte)n4);
                ++n7;
            }
            ++n;
        }
        object5 = simpleJSONParser.getObject("layers");
        for (String string3 : ((SimpleJSONObject)object5).keySet()) {
            SimpleJSONObject simpleJSONObject2 = ((SimpleJSONObject)object5).getObject(string3);
            for (String string4 : simpleJSONObject2.keySet()) {
                SimpleJSONArray simpleJSONArray5 = simpleJSONObject2.getArray(string4);
                for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray5) {
                    SimpleJSONArray simpleJSONArray6 = simpleJSONArrayEntry.getArray();
                    Iterator<SimpleJSONArrayEntry> iterator = simpleJSONArray6.iterator();
                    int n5 = iterator.next().getInt(0);
                    int n6 = iterator.next().getInt(0);
                    this.tileGrid.addTile(string4, string3, n5, n6);
                }
            }
        }
        this.encounters = new ArrayList<Encounter>();
        if (simpleJSONObject != null) {
            this.loadFromSavedFile(simpleJSONObject, referenceHandler);
        } else {
            this.loadFromBaseFile(simpleJSONParser);
            simpleJSONParser.warnOnUnusedKeys();
        }
        for (Entity entity : this.entityList) {
            if (!(entity instanceof Door)) continue;
            Door door = (Door)entity;
            if (!door.isTransparent()) {
                this.transparency[door.getLocation().getX()][door.getLocation().getY()] = false;
                continue;
            }
            this.transparency[door.getLocation().getX()][door.getLocation().getY()] = true;
        }
        this.transitions = new ArrayList<String>();
        for (Transition transition : Game.curCampaign.getAreaTransitions()) {
            if (!transition.isFromArea(this) && (!transition.isTwoWay() || !transition.isToArea(this))) continue;
            this.transitions.add(transition.getID());
        }
        if (simpleJSONObject == null) {
            for (Encounter encounter : this.encounters) {
                encounter.checkSpawnCreatures();
            }
        }
    }

    private void loadFromSavedFile(SimpleJSONObject simpleJSONObject, ReferenceHandler referenceHandler) throws LoadGameException {
        Object object;
        Object object2;
        referenceHandler.add(simpleJSONObject.get("ref", null), this);
        SimpleJSONArray simpleJSONArray = simpleJSONObject.getArray("explored");
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
            object2 = simpleJSONArrayEntry.getString();
            object = ((String)object2).split(",");
            if (((String[])object).length != 2) {
                Logger.appendToErrorLog("Error parsing explored entry " + (String)object2);
                continue;
            }
            int n = Integer.parseInt(object[0]);
            int n2 = Integer.parseInt(object[1]);
            this.explored[n][n2] = true;
        }
        this.entityList.load(simpleJSONObject.getObject("entities"), this, referenceHandler);
        if (simpleJSONObject.containsKey("effects")) {
            this.effects.load(simpleJSONObject.getArray("effects"), referenceHandler);
        }
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("encounters")) {
            object2 = simpleJSONArrayEntry.getObject();
            object = Encounter.load((SimpleJSONObject)object2, referenceHandler, this);
            this.encounters.add((Encounter)object);
        }
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("triggers")) {
            object2 = simpleJSONArrayEntry.getObject();
            object = ((SimpleJSONObject)object2).get("id", null);
            this.triggers.get(object).load((SimpleJSONObject)object2);
        }
    }

    private void loadFromBaseFile(SimpleJSONParser simpleJSONParser) {
        Iterator<Object> iterator;
        Object object;
        Object object2;
        Object object3;
        Object object5;
        if (simpleJSONParser.containsKey("encounters")) {
            object5 = simpleJSONParser.getObject("encounters");
            for (String object42 : ((SimpleJSONObject)object5).keySet()) {
                object3 = ((SimpleJSONObject)object5).getArray(object42);
                object2 = ((SimpleJSONArray)object3).iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    SimpleJSONArray simpleJSONArray = ((SimpleJSONArrayEntry)object).getArray();
                    Iterator<SimpleJSONArrayEntry> iterator2 = simpleJSONArray.iterator();
                    int n = iterator2.next().getInt(0);
                    int n2 = iterator2.next().getInt(0);
                    this.encounters.add(Game.curCampaign.getEncounter(object42, new Location(this, n, n2)));
                }
            }
        }
        if (simpleJSONParser.containsKey("containers")) {
            object5 = simpleJSONParser.getArray("containers");
            iterator = ((SimpleJSONArray)object5).iterator();
            while (iterator.hasNext()) {
                SimpleJSONArrayEntry simpleJSONArrayEntry = (SimpleJSONArrayEntry)iterator.next();
                object3 = simpleJSONArrayEntry.getObject();
                object2 = EntityManager.getContainer(((SimpleJSONObject)object3).get("id", null));
                ((Entity)object2).setLocation(this, ((SimpleJSONObject)object3).get("x", 0), ((SimpleJSONObject)object3).get("y", 0));
                this.entityList.addContainer((Container)object2);
            }
        }
        if (simpleJSONParser.containsKey("doors")) {
            object5 = simpleJSONParser.getArray("doors");
            iterator = ((SimpleJSONArray)object5).iterator();
            while (iterator.hasNext()) {
                SimpleJSONArrayEntry simpleJSONArrayEntry = (SimpleJSONArrayEntry)iterator.next();
                object3 = simpleJSONArrayEntry.getObject();
                object2 = EntityManager.getDoor(((SimpleJSONObject)object3).get("id", null));
                ((Entity)object2).setLocation(this, ((SimpleJSONObject)object3).get("x", 0), ((SimpleJSONObject)object3).get("y", 0));
                this.entityList.addEntity((Entity)object2);
            }
        }
        if (simpleJSONParser.containsKey("items")) {
            object5 = simpleJSONParser.getArray("items");
            iterator = ((SimpleJSONArray)object5).iterator();
            while (iterator.hasNext()) {
                SimpleJSONArrayEntry simpleJSONArrayEntry = (SimpleJSONArrayEntry)iterator.next();
                object3 = simpleJSONArrayEntry.getObject();
                int n = ((SimpleJSONObject)object3).get("quantity", 1);
                object = ((SimpleJSONObject)object3).containsKey("quality") ? EntityManager.getItem(((SimpleJSONObject)object3).get("id", null), ((SimpleJSONObject)object3).get("quality", null)) : EntityManager.getItem(((SimpleJSONObject)object3).get("id", null));
                ((Entity)object).setLocation(this, ((SimpleJSONObject)object3).get("x", 0), ((SimpleJSONObject)object3).get("y", 0));
                if (object instanceof Trap) {
                    ((Trap)object).setFaction(Game.ruleset.getFaction("Hostile"));
                    this.placeTrap((Trap)object);
                    continue;
                }
                this.addItem((Item)object, n);
            }
        }
    }

    public AreaUtil getUtil() {
        if (this.areaUtil == null) {
            this.areaUtil = new AreaUtil(this);
        }
        return this.areaUtil;
    }

    public void runOnAreaLoad(Transition transition) {
        for (Trigger trigger : this.triggers.values()) {
            trigger.checkOnAreaLoad(transition);
        }
    }

    public void runOnAreaExit(Transition transition) {
        for (Trigger trigger : this.triggers.values()) {
            trigger.checkOnAreaExit(transition);
        }
    }

    public void checkPlayerMoved(Entity entity) {
        for (Trigger trigger : this.triggers.values()) {
            trigger.checkPlayerMoved(entity);
        }
    }

    public void checkEncounterRespawns() {
        for (Encounter encounter : this.encounters) {
            encounter.checkSpawnCreatures();
        }
    }

    public String getTileset() {
        return this.tileset;
    }

    public String getName() {
        return this.id;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public List<String> getTransitions() {
        return this.transitions;
    }

    public AreaEntityList getEntities() {
        return this.entityList;
    }

    public AreaTileGrid getTileGrid() {
        return this.tileGrid;
    }

    public AreaElevationGrid getElevationGrid() {
        return this.elevation;
    }

    public List<Encounter> getEncounters() {
        return this.encounters;
    }

    public int getVisibilityRadius() {
        return this.visibilityRadius;
    }

    public boolean[][] getExplored() {
        return this.explored;
    }

    public boolean[][] getTransparency() {
        return this.transparency;
    }

    public boolean[][] getPassability() {
        return this.passable;
    }

    public boolean[][] getVisibility() {
        return this.visibility;
    }

    public void applyEffect(Effect effect, List<Point> list) {
        if (!(effect instanceof Aura)) {
            effect.setTarget(this);
        }
        this.effects.add(effect, list);
    }

    @Override
    public int getSpellResistance() {
        return 0;
    }

    @Override
    public void removeEffect(Effect effect) {
        this.effects.remove(effect);
    }

    @Override
    public boolean isValidEffectTarget() {
        return true;
    }

    public List<Creature> getAffectedCreatures(Effect effect) {
        return this.effects.getAffectedCreatures(effect, this.entityList);
    }

    public void startEffectAnimations() {
        this.effects.startAnimations();
        this.entityList.startEffectAnimations();
    }

    public List<Effect> getEffectsAt(int n, int n2) {
        return this.effects.getEffectsAt(n, n2);
    }

    public void moveAura(Aura aura, List<Point> list) {
        this.effects.move(aura, list);
    }

    public int getMovementBonus(Point point) {
        return this.getMovementBonus(point.x, point.y);
    }

    public int getMovementBonus(int n, int n2) {
        return this.effects.getBonusAt(Bonus.Type.Movement, n, n2);
    }

    public boolean isSilenced(int n, int n2) {
        return this.effects.hasBonusAt(Bonus.Type.Silence, n, n2);
    }

    public boolean isSilenced(Point point) {
        return this.isSilenced(point.x, point.y);
    }

    private int getConcealment(Creature creature, Creature creature2, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        Point point = creature.getLocation().getCenteredScreenPoint();
        Point point2 = AreaUtil.convertGridToScreenAndCenter(n, n2);
        if (point.x == point2.x && point.y == point2.y) {
            return 0;
        }
        ArrayList<Point> arrayList = AreaUtil.findIntersectingHexes(point.x, point.y, point2.x, point2.y);
        int n5 = 0;
        for (Point point3 : arrayList) {
            n5 += this.effects.getBonusAt(Bonus.Type.Concealment, point3.x, point3.y);
            n5 -= this.effects.getBonusAt(Bonus.Type.ConcealmentNegation, point3.x, point3.y);
            if (!this.transparency[point3.x][point3.y]) {
                n4 += 15;
                continue;
            }
            Creature creature3 = this.getCreatureAtGridPoint(point3);
            if (creature3 == null || creature3 == creature2) continue;
            n4 += 15;
        }
        n4 = Math.min(n4, 30);
        float f = (float)n5 / (float)arrayList.size();
        n3 = (int)((float)n3 + f * (float)creature.getLocation().getDistance(n, n2));
        int n6 = 0;
        if (creature2 != null) {
            n6 += creature2.stats.get(Bonus.Type.Concealment) - creature2.stats.get(Bonus.Type.ConcealmentNegation);
        }
        if (creature.stats.has(Bonus.Type.Blind)) {
            n6 += 100;
        }
        n6 = Math.min(100, n6);
        int n7 = creature.stats.get(Bonus.Type.ConcealmentIgnoring);
        int n8 = Math.min(100, Math.max(0, n6 - n7));
        n3 = Math.min(100, n3);
        return n3 + n8 + n4;
    }

    public int getConcealment(Creature creature, Point point) {
        Creature creature2 = this.entityList.getCreature(point.x, point.y);
        return this.getConcealment(creature, creature2, point.x, point.y);
    }

    public int getConcealment(Creature creature, Creature creature2) {
        return this.getConcealment(creature, creature2, creature2.getLocation().getX(), creature2.getLocation().getY());
    }

    public boolean[][] getMatrixOfSize() {
        boolean[][] blArray = new boolean[this.width][this.height];
        return blArray;
    }

    public void removeEntity(Entity entity) {
        this.entityList.removeEntity(entity);
    }

    public void placeTrap(Trap trap) {
        this.entityList.addTrap(trap);
    }

    public void addItem(Item item) {
        this.addItem(item, 1);
    }

    public void addItem(Item item, int n) {
        Container container = item.getLocation().getContainer();
        if (container == null) {
            container = EntityManager.getTemporaryContainer();
            container.setLocation(item.getLocation());
            this.entityList.addContainer(container);
        }
        container.getCurrentItems().add(item, n);
    }

    public Transition getTransitionAtGridPoint(Point point) {
        return this.getTransitionAtGridPoint(point.x, point.y);
    }

    public Transition getTransitionAtGridPoint(int n, int n2) {
        for (String string : this.transitions) {
            Transition transition = Game.curCampaign.getAreaTransition(string);
            Transition.EndPoint endPoint = transition.getEndPointInArea(this);
            if (endPoint.getX() != n || endPoint.getY() != n2) continue;
            return transition;
        }
        return null;
    }

    public Openable getOpenableAtGridPoint(Point point) {
        return this.getOpenableAtGridPoint(point.x, point.y);
    }

    public Openable getOpenableAtGridPoint(int n, int n2) {
        Door door = this.getDoorAtGridPoint(n, n2);
        if (door == null) {
            return this.getContainerAtGridPoint(n, n2);
        }
        return door;
    }

    public Door getDoorAtGridPoint(int n, int n2) {
        return this.entityList.getDoor(n, n2);
    }

    public Door getDoorAtGridPoint(Point point) {
        return this.entityList.getDoor(point.x, point.y);
    }

    public Container getContainerAtGridPoint(int n, int n2) {
        return this.entityList.getContainer(n, n2);
    }

    public Container getContainerAtGridPoint(Point point) {
        return this.entityList.getContainer(point.x, point.y);
    }

    public Trap getTrapAtGridPoint(int n, int n2) {
        return this.entityList.getTrap(n, n2);
    }

    public Trap getTrapAtGridPoint(Point point) {
        return this.entityList.getTrap(point.x, point.y);
    }

    public List<Entity> getEntitiesWithID(String string) {
        return this.entityList.getEntitiesWithID(string);
    }

    public Entity getEntityWithID(String string) {
        return this.entityList.getEntityWithID(string);
    }

    public Creature getCreatureAtGridPoint(Point point) {
        return this.entityList.getCreature(point.x, point.y);
    }

    public Creature getCreatureAtGridPoint(int n, int n2) {
        return this.entityList.getCreature(n, n2);
    }

    public boolean[][] getEntityPassabilities(Creature creature) {
        return this.entityList.getEntityPassabilities(creature);
    }

    public List<Entity> getEntitiesAtGridPoint(Point point) {
        return this.getEntitiesAtGridPoint(point.x, point.y);
    }

    public List<Entity> getEntitiesAtGridPoint(int n, int n2) {
        return this.entityList.getEntities(n, n2);
    }

    public final boolean isVisible(Point point) {
        return this.isVisible(point.x, point.y);
    }

    public final boolean isVisible(int n, int n2) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return false;
        }
        return this.visibility[n][n2];
    }

    public final boolean isTransparent(Point point) {
        return this.isTransparent(point.x, point.y);
    }

    public final boolean isTransparent(int n, int n2) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return false;
        }
        return this.transparency[n][n2];
    }

    public boolean[][] getCurrentPassable() {
        boolean[][] blArray = new boolean[this.width][this.height];
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                Door door;
                blArray[i][j] = this.entityList.getCreature(i, j) != null ? false : ((door = this.entityList.getDoor(i, j)) != null && !door.isOpen() ? false : this.passable[i][j]);
            }
        }
        return blArray;
    }

    public final boolean isCurrentPassable(int n, int n2) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return false;
        }
        if (this.entityList.getCreature(n, n2) != null) {
            return false;
        }
        Door door = this.entityList.getDoor(n, n2);
        if (door != null && !door.isOpen()) {
            return false;
        }
        return this.passable[n][n2];
    }

    public final boolean isFreeForCreature(int n, int n2) {
        if (!this.isPassable(n, n2)) {
            return false;
        }
        if (this.getCreatureAtGridPoint(n, n2) != null) {
            return false;
        }
        return this.getDoorAtGridPoint(n, n2) == null;
    }

    public final boolean isPassable(int n, int n2) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return false;
        }
        return this.passable[n][n2];
    }

    public void setEntityVisibility() {
        for (Entity entity : this.entityList) {
            if (!(entity instanceof Creature)) continue;
            ((Creature)entity).computeVisibility();
        }
    }

    public void addPlayerCharacters() {
        Entity entity = null;
        Iterator<PC> iterator = Game.curCampaign.party.iterator();
        Iterator<PointImmutable> iterator2 = this.startLocations.iterator();
        while (iterator.hasNext()) {
            Object object;
            Creature creature = iterator.next();
            if (iterator2.hasNext()) {
                object = iterator2.next();
                creature.setLocation(new Location(this, ((PointImmutable)object).x, ((PointImmutable)object).y));
            } else {
                object = AIScriptInterface.findClosestEmptyTile(entity.getLocation().toPoint(), 3);
                if (object != null) {
                    creature.setLocation(new Location(this, ((Point)object).x, ((Point)object).y));
                } else {
                    Logger.appendToErrorLog("Warning: Unable to find enough starting positions for area " + this.id);
                }
            }
            this.entityList.addEntity(creature);
            entity = creature;
        }
    }

    public String getID() {
        return this.id;
    }
}

